var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

/**
 * @file Utility functions for the mobile scheduler app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'jquery', 'underscore', 'mobile/util/time', 'mobile/fieldeditors/mobile/feUtils', 'lex!baja'], function (baja, $, _, timeUtil, feUtils, lexs) {

  "use strict";

  var getBajaTimeFormat = feUtils.getBajaTimeFormat,
      DAY = timeUtil.MILLIS_IN_DAY,
      _lexs = _slicedToArray(lexs, 1),
      bajaLex = _lexs[0];


  var currentSchedule = void 0,
      lastEnteredValue = void 0;

  /**
   * @private
   * @exports mobile/schedule/util.schedule
   */
  var exports = {};

  var getTimeLabels = _.once(function () {
    // Format locale appropriate time labels. This is done lazily
    // so the time format system property will have been loaded from
    // the server.
    return _.map([3, 6, 9, 12, 15, 18, 21], function (val) {
      return baja.Time.make({ hour: val }).toTimeStringSync({
        textPattern: getBajaTimeFormat() | 'HH:mm',
        lex: bajaLex
      });
    });
  });

  /**
   * Converts a pixel distance on a day div into the corresponding time
   * interval. For instance, if pixels === day.jq().height(), then we're
   * converting the entire length of the day and the result will equal
   * MILLIS_IN_DAY.
   * 
   * @param {JQuery} dayDiv the div for the day whose pixels we're converting
   * @param {Number} pixels the number of pixels on the y axis
   */
  exports.pixelsToMillis = function (dayDiv, pixels) {
    return pixels / dayDiv.children('.blocksDisplay').outerHeight() * DAY;
  };

  /**
   * Converts a number of milliseconds into the corresponding y-axis distance
   * on the day div. For instance, if millis === MILLIS_IN_DAY, then this
   * will return a number equal to day.jq().height() since we are converting
   * the entire length of the day.
   *
   * @param {JQuery} dayDiv the div for the day whose time interval we're 
   * converting
   * @param {Number} millis the number of milliseconds to convert to pixels
   */
  exports.millisToPixels = function (dayDiv, millis) {
    return millis / DAY * dayDiv.children('.blocksDisplay').outerHeight();
  };

  /**
   * Converts a number of milliseconds to a percentage of a day. If millis
   * === MILLIS_IN_DAY then this function will return 1.
   *
   * @param {Number} millis milliseconds past midnight
   * @returns {Number} the percentage of a total day
   */
  exports.percentageOfDay = function (millis) {
    return millis / DAY;
  };

  exports.addMonths = function (absTime, months) {
    var date = absTime.getDate(),
        year = date.getYear(),
        month = date.getMonth().getOrdinal() + months;
    if (month === -1) {
      year--;
      month = 11;
    } else if (month === 12) {
      year++;
      month = 0;
    }
    date = baja.Date.DEFAULT.make({
      year: year,
      month: month,
      day: 2
    });

    return baja.AbsTime.make({
      date: date,
      time: baja.Time.make(0)
    });
  };

  //  function printEvent(event) {
  //    return "client: " + event.clientX + "," + event.clientY + " " +
  //      "layer: " + event.layerX + "," + event.layerY + " " +
  //      "offset: " + event.offsetX + "," + event.offsetY + " " +
  //      "page: " + event.pageX + "," + event.pageY + " " +
  //      "screen: " + event.screenX + "," + event.screenY;
  //  }

  exports.appendTimeLabels = function appendTimeLabels(targetElement) {
    var labelsDiv = $('<div class="scheduleLabels" />').appendTo(targetElement);

    getTimeLabels().forEach(function (time, i) {
      var div = $('<div/>').append($('<div class="labelDiv"/>').append($('<label/>').text(time)));
      div.addClass('scheduleLabel scheduleLabel' + i);
      labelsDiv.append(div);
    });

    return labelsDiv;
  };

  exports.getCurrentSchedule = function () {
    return currentSchedule;
  };

  exports.setCurrentSchedule = function (s) {
    currentSchedule = s;
  };

  exports.getLastEnteredValue = function () {
    return lastEnteredValue;
  };

  exports.setLastEnteredValue = function (v) {
    lastEnteredValue = v;
  };

  /**
   * Repositions/resizes a schedule block div to occupy the correct amount of
   * time/space within a day's div.
   * 
   * @param {JQuery} containerDiv the schedule block div
   */
  exports.updateScheduleBlockDiv = function (containerDiv) {
    var block = containerDiv.data('scheduleBlock'),
        start = block.start,
        finish = block.finish,
        value = block.value,
        displayDiv = containerDiv.find('div.display'),
        parentDiv = containerDiv.parent(),
        blockDiv = containerDiv.children('.scheduleBlock'),
        startms = timeUtil.millisOfDay(start),
        stopms = timeUtil.millisOfDay(finish),
        startPct = exports.percentageOfDay(startms),
        stopPct = exports.percentageOfDay(stopms),
        newTop = Math.floor(startPct * parentDiv.height()),
        newBottom = Math.floor(stopPct * parentDiv.height()),
        offset = containerDiv.outerHeight() - containerDiv.height() - 2,
        newHeight;

    if (stopms === 0) {
      //ending at midnight so stretch to bottom
      newBottom = parentDiv.height() + 1;
    }

    currentSchedule.stringify(value).then(function (str) {
      displayDiv.children('span.valueDisplay').text(str);
    });

    displayDiv.children('span.timeDisplay').text('(' + block + ')');

    newHeight = newBottom - newTop - offset;

    containerDiv.css({
      top: newTop,
      height: newHeight
    });

    block.$colors.apply(blockDiv);
  };

  /**
   * Redraws the time labels at the left side of a day/schedule editor ensuring
   * they align properly with the grid lines.
   *
   * @param {JQuery} labelsDiv the div containing the time labels
   * @param {Number} height the height to set the labels div to (should be
   * equivalent to the total height of the day editor's blocks div)
   */
  exports.relayoutLabelsDiv = function (labelsDiv, height) {
    var blockHeight = height / 8;

    labelsDiv.height(height);

    _.range(0, 7).forEach(function (i) {
      var label = labelsDiv.children('div.scheduleLabel' + i);
      label.height(blockHeight);
      label.css('bottom', blockHeight * (6 - i));
    });
  };

  /**
   * Redraws a field editor for a day so it displays correctly given the
   * current visible height.
   * 
   * @param {JQuery} dayDiv the div containing a
   * `niagara.fieldEditors.schedule.DayEditor`
   */
  exports.relayoutDayDiv = function (dayDiv) {
    var blocksDisplayHeight = dayDiv.find('div.blocksDisplay').height(),
        blockHeight = blocksDisplayHeight / 8,
        labelsDiv = dayDiv.siblings('div.scheduleLabels');

    _.range(0, 8).forEach(function (i) {
      var blocks = dayDiv.find('div.block.block' + i);
      blocks.css('top', blockHeight * i);
    });

    if (labelsDiv.length) {
      exports.relayoutLabelsDiv(labelsDiv, blocksDisplayHeight);
    }

    $('.scheduleBlockContainer', dayDiv).each(function () {
      exports.updateScheduleBlockDiv($(this));
    });
  };

  return exports;
});
