/**
 * @file A base class for views used in JQM apps.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/util/mobile/views/MobileView
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget'], function (baja, $, Promise, Widget) {
  "use strict";

  /**
   * A View subclass that includes behavior specific to jQuery Mobile.
   * 
   * @class
   * @alias module:mobile/util/mobile/views/MobileView
   * @extends module:bajaux/Widget
   */

  var MobileView = function MobileView() {
    Widget.apply(this, arguments);
  };
  MobileView.prototype = Object.create(Widget.prototype);
  MobileView.prototype.constructor = MobileView;

  /**
   * Simply calls `enhanceWithin()` to tell JQM to enhance any widgets
   * contained in this view.
   * @param {jQuery} dom
   */
  MobileView.prototype.doInitialize = function (dom) {
    return Promise.resolve(Widget.prototype.doInitialize.call(this, dom)).then(function () {
      //TODO remove - this does nothing. should this run after load or something?
      dom.enhanceWithin();
    });
  };

  return MobileView;
});
