/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/ndriver/rc/column/DiscoveryPropertyMgrColumn
 */
define(['baja!', 'Promise', 'underscore', 'nmodule/ndriver/rc/util/util', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn'], function (baja, Promise, _, util, PropertyPathMgrColumn) {
  'use strict';

  /**
   * PropertyMgrColumn subclass for use with ndriver discovery.
   *
   * @class
   * @alias module:nmodule/ndriver/rc/column/DiscoveryPropertyMgrColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn
   * @param {String} name A unique name for this column
   * @param {String} path A slot path, specified as a '/' delimited string
   * @param {Object} params
   */
  var DiscoveryPropertyMgrColumn = function DiscoveryPropertyMgrColumn(name, path, params) {
    PropertyPathMgrColumn.apply(this, arguments);
    this.$moduleName = params && params.moduleName || '';
    this.$columnIndex = params && params.columnIndex || -1;
  };
  DiscoveryPropertyMgrColumn.prototype = Object.create(PropertyPathMgrColumn.prototype);
  DiscoveryPropertyMgrColumn.prototype.constructor = DiscoveryPropertyMgrColumn;

  /**
   * Returns a diplayName for this column.
   *
   * @returns {Promise.<String>}
   */
  DiscoveryPropertyMgrColumn.prototype.toDisplayName = function () {
    var that = this;

    // 1. if a displayName has been supplied as a parameter, use that.
    if (that.$displayName) {
      return Promise.resolve(that.$displayName);
    }
    return Promise.resolve(that.$moduleName).then(function (moduleNameLexLookup) {
      // 2. try looking up the module's lexicon
      return moduleNameLexLookup ? util.getLexiconForModule(moduleNameLexLookup, that.$name) : undefined;
    }).then(function (moduleLexResult) {
      // 3. return the result if found or try the webEditors module lexicon
      return moduleLexResult || util.getLexiconForModule('webEditors', that.$name);
    }).then(function (lexLookupResult) {
      // 4. return the result if found or last resort, the call the superclass implementation
      return lexLookupResult || PropertyPathMgrColumn.prototype.toDisplayName.apply(that);
    });
  };
  function isGroup(row) {
    return row.getTreeNode().isGroup && row.getTreeNode().isGroup();
  }

  /**
   * Returns the row's value for this column
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {String}
   */
  DiscoveryPropertyMgrColumn.prototype.getValueFor = function (row) {
    if (isGroup(row)) {
      // Show the row description in the first column after the icon
      return this.$columnIndex === 1 ? row.getSubject().getDescription() : '';
    }
    return PropertyPathMgrColumn.prototype.getValueFor.apply(this, arguments);
  };
  return DiscoveryPropertyMgrColumn;
});
