/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/ndriver/rc/column/OutMgrColumn
 */
define(['baja!', 'Promise', 'underscore', 'nmodule/ndriver/rc/util/util', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn'], function (baja, Promise, _, util, MgrColumn) {
  'use strict';

  var DEFAULT_COLUMN_NAME = 'Out',
    LEXICON_KEY = 'out';

  /**
   * MgrColumn subclass that allows the out slot to be shown without specifying
   * a type to pick up a displayName.
   *
   * @class
   * @alias module:nmodule/ndriver/rc/column/OutMgrColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   * @param {Object} params
   */
  var OutMgrColumn = function OutMgrColumn(params) {
    var that = this;
    MgrColumn.call(that, 'out', params);
    if (params.moduleName) {
      that.$moduleName = params.moduleName;
    }
  };
  OutMgrColumn.prototype = Object.create(MgrColumn.prototype);
  OutMgrColumn.prototype.constructor = OutMgrColumn;

  /**
   * Returns a diplayName for this column.
   *
   * @returns {Promise.<String>}
   */
  OutMgrColumn.prototype.toDisplayName = function () {
    var that = this;

    // 1. if a displayName has been supplied as a parameter, use it.
    if (that.$displayName) {
      return Promise.resolve(that.$displayName);
    }
    return Promise.resolve(that.$moduleName).then(function (moduleNameLexLookup) {
      // 2. try looking up the module's lexicon
      return moduleNameLexLookup ? util.getLexiconForModule(moduleNameLexLookup, LEXICON_KEY) : undefined;
    }).then(function (moduleLexResult) {
      // 3. return the result if found or try the driver module lexicon
      return moduleLexResult || util.getLexiconForModule('driver', LEXICON_KEY);
    }).then(function (driverLexResult) {
      // 4. return the result if found or last resort, the default name
      return driverLexResult || DEFAULT_COLUMN_NAME;
    });
  };

  /**
   * Returns the value represented by this row.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {*}
   */
  OutMgrColumn.prototype.getValueFor = function (row) {
    return String(row.getSubject());
  };
  return OutMgrColumn;
});
