function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/ValueWithSummaryWidget
 */
define(['bajaux/spandrel', 'Promise', 'nmodule/webEditors/rc/fe/fe'], function (spandrel, Promise, fe) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-ValueWithSummaryWidget ux-fullscreen',
        config: {}
      }
    };
  };

  /**
   * A field editor for providing a summary text with another field editor.
   *
   * The construction of the inner field editor can be configured by passing a `getConfig` function
   * as a Widget property. It should return an object of type
   * {@link module:bajaux/lifecycle/WidgetManager~BuildParams}.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/ValueWithSummaryWidget
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @since Niagara 4.13
   */
  var ValueWithSummaryWidget = /*#__PURE__*/function (_spandrel) {
    function ValueWithSummaryWidget(params) {
      _classCallCheck(this, ValueWithSummaryWidget);
      return _callSuper(this, ValueWithSummaryWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(ValueWithSummaryWidget, _spandrel);
    return _createClass(ValueWithSummaryWidget, [{
      key: "doSave",
      value: function doSave() {
        return this.getInnerValueEditor().save();
      }
    }, {
      key: "doRead",
      value: function doRead() {
        return this.getInnerValueEditor().read();
      }

      /**
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "getInnerValueEditor",
      value: function getInnerValueEditor() {
        return this.queryWidget('value');
      }
    }]);
  }(spandrel(function (value, _ref) {
    var properties = _ref.properties;
    var summary = properties.summary,
      _properties$getConfig = properties.getConfig,
      getConfig = _properties$getConfig === void 0 ? function () {
        return {};
      } : _properties$getConfig;
    /*
    using a function for this, because a BuildParams object very often has a "value" property which
    makes bajaux think that the object itself is a Property and not a BuildParams.
     */
    var config = getConfig();
    return resolveConstructor(value, config).then(function (Ctor) {
      return [spandrel.jsx("div", {
        className: "-t-ValueWithSummaryWidget-summary-wrapper ux-fixed-header"
      }, spandrel.jsx("div", {
        className: "-t-ValueWithSummaryWidget-summary"
      }, summary)),
      // if constructor is absent, spandrel uses the widget manager to look
      // up the type dynamically. IOW: when Ctor is null, it works the same as <any>.
      spandrel.jsx(Ctor, {
        className: "-t-ValueWithSummaryWidget-value ux-body",
        spandrelKey: "value",
        value: value,
        formFactor: config.formFactor,
        properties: config.properties,
        readonly: config.readonly,
        enabled: config.enabled,
        validate: true
      })];
    });
  }, {
    strategy: 'niagara'
  }));
  function resolveConstructor(value, config) {
    return fe.params(Object.assign({
      value: value
    }, config)).then(function (params) {
      return params.getWidgetConstructor();
    });
  }
  return ValueWithSummaryWidget;
});
