function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */
/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/CredentialStoreEditor
 */
define(['baja!', 'baja!baja:ClientCredentials,baja:CertificateAliasCredential,baja:UsernameAndPassword,baja:Password', 'lex!webEditors', 'log!nmodule/webEditors/rc/fe/baja/CredentialStoreEditor', 'underscore', 'bajaux/events', 'bajaux/spandrel', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/registry/StationRegistry', 'nmodule/webEditors/rc/servlets/registry', 'bajaux/mixin/subscriberMixIn'], function (baja, types, lexs, log, _, events, spandrel, Promise, fe, OrderedMapEditor, StationRegistry, registry, subscriberMixin) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var logSevere = log.severe.bind(log);
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-CredentialStoreEditor'
      }
    };
  };
  var once = _.once;
  var editors = new baja.OrderedMap();
  var loadEditors = once(function () {
    return registry.getTypes({
      targetType: 'webEditors:IUserCredentialsEditor'
    }).then(function (types) {
      for (var i = 0; i < types.length; i++) {
        var entry = types[i];
        var displayName = entry.displayName;
        var type = entry.type;
        if (type.equals("webEditors:IUserCredentialsEditor")) {
          continue;
        }
        var wrkArr = entry.type.split(":");
        var lexName = webEditorsLex.get("CredentialStoreEditor." + wrkArr[1]);
        if (!lexName) {
          displayName = displayName.substring(0, displayName.lastIndexOf(" Editor"));
        } else {
          displayName = lexName;
        }
        editors.put(displayName, wrkArr[1]);
      }
    });
  });

  /**
   * A field editor for selecting an user and security certificate
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/CredentialStoreEditor
   * @extends module:bajaux/Widget
   **/
  var CredentialStoreEditor = /*#__PURE__*/function (_spandrel) {
    function CredentialStoreEditor(params) {
      var _this;
      _classCallCheck(this, CredentialStoreEditor);
      _this = _callSuper(this, CredentialStoreEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      subscriberMixin(_this);
      return _this;
    }
    _inherits(CredentialStoreEditor, _spandrel);
    return _createClass(CredentialStoreEditor, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.on(events.MODIFY_EVENT, '.-t-CredentialStoreEditor-credentialType', function () {
          _this2.$getCredentialTypeWidget().read().then(function (certificateType) {
            return _this2.$updateCredentialType(certificateType);
          })["catch"](logSevere);
        });
        return _superPropGet(CredentialStoreEditor, "doInitialize", this, 3)(arguments);
      }

      /**
       * @private
       * @param {String} selectedEditor
       * @return {Promise}
       * */
    }, {
      key: "$updateCredentialType",
      value: function $updateCredentialType(selectedEditor) {
        var credentialStore = baja.$("baja:ClientCredentials");
        var clientCredentials;
        switch (selectedEditor) {
          case 'UsernameAndPasswordEditor':
            var usernameAndPassword = baja.$('baja:UsernameAndPassword');
            credentialStore.setClientCredentials(usernameAndPassword);
            clientCredentials = usernameAndPassword;
            break;
          case 'CertificateAliasCredentialEditor':
            var certificateAlias = baja.$('baja:CertificateAliasCredential');
            credentialStore.setClientCredentials(certificateAlias);
            clientCredentials = certificateAlias;
            break;
          default:
            throw new Error("Unsupported certificate type");
        }
        this.$modifiedCredential = clientCredentials;
        return this.load(this.value());
      }

      /**
       * @private
       * @param {baja.Component} credentialStore a `baja:ClientCredentials` instance
       * @returns {Promise.<object>}
       */
    }, {
      key: "$buildEditor",
      value: function $buildEditor(credentialStore) {
        var _this3 = this;
        var credential = credentialStore.getClientCredentials();
        if (this.$modifiedCredential) {
          credential = this.$modifiedCredential;
        }
        var credentialType = this.$credentialType = credential.getType();
        var key = "";
        var reg = StationRegistry.getInstance();
        var page = Promise.all([reg.resolveFirst(credentialType, {
          type: ['webEditors:IUserCredentialsEditor']
        })]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 1),
            Constructor = _ref2[0];
          if (Constructor) {
            var factory = new Constructor();
            key = _this3.$key = factory.$keyName;
          }
          return spandrel.jsx("table", {
            spandrelKey: "layout"
          }, spandrel.jsx("tr", {
            spandrelKey: "row1"
          }, spandrel.jsx("td", {
            spandrelKey: "col1"
          }, spandrel.jsx(OrderedMapEditor, {
            className: "-t-CredentialStoreEditor-credentialType",
            value: editors,
            spandrelKey: "credentialType",
            properties: {
              selectedValue: key
            }
          }))), spandrel.jsx("tr", {
            spandrelKey: "row2"
          }, spandrel.jsx("td", {
            spandrelKey: "col1"
          }, spandrel.jsx("any", {
            className: "-t-CredentialStoreEditor-editor",
            spandrelKey: "editor",
            value: credential
          }))));
        })["catch"](logSevere);
        return page;
      }

      /**
       * @private
       */
    }, {
      key: "$getCredentialTypeWidget",
      value: function $getCredentialTypeWidget() {
        return this.queryWidget('layout/row1/col1/credentialType');
      }

      /**
       * @private
       */
    }, {
      key: "$getEditorWidget",
      value: function $getEditorWidget() {
        return this.queryWidget('layout/row2/col1/editor');
      }
    }, {
      key: "doLoad",
      value: function doLoad() {
        var _this4 = this;
        return _superPropGet(CredentialStoreEditor, "doLoad", this, 3)(arguments).then(function () {
          _this4.$getCredentialTypeWidget().setSelectedValue(_this4.$key, true);
        });
      }
    }, {
      key: "doRead",
      value: function doRead() {
        return this.$getEditorWidget().read().then(function (credentials) {
          var clientCredentials = baja.$("baja:ClientCredentials");
          clientCredentials.setClientCredentials(credentials);
          return clientCredentials;
        });
      }
    }, {
      key: "doSave",
      value: function doSave(readCredential) {
        var loadedCredential = this.value();
        var clientCredentials = readCredential.getClientCredentials();
        return loadedCredential.setClientCredentials(clientCredentials.newCopy(false));
      }
    }]);
  }(spandrel(function (credentialStore) {
    var _this5 = this;
    return loadEditors().then(function () {
      return _this5.$buildEditor(credentialStore);
    });
  }, {
    strategy: 'niagara'
  }));
  return CredentialStoreEditor;
});
