function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 * @author Nutan Naik
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/DefaultPasswordEditor
 * @since Niagara 4.13
 */
define(['baja!', 'bajaux/spandrel', 'bajaux/Widget', 'lex!workbench', 'Promise', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/webEditors/rc/fe/baja/PasswordEditor'], function (baja, spandrel, Widget, lexs, Promise, BooleanEditor, PasswordEditor) {
  'use strict';

  var Password = require('bajaScript/baja/obj/Password');
  var _lexs = _slicedToArray(lexs, 1),
    WB_LEX = _lexs[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-DefaultPasswordEditor'
      }
    };
  };

  /**
   * Editor for Certificate alias password Editor with use global checkbox
   * supports the following `bajaux` `Properties`:
   *
   * - `placeholderText`: sets the placeholdeText in the password field editor
   * - `prelabel`: sets the prelabel text value of the password field editor
   *
   * @class
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @alias module:nmodule/webEditors/rc/fe/baja/DefaultPasswordEditor
   */
  var DefaultPasswordEditor = /*#__PURE__*/function (_spandrel) {
    function DefaultPasswordEditor(params) {
      _classCallCheck(this, DefaultPasswordEditor);
      return _callSuper(this, DefaultPasswordEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * Clears the placeholder text, this needs to be cleared whenever the checkboxEditor or passwordEditor
     * widget is changed.
     * @private
     */
    _inherits(DefaultPasswordEditor, _spandrel);
    return _createClass(DefaultPasswordEditor, [{
      key: "$clearPlaceHolderText",
      value: function $clearPlaceHolderText() {
        this.$getPasswordEditorWidget().jq().find('input').attr('placeholder', "");
      }

      /**
       * @returns {Promise.<module:baja/obj/Password>}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var _this = this;
        return this.$getBooleanEditorWidget().read().then(function (checked) {
          return !checked ? _this.$getPasswordEditorWidget().read() : Password.DEFAULT;
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getBooleanEditorWidget",
      value: function $getBooleanEditorWidget() {
        return Widget["in"](this.jq().find('.-t-DefaultPasswordEditor-defaultPassword-checkbox'));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPasswordEditorWidget",
      value: function $getPasswordEditorWidget() {
        return Widget["in"](this.jq().find('.-t-DefaultPasswordEditor-defaultPassword-editor'));
      }
    }]);
  }(spandrel(function (value, _ref) {
    var properties = _ref.properties,
      self = _ref.self;
    var placeholderText = properties.placeholderText || '';
    var prelabel = properties.prelabel || '';
    var checkBoxText = WB_LEX.get('default.password.checkbox.label');
    return Promise.all([baja.Format.format(placeholderText), baja.Format.format(prelabel)]).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        formattedPlaceholderText = _ref3[0],
        formattedPrelabel = _ref3[1];
      return [spandrel.jsx(PasswordEditor, {
        className: "-t-DefaultPasswordEditor-defaultPassword-editor",
        lax: "true",
        properties: {
          placeholder: formattedPlaceholderText,
          prelabel: formattedPrelabel
        },
        onUxModifiedValue: function onUxModifiedValue(modifiedValue) {
          self.$clearPlaceHolderText();
        }
      }), spandrel.jsx("span", {
        className: "-t-DefaultPasswordEditor-defaultPassword-checkbox-div"
      }, spandrel.jsx(BooleanEditor, {
        className: "-t-DefaultPasswordEditor-defaultPassword-checkbox",
        value: false,
        onUxModifiedValue: function onUxModifiedValue(modifiedValue) {
          self.$getPasswordEditorWidget().setEnabled(!modifiedValue);
          self.$clearPlaceHolderText();
        },
        properties: {
          displayType: 'checkbox',
          trueText: checkBoxText,
          falseText: checkBoxText
        },
        spandrelKey: "checkbox"
      }))];
    });
  }));
  return DefaultPasswordEditor;
});
