function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/NameListEditor
 */
define(['baja!', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/util/CommandButtonGroup', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder'], function (baja, Widget, Command, CommandButtonGroup, $, Promise, _, CompositeEditor, fe, feDialogs, DisplayOnlyEditor, CompositeBuilder) {
  'use strict';

  var NameList = baja.NameList;

  /**
   * Command to add a new string to the NameList.
   *
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   * @param {module:nmodule/webEditors/rc/fe/baja/NameListEditor} ed
   */
  var AddCommand = function AddCommand(ed) {
    Command.call(this, {
      module: 'alarm',
      lex: 'commands.addMsg',
      func: function func() {
        return feDialogs.showFor({
          value: ''
        }).then(function (str) {
          if (!str) {
            return;
          }
          return ed.read().then(function (nameList) {
            return ed.doLoad(nameList.union(NameList.make(baja.SlotPath.escape(str))));
          });
        });
      }
    });
  };
  AddCommand.prototype = Object.create(Command.prototype);
  AddCommand.prototype.constructor = AddCommand;

  /**
   * Command to remove the selected name from the name list.
   *
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   * @param {module:nmodule/webEditors/rc/fe/baja/NameListEditor} ed
   */
  var RemoveCommand = function RemoveCommand(ed) {
    Command.call(this, {
      module: 'alarm',
      lex: 'commands.removeMsg',
      func: function func() {
        var focusedEd = ed.$focusedEditor;
        if (focusedEd) {
          return Promise.all([focusedEd.read(), ed.read()]).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              toRemove = _ref2[0],
              nameList = _ref2[1];
            return ed.doLoad(nameList.difference(NameList.make(toRemove)));
          });
        }
      }
    });
  };
  RemoveCommand.prototype = Object.create(Command.prototype);
  RemoveCommand.prototype.constructor = RemoveCommand;

  /**
   * Editor for handling `baja:NameList` values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/NameListEditor
   */
  var NameListEditor = function NameListEditor(params) {
    var that = this;
    CompositeEditor.apply(that, arguments);
    if (that.getFormFactor() === Widget.formfactor.mini) {
      DisplayOnlyEditor.$mixin(that);
    }
    that.getCommandGroup().add(new AddCommand(that), new RemoveCommand(that));
  };
  NameListEditor.prototype = Object.create(CompositeEditor.prototype);
  NameListEditor.prototype.constructor = NameListEditor;

  /**
   * @private
   * @returns {module:bajaux/commands/Command}
   */
  NameListEditor.prototype.$getAddCommand = function () {
    return this.getCommandGroup().get(0);
  };

  /**
   * @private
   * @returns {module:bajaux/commands/Command}
   */
  NameListEditor.prototype.$getRemoveCommand = function () {
    return this.getCommandGroup().get(1);
  };

  /**
   * @private
   * @returns {module:bajaux/util/CommandButtonGroup}
   */
  NameListEditor.prototype.$getCommandButtonGroup = function () {
    return this.jq().children('.CommandButtonGroup').data('widget');
  };

  /**
   * @private
   * @returns {jQuery}
   */
  NameListEditor.prototype.$getEditorsElement = function () {
    return this.jq().children('.editors');
  };

  /**
   * When in mini/display-only mode, display the unescaped names.
   *
   * @param {baja.NameList} nameList
   * @returns {string}
   */
  NameListEditor.prototype.valueToString = function (nameList) {
    return _.map(nameList.getNames(), baja.SlotPath.unescape).join('; ');
  };

  /**
   * Configures the composite builder for the loaded `NameList`. Keys will
   * correspond to the indexes in the array of all names, and values will be
   * the SlotPath-unescaped names.
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */
  NameListEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getDomFor = function (i) {
      return $('<div/>').appendTo(that.$getEditorsElement());
    };
    builder.getKeys = function () {
      return _.map(this.getDataSource().getNames(), function (inst, i) {
        return String(i);
      });
    };
    builder.getValueFor = function (i) {
      return baja.SlotPath.unescape(this.getDataSource().getNames()[i]);
    };
    builder.getConfigFor = function () {
      return {
        formFactor: 'mini'
      };
    };
    return builder;
  };

  /**
   * Arm event handlers for managing the currently-focused `String` editor, and
   * build a `CommandButtonGroup` to show the editor's commands.
   * @param {JQuery} dom
   */
  NameListEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.append('<div class="editors"/>');
    dom.on('focus', '.editors .type-baja-String', function () {
      var $this = $(this);
      that.$getEditorsElement().children().removeClass('ux-bg');
      $this.addClass('ux-bg');
      that.$focusedEditor = $this.data('widget');
    });
    return Promise.all([fe.buildFor({
      dom: $('<div class="editor"/>').appendTo(dom),
      type: CommandButtonGroup,
      value: this.getCommandGroup()
    }), CompositeEditor.prototype.doInitialize.apply(this, arguments)]);
  };

  /**
   * Read all entered strings, SlotPath-escape them, and assemble them into a
   * `baja:NameList` instance.
   * @returns {Promise}
   */
  NameListEditor.prototype.doRead = function () {
    return this.getBuilder().readAll().then(function (names) {
      return NameList.make(_.map(names, baja.SlotPath.escape));
    });
  };

  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */
  NameListEditor.prototype.doDestroy = function () {
    return this.getChildWidgets().destroyAll();
  };

  /**
   * Set all child editors readonly/writable.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  NameListEditor.prototype.doReadonly = function (readonly) {
    return this.getChildWidgets().setAllReadonly(readonly);
  };

  /**
   * Set all child editors enabled/disabled.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  NameListEditor.prototype.doEnabled = function (enabled) {
    return this.getChildWidgets().setAllEnabled(enabled);
  };
  return NameListEditor;
});
