function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/OrderedMapEditor
 */
define(['baja!', 'lex!', 'underscore', 'Promise', 'bajaux/icon/iconUtils', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/util/htmlUtils'], function (baja, lex, _, Promise, iconUtils, BaseEditor, htmlUtils) {
  'use strict';

  var escapeHtml = htmlUtils.escapeHtml;

  /**
   * An editor for working with `OrderedMap`s. Since an `OrderedMap` is not a
   * `baja.Value`, this is not really a field editor; rather more of a UI
   * component for generating select dropdowns on the fly.
   *
   * This editor supports the following Properties:
   *
   * - `lexicon`: have the display values passed through the lexicon of a
   *   particular module. This will first look at the key directly. If no value is found, it will
   *   try to use the `.displayName` or `.label` suffixes with `.displayName` taking precedence.
   * - `getDisplayText()`: (since Niagara 4.14) pass a function that receives the loaded OrderedMap
   *   and a key, and returns or resolves the display text for that key. Will take precedence over
   *   `lexicon`.
   * - `lexiconIcons`: if set to true, the OrderedMapEditor will display an icon alongside the text
   *   based upon the value of the lexicon key with `.icon` on the end.
   * - `sortKeys`: set to `true` to cause the keys to be sorted before adding
   *   them to the dropdown.
   * - `map`: set to a `baja.OrderedMap` instance (or an object or array to be
   *   converted to an OrderedMap) to use that as the map of values for the user
   *   to choose from. This allows `load()` to be called with any value in that
   *   map.
   *
   *
   * Note that `baja.OrderedMap` is considered private API.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor
   */
  var OrderedMapEditor = function OrderedMapEditor() {
    BaseEditor.apply(this, arguments);
  };
  OrderedMapEditor.prototype = Object.create(BaseEditor.prototype);
  OrderedMapEditor.prototype.constructor = OrderedMapEditor;

  /**
   * Return the select dropdown element.
   *
   * @private
   * @returns {JQuery}
   */
  OrderedMapEditor.prototype.$getSelect = function () {
    return this.jq().children('select');
  };

  /**
   * Return the icon span.
   *
   * @private
   * @returns {JQuery}
   */
  OrderedMapEditor.prototype.$getIconSpan = function () {
    return this.jq().children(".ux-currentValue-icon");
  };

  /**
   * Creates a select dropdown element.
   *
   * @param {JQuery} dom
   */
  OrderedMapEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.addClass('OrderedMapEditor');

    //TODO: make hbs template
    dom.html('<span class="ux-currentValue-icon"></span><select class="ux-select" />');
    dom.on('change', 'select', function () {
      that.setModified(true);
      that.$updateIcon();
    });
  };

  /**
   * Loads the `baja.OrderedMap` into the select dropdown. Create an `<option>`
   * for each key-value pair in the map.
   *
   * @param {baja.OrderedMap|Array|*} value the OrderedMap, an object literal
   * to be converted to an OrderedMap, an array to be converted to an OrderedMap
   * (each entry will be toStringed to its display string), or a raw value that
   * exists in the `map` property, if present
   * @param {Object} [params] params passed into `load()` method
   * @param {String} [params.selectedKey] a key to preselect
   * @param {*} [params.selectedValue] a value to preselect (overrides
   * `selectedKey` if both are present)
   */
  OrderedMapEditor.prototype.doLoad = function (value, params) {
    var _this = this;
    var p = params || {};
    var map = value;
    var selectedKey = p.selectedKey;
    var selectedValue = p.selectedValue;
    if (value.constructor === Object || Array.isArray(value)) {
      map = toOrderedMap(value);
    } else if (!(value instanceof baja.OrderedMap)) {
      map = toOrderedMap(this.properties().getValue('map') || _defineProperty({}, value, value));
      selectedValue = value;
    }
    this.$map = map;
    var select = this.$getSelect();
    var keys = map.getKeys();
    var val;
    if (this.properties().getValue('sortKeys')) {
      keys.sort();
    }
    return Promise.all(keys.map(function (key) {
      return Promise.all([_this.$getDisplayText(map, key), _this.$getDisplayIcon(map, key)]).then(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
          text = _ref3[0],
          icon = _ref3[1];
        var v = map.get(key);
        if (key === selectedKey) {
          val = key;
        }
        if (selectedValue !== undefined && selectedValue !== null && $isEqual(v, selectedValue)) {
          val = key;
        }
        var valueImageString = icon ? ' valueImage="' + icon + '"' : '';
        return '<option class="ux-option"' + valueImageString + ' value="' + escapeHtml(key) + '">' + escapeHtml(text) + '</option>';
      });
    })).then(function (options) {
      select.html(options.join(''));
      if (val !== undefined) {
        select.val(val);
        _this.$updateIcon()["catch"](baja.error);
      }
    });
  };

  /**
   * @private
   * @param {baja.Value|any} source
   * @param {baja.Value|any} target
   * @returns {boolean}
   */
  function $isEqual(source, target) {
    if (baja.hasType(source) && baja.hasType(target)) {
      return source.equals(target);
    }
    return source === target;
  }

  /**
   * @private
   * @param {baja.OrderedMap} map
   * @param {String} key
   * @returns {string|Promise.<string>}
   */
  OrderedMapEditor.prototype.$getDisplayText = function (map, key) {
    var props = this.properties();
    var getDisplayText = props.getValue('getDisplayText');
    if (getDisplayText) {
      return getDisplayText(map, key);
    }
    var lexicon = props.getValue('lexicon');
    if (!lexicon) {
      return key;
    } else {
      return lex.module(lexicon).then(function (lex) {
        return lex.get(key) || lex.get("".concat(key, ".displayName")) || lex.get("".concat(key, ".label")) || key;
      });
    }
  };

  /**
   * @private
   * @param {baja.OrderedMap} map
   * @param {String} key
   * @returns {string|Promise.<string>}
   */
  OrderedMapEditor.prototype.$getDisplayIcon = function (map, key) {
    var props = this.properties();
    var lexicon = props.getValue('lexicon');
    var lexiconIcons = props.getValue('lexiconIcons');
    if (lexicon && lexiconIcons) {
      return lex.module(lexicon).then(function (lex) {
        return lex.get(key + ".icon") || '';
      });
    } else {
      return '';
    }
  };

  /**
   *
   * @return {Promise}
   */
  OrderedMapEditor.prototype.$updateIcon = function () {
    var that = this;
    var imageSpan = that.$getIconSpan();
    var image = this.$getSelect().children("option:selected").attr('valueImage');
    if (!image) {
      return Promise.resolve(imageSpan.html(""));
    } else {
      return iconUtils.toHtml(baja.Ord.make(image)).then(function (html) {
        imageSpan.html(html);
      });
    }
  };

  /**
   * Returns the currently selected key.
   * @returns {String} currently selected key, or undefined if none
   */
  OrderedMapEditor.prototype.getSelectedKey = function () {
    return this.$getSelect().val();
  };

  /**
   * Sets the currently selected key. This will trigger a `MODIFY_EVENT`.
   *
   * @param {String} key
   * @param {Boolean} [silent] set to true if the `MODIFY_EVENT` should not be
   * triggered.
   */
  OrderedMapEditor.prototype.setSelectedKey = function (key, silent) {
    var select = this.$getSelect();
    select.val(key);
    if (!silent) {
      select.trigger('change');
    }
  };

  /**
   * Returns the currently selected value or null if nothing selected yet.
   *
   * @returns {*|null}
   */
  OrderedMapEditor.prototype.getSelectedValue = function () {
    var map = this.$map;
    return map ? map.get(this.getSelectedKey()) : null;
  };

  /**
   * Returns an array of all keys that map to the given value.
   *
   * @param {*} value
   * @returns {Array.<String>} keys
   */
  OrderedMapEditor.prototype.getKeysFor = function (value) {
    var map = this.$map,
      keys = map.getKeys();
    return _.compact(_.map(keys, function (key) {
      return map.get(key) === value && key;
    }));
  };

  /**
   * Sets the currently selected value. This will trigger a `MODIFY_EVENT`.
   *
   * @param {*} value
   * @param {Boolean} [silent] set to true if the `MODIFY_EVENT` should not be
   * triggered.
   */
  OrderedMapEditor.prototype.setSelectedValue = function (value, silent) {
    var that = this,
      map = that.$map;
    _.some(map.getKeys(), function (key) {
      if (map.get(key) === value) {
        var select = that.$getSelect();
        select.val(key);
        if (!silent) {
          select.trigger('change');
        }
      }
    });
  };

  /**
   * Get the currently selected value from the `baja.OrderedMap`. This will not
   * just return the `value` attribute of the currently selected `<option>`
   * but will retrieve the actual value from the map.
   *
   * @returns {undefined|*} the currently selected value, or undefined if
   * no values are available from the currently loaded `baja.OrderedMap`
   * @throws {Error} if somehow the selected key does not exist in the loaded
   * map
   */
  OrderedMapEditor.prototype.doRead = function () {
    var map = this.$map,
      key = this.getSelectedKey();
    if (!map || map.getSize() === 0) {
      return undefined;
    } else if (map.contains(key)) {
      return map.get(key);
    } else {
      throw new Error('selected key ' + key + ' not contained in map');
    }
  };

  /**
   * Enables/disables the select dropdown.
   *
   * @param {Boolean} enabled
   */
  OrderedMapEditor.prototype.doEnabled = function (enabled) {
    this.$getSelect().prop('disabled', this.isReadonly() || !enabled);
  };

  /**
   * Disables/enables the select dropdown.
   *
   * @param {Boolean} readonly
   */
  OrderedMapEditor.prototype.doReadonly = function (readonly) {
    this.$getSelect().prop('disabled', !this.isEnabled() || readonly);
  };

  /**
   * @returns {Promise}
   */
  OrderedMapEditor.prototype.doDestroy = function () {
    this.jq().removeClass('OrderedMapEditor');
    return BaseEditor.prototype.doDestroy.apply(this, arguments);
  };
  function toOrderedMap(obj) {
    if (obj instanceof baja.OrderedMap) {
      return obj;
    }
    var map = new baja.OrderedMap();
    if (Array.isArray(obj)) {
      obj.forEach(function (v) {
        map.put(String(v), v);
      });
    } else {
      Object.keys(obj).forEach(function (k) {
        return map.put(k, obj[k]);
      });
    }
    return map;
  }
  return OrderedMapEditor;
});
