/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/PermissionsGridEditor
 */
define(['baja!', 'bajaux/events', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/PermissionsRowEditor', 'jquery', 'lex!bajaui', 'hbs!nmodule/webEditors/rc/fe/baja/template/PermissionsTable'], function (baja, events, Widget, BaseEditor, fe, PermissionsRowEditor, $, lexs, tplTable) {
  'use strict';

  var bajauiLex = lexs[0],
    MODIFY_EVENT = events.MODIFY_EVENT,
    PERMISSIONS_GRID_SELECTOR = '.permissionsGridContent',
    PERMISSIONS_ROW_SELECTOR = '.permissionsGridContent > tr';

  /**
   * A field editor for working with baja.Permissions
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/PermissionsGridEditor
   */
  var PermissionsGridEditor = function PermissionsGridEditor(params) {
    var that = this;
    BaseEditor.call(that, $.extend(true, {
      keyName: 'PermissionsGridEditor'
    }, params));
  };
  PermissionsGridEditor.prototype = Object.create(BaseEditor.prototype);
  PermissionsGridEditor.prototype.constructor = PermissionsGridEditor;

  /**
   * Creates a PermissionsMap element.
   *
   * @param {JQuery} dom
   */
  PermissionsGridEditor.prototype.doInitialize = function (dom) {
    var that = this,
      permissionsGrid;
    dom.html(tplTable({
      showRowDescription: false,
      operator: bajauiLex.get('security.operator'),
      admin: bajauiLex.get('security.admin'),
      read: bajauiLex.get('security.r'),
      write: bajauiLex.get('security.w'),
      invoke: bajauiLex.get('security.i')
    }));

    //if a row is modified, set myself modified
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    permissionsGrid = dom.find(PERMISSIONS_GRID_SELECTOR);
    return fe.buildFor({
      dom: $('<tr class="ux-table-row" />').appendTo(permissionsGrid),
      type: PermissionsRowEditor,
      value: baja.Permissions.none,
      // default value, the actual value will be loaded in doLoad.
      formFactor: 'mini'
    });
  };

  /**
   * Return the permissions row editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/PermissionsRowEditor}
   */
  PermissionsGridEditor.prototype.$getPermissionsRowEditor = function () {
    // noinspection JSValidateTypes
    return Widget["in"](this.jq().find(PERMISSIONS_ROW_SELECTOR));
  };

  /**
   * Loads the given baja.Permissions into the editor.
   *
   * @param {baja.Permissions} permissions
   * @returns {Promise}
   */
  PermissionsGridEditor.prototype.doLoad = function (permissions) {
    return this.$getPermissionsRowEditor().load(permissions);
  };

  /**
   * Read the baja.Permissions from the permissions row editor
   *
   * @returns {Promise.<baja.Permissions>} promise to be resolved with a `baja.Permissions` value
   */
  PermissionsGridEditor.prototype.doRead = function () {
    return this.$getPermissionsRowEditor().read();
  };

  /**
   * Destroys all child editors.
   *
   * @returns {Promise} promise to be resolved when all child editors
   * have been destroyed
   */
  PermissionsGridEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return PermissionsGridEditor;
});
