function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/PermissionsMapEditor
 */
define(['baja!', 'log!nmodule.webEditors.rc.fe.baja.PermissionsMapEditor', 'bajaux/events', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/util/userUtils', 'nmodule/webEditors/rc/fe/fe', 'lex!webEditors'], function (baja, log, events, $, Promise, BaseEditor, userUtils, fe, lexs) {
  'use strict';

  var logError = log.severe.bind(log);
  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var MODIFY_EVENT = events.MODIFY_EVENT;
  var resolveCurrentUser = userUtils.resolveCurrentUser;
  var CHECKBOX_TEXT = webEditorsLex.get('superUser');
  var SUPER_USER_STRING_ENCODING = baja.PermissionsMap.SUPER_USER.encodeToString();
  var DEFAULT_STRING_ENCODING = baja.PermissionsMap.DEFAULT.encodeToString();

  /**
   * A field editor for working with a PermissionsMap.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/PermissionsMapEditor
   */
  var PermissionsMapEditor = function PermissionsMapEditor(params) {
    var that = this;
    BaseEditor.call(that, $.extend(true, {
      keyName: 'PermissionsMapEditor'
    }, params));
  };
  PermissionsMapEditor.prototype = Object.create(BaseEditor.prototype);
  PermissionsMapEditor.prototype.constructor = PermissionsMapEditor;

  /**
   * Creates a PermissionsMap element.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  PermissionsMapEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.on(MODIFY_EVENT, '.superUser', function (e, ed) {
      ed.read().then(function (isSuperUser) {
        return Promise.all([that.$getStringEncodingEditor().load(isSuperUser ? SUPER_USER_STRING_ENCODING : DEFAULT_STRING_ENCODING)]);
      }).then(function () {
        that.setModified(true);
        return that.$update();
      })["catch"](logError);
      return false;
    });
    return Promise.all([fe.buildFor({
      dom: $('<span class="superUser"/>').appendTo(dom),
      value: false,
      // default value, the actual value will be loaded in doLoad.
      properties: {
        trueText: CHECKBOX_TEXT,
        falseText: CHECKBOX_TEXT
      },
      formFactor: 'mini'
    }).then(function (booleanEditor) {
      that.$superUserEditor = booleanEditor;
    }), fe.buildFor({
      dom: $('<span class="stringEncoding"/>').appendTo(dom),
      value: '',
      // default value, the actual value will be loaded in doLoad.
      formFactor: 'mini'
    }).then(function (stringEditor) {
      that.$stringEncodingEditor = stringEditor;
      return stringEditor.setReadonly(true);
    })]);
  };

  /**
   * updates the editor using the current baja.PermissionsMap.
   * @private
   * @returns {Promise}
   */
  PermissionsMapEditor.prototype.$update = function () {
    var that = this;
    return that.$getCurrentUser().then(function (currentUser) {
      // super user check box is only enabled if currentUser is a super user.
      // (currentUser is null if there were any problems looking it up)
      var currentUserPermissions = currentUser && currentUser.get('permissions'),
        allowCheckboxToBeEnabled = false;
      if (!currentUser || !currentUserPermissions) {
        // If we couldn't find the user, behave as if the current user is a super user,
        // the station side check will prevent setting permissions that the user isn't allowed to.
        allowCheckboxToBeEnabled = true;
      } else {
        allowCheckboxToBeEnabled = currentUserPermissions.isSuperUser();
      }
      that.$allowCheckboxToBeEnabled = allowCheckboxToBeEnabled;
      return Promise.all([
      // hide the string encoding if the superUser checkbox is checked
      that.$getSuperUserEditor().read().then(function (isSuperUser) {
        that.$getStringEncodingElement().css('visibility', isSuperUser ? 'hidden' : 'visible');
      }), that.setEnabled(that.isEnabled())]);
    });
  };
  PermissionsMapEditor.prototype.$getCurrentUser = function () {
    return this.getOrdBase().then(resolveCurrentUser);
  };

  /**
   * Loads the given baja.PermissionsMap into the editor.
   *
   * @param {baja.PermissionsMap} permissionsMap
   */
  PermissionsMapEditor.prototype.doLoad = function (permissionsMap) {
    var that = this;
    return Promise.all([that.$superUserEditor.load(permissionsMap.isSuperUser()), that.$stringEncodingEditor.load(permissionsMap.encodeToString())]).then(function () {
      return that.$update();
    });
  };

  /**
   * Read the individual child editors and assemble them into a `PermissionsMap`
   *
   * @returns {Promise.<baja.PermissionsMap>} promise to be resolved with a `baja.PermissionsMap` value
   */
  PermissionsMapEditor.prototype.doRead = function () {
    var that = this;
    return that.$getStringEncodingEditor().read().then(function (stringEncoding) {
      return baja.PermissionsMap.DEFAULT.decodeFromString(stringEncoding);
    });
  };

  /**
   * Return the stringEncoding element.
   *
   * @private
   * @returns {JQuery}
   */
  PermissionsMapEditor.prototype.$getStringEncodingElement = function () {
    return this.jq().find('.stringEncoding');
  };

  /**
   * Return the superUser checkbox editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/BooleanEditor}
   */
  PermissionsMapEditor.prototype.$getSuperUserEditor = function () {
    return this.$superUserEditor;
  };

  /**
   * Return the stringEncoding editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/StringEditor}
   */
  PermissionsMapEditor.prototype.$getStringEncodingEditor = function () {
    return this.$stringEncodingEditor;
  };

  /**
   * return whether the user has permission to enable the superUser checkbox.
   *
   * @private
   * @returns {Boolean}
   */
  PermissionsMapEditor.prototype.$getAllowCheckboxToBeEnabled = function () {
    return this.$allowCheckboxToBeEnabled;
  };

  /**
   * Enables or disables the view of the PermissionsMapEditor.
   *
   * @param {Boolean} enabled
   */
  PermissionsMapEditor.prototype.doEnabled = function (enabled) {
    return Promise.all([
    // the stringEncoding field should never be enabled
    this.$getStringEncodingEditor().setReadonly(true),
    // this gets called after $update, so we may not want to allow the checkbox to be enabled
    this.$getSuperUserEditor().setEnabled(enabled && this.$getAllowCheckboxToBeEnabled())]);
  };

  /**
   * Make the PermissionsMapEditor readonly (or not).
   *
   * @param {Boolean} readonly
   */
  PermissionsMapEditor.prototype.doReadonly = function (readonly) {
    return this.doEnabled(!readonly);
  };

  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */
  PermissionsMapEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return PermissionsMapEditor;
});
