function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/UnitEditor
 */
define(['baja!', 'log!nmodule.webEditors.rc.fe.baja.UnitEditor', 'bajaux/events', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/wb/options/MruButton', 'nmodule/webEditors/rc/wb/options/MruOptions'], function (baja, log, events, $, Promise, _, BaseWidget, BaseEditor, OrderedMapEditor, MruButton, MruOptions) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT,
    VALUE_READY_EVENT = BaseWidget.VALUE_READY_EVENT,
    MRU_NAME = 'unitFE',
    logError = log.severe.bind(log);

  ////////////////////////////////////////////////////////////////
  // Utility functions
  ////////////////////////////////////////////////////////////////

  /**
   * Convert the unit database to a `baja.OrderedMap` from quantity name ->
   * quantity, to be loaded into the quantities dropdown.
   *
   * @inner
   * @param {baja.UnitDatabase} db
   * @returns {baja.OrderedMap}
   */
  function toQuantitiesMap(db) {
    var quantities = db.getQuantities(),
      map = new baja.OrderedMap();
    _.each(quantities, function (quantity) {
      map.put(quantity.toString(), quantity);
    });
    return map;
  }

  /**
   * Get the string key that will be displayed in the units dropdown for this
   * unit.
   *
   * @inner
   * @param {baja.Unit} unit
   * @returns {String}
   */
  function toMapKey(unit) {
    return unit.getUnitName() + ' (' + unit.getSymbol() + ')';
  }

  /**
   * Convert a quantity into a `baja.OrderedMap` from unit name -> unit, to be
   * loaded into the units dropdown. Also adds a new custom unit to the map (optional).
   *
   * @inner
   * @param {baja.UnitDatabase.Quantity} quantity
   * @param {baja.Unit} [customUnit]
   * @returns {baja.OrderedMap}
   */
  function toUnitsMap(quantity, customUnit) {
    var units = quantity.getUnits(),
      map = new baja.OrderedMap();
    if (customUnit) {
      map.put(toMapKey(customUnit), customUnit);
    }
    _.each(units, function (unit) {
      map.put(toMapKey(unit), unit);
    });
    return map;
  }

  /**
   * Given a unit, find the quantity in the unit database that contains it.
   *
   * @inner
   * @param {baja.UnitDatabase} db
   * @param {baja.Unit} unit
   * @returns {baja.UnitDatabase.Quantity} the quantity containing the given
   * unit, or `undefined` if not found
   */
  function getContainingQuantity(db, unit) {
    var quantities = db.getQuantities(),
      quantity,
      units,
      i,
      j;
    for (i = 0; i < quantities.length; i++) {
      quantity = quantities[i];
      units = quantity.getUnits();
      for (j = 0; j < units.length; j++) {
        if (units[j].equivalent(unit)) {
          return quantity;
        }
      }
    }
    return quantities[0]; //default quantity: misc()
  }

  ////////////////////////////////////////////////////////////////
  // UnitEditor definition
  ////////////////////////////////////////////////////////////////

  /**
   * A field editor for working with `Unit`s.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/UnitEditor
   */
  var UnitEditor = function UnitEditor(params) {
    var that = this;
    BaseEditor.call(that, _.extend({
      keyName: 'UnitEditor'
    }, params));
    that.on(VALUE_READY_EVENT, function (unit) {
      return that.$saveMru(unit);
    });
  };
  UnitEditor.prototype = Object.create(BaseEditor.prototype);
  UnitEditor.prototype.constructor = UnitEditor;

  /**
   * Get the element containing the quantities dropdown.
   *
   * @private
   * @returns {jQuery}
   */
  UnitEditor.prototype.$getQuantitiesElement = function () {
    return this.jq().children('.quantity');
  };

  /**
   * Get the quantities editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */
  UnitEditor.prototype.$getQuantitiesEditor = function () {
    return this.$getQuantitiesElement().data('widget');
  };

  /**
   * Get the element containing the units dropdown.
   *
   * @private
   * @returns {jQuery}
   */
  UnitEditor.prototype.$getUnitsElement = function () {
    return this.jq().children('.unit');
  };

  /**
   * Get the units editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */
  UnitEditor.prototype.$getUnitsEditor = function () {
    return this.$getUnitsElement().data('widget');
  };

  /**
   * Build an `MruButton` for this `UnitEditor`.
   * @private
   * @param {module:nmodule/webEditors/rc/wb/options/MruOptions} options
   * @param {jQuery} dom element where the `MruButton` goes
   * @returns {Promise}
   */
  UnitEditor.prototype.$buildMruButton = function (options, dom) {
    var that = this,
      select = function select(str) {
        return that.load(decodeFromString(str));
      };
    return that.buildChildFor({
      value: {
        options: options,
        select: select,
        toDisplayString: toDisplayString
      },
      type: MruButton,
      dom: dom
    });
  };

  /**
   * @private
   * @returns {module:nmodule/webEditors/rc/wb/options/MruButton}
   */
  UnitEditor.prototype.$getMruButton = function () {
    return this.jq().children('.mru').data('widget');
  };

  /**
   * Sets the selected quantity in the quantities dropdown, and loads up the
   * units editor with the appropriate units. If a unit is provided, it will
   * be preselected in the units dropdown.
   *
   * @private
   * @param {baja.UnitDatabase.Quantity} quantity
   * @param {baja.Unit} unit
   * @returns {Promise}
   */
  UnitEditor.prototype.$setQuantityAndUnit = function (quantity, unit) {
    var that = this;
    var customUnit;

    //TODO: setSelectedKey triggers a MODIFY_EVENT, which immediately backs out value passed to #load()
    that.$getQuantitiesEditor().$getSelect().val(quantity.toString());
    var findUnit = quantity.getUnits().filter(function (units) {
      return units.getUnitName() === unit.getUnitName();
    });
    if (findUnit.length === 0) {
      customUnit = unit;
    }
    return that.$getUnitsEditor().load(toUnitsMap(quantity, customUnit), {
      selectedKey: unit && toMapKey(unit)
    });
  };

  /**
   * Performs a one-time retrieval of the unit database (if not already loaded),
   * loads up the quantities editor and instantiates the units editor (does not
   * load anything yet).
   *
   * Arms an event handler to update the units dropdown when a new quantity
   * is selected.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  UnitEditor.prototype.doInitialize = function (dom) {
    var that = this,
      quantityDom = $('<span class="quantity"/>').appendTo(dom),
      unitDom = $('<span class="unit"/>').appendTo(dom),
      mruDom = $('<span class="mru"/>').appendTo(dom),
      batch = new baja.comm.Batch();
    dom.on(MODIFY_EVENT, '.quantity', function () {
      that.$getQuantitiesEditor().read().then(function (quantity) {
        return that.$getUnitsEditor().load(toUnitsMap(quantity));
      })["catch"](logError);
      that.setModified(true);
      return false;
    });
    dom.on(MODIFY_EVENT, '.unit', function () {
      that.setModified(true);
      return false;
    });
    var prom = Promise.all([baja.UnitDatabase.get({
      batch: batch
    }), MruOptions.make(MRU_NAME, {
      batch: batch
    })]);
    batch.commit();
    return prom.then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        db = _ref2[0],
        options = _ref2[1];
      return Promise.all([that.buildChildFor({
        value: toQuantitiesMap(db),
        type: OrderedMapEditor,
        dom: quantityDom
      }), !baja.isOffline() && that.$buildMruButton(options, mruDom), new OrderedMapEditor().initialize(unitDom)]);
    });
  };

  /**
   * Loads the quantity dropdown with whichever quantity contains the given
   * unit, and selects that unit in the units dropdown.
   *
   * @param {baja.Unit} unit
   * @returns {Promise}
   */
  UnitEditor.prototype.doLoad = function (unit) {
    var that = this;
    return baja.UnitDatabase.get().then(function (db) {
      var quantity = getContainingQuantity(db, unit);
      return that.$setQuantityAndUnit(quantity, unit);
    });
  };

  /**
   * Read the currently selected unit.
   *
   * @returns {Promise}
   */
  UnitEditor.prototype.doRead = function () {
    return this.$getUnitsEditor().read();
  };
  UnitEditor.prototype.$saveMru = function (unit) {
    var that = this;
    if (baja.isOffline()) {
      return Promise.resolve();
    }
    return MruOptions.make(MRU_NAME).then(function (mru) {
      mru.add(unit.encodeToString());
      return Promise.all([mru.save(), that.$getMruButton().setOptions(mru)]);
    });
  };

  /**
   * When this editor is saved, add the selected unit to the UnitEditor MRU
   * history.
   * @param {baja.Unit} unit
   * @returns {Promise}
   */
  UnitEditor.prototype.doSave = function (unit) {
    return this.$saveMru(unit);
  };

  /**
   * Sets quantity and unit editors to readonly/writable.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  UnitEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Sets quantity and unit editors to enabled/disabled.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  UnitEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Destroy child editors.
   *
   * @returns {Promise}
   */
  UnitEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  function decodeFromString(str) {
    return baja.Unit.DEFAULT.decodeFromString(str);
  }
  function toDisplayString(str) {
    var unit = decodeFromString(str);
    return unit.getUnitName() + ' (' + unit.getSymbol() + ')';
  }
  return UnitEditor;
});
