function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/UsernameAndPasswordEditor
 */
define(['baja!', 'baja!baja:UsernameAndPassword,baja:Password', 'log!nmodule.webEditors.rc.fe.baja.PermissionsMapEditor', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'hbs!nmodule/webEditors/rc/fe/baja/template/UsernameAndPassword', 'bajaux/events', 'bajaux/mixin/batchSaveMixin', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'lex!bajaui'], function (baja, types, log, BaseEditor, UsernameAndPasswordTpl, events, batchSaveMixin, $, Promise, fe, lexs) {
  'use strict';

  var logError = log.severe.bind(log),
    MODIFY_EVENT = events.MODIFY_EVENT,
    bajauiLex = lexs[0],
    BLANK_PASSWORD = baja.$('baja:Password'),
    USERNAME_LABEL = bajauiLex.get({
      key: 'auth.username',
      def: 'Username'
    }),
    PASSWORD_LABEL = bajauiLex.get({
      key: 'auth.password',
      def: 'Password'
    });
  function hidden(complex, slot) {
    return !!(complex.getFlags(slot) & baja.Flags.HIDDEN);
  }

  /**
   * A field editor for working with a UsernameAndPassword.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/UsernameAndPasswordEditor
   */
  var UsernameAndPasswordEditor = function UsernameAndPasswordEditor(params) {
    var that = this;
    BaseEditor.call(that, $.extend(true, {
      keyName: 'UsernameAndPasswordEditor'
    }, params));
  };
  UsernameAndPasswordEditor.prototype = Object.create(BaseEditor.prototype);
  UsernameAndPasswordEditor.prototype.constructor = UsernameAndPasswordEditor;

  /**
   * Creates a UsernameAndPassword element.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  UsernameAndPasswordEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html(UsernameAndPasswordTpl({
      usernameLabel: USERNAME_LABEL,
      usernameId: that.generateId(),
      passwordLabel: PASSWORD_LABEL,
      passwordId: that.generateId()
    }));
    dom.on(MODIFY_EVENT, '.editor', function () {
      // if the user edits the username, set the password to blank,
      // unless the password has already been edited
      // (Note, if the password is not editable, the username shouldn't be editable either.)
      if (!that.$getPasswordEditor().isModified()) {
        that.$getPasswordEditor().load(BLANK_PASSWORD).then(function () {
          // not using setModified to avoid bubbling an extra Modified event.
          that.$getPasswordEditor().$modified = true;
        })["catch"](logError);
      }

      //if a row is modified, set myself modified
      that.setModified(true);
      return false;
    });
    return Promise.all([fe.buildFor({
      dom: dom.find('.usernameEditor'),
      value: '',
      // default value, the actual value will be loaded in doLoad.
      formFactor: 'mini'
    }), fe.buildFor({
      dom: dom.find('.passwordEditor'),
      value: BLANK_PASSWORD,
      // default value, the actual value will be loaded in doLoad.
      formFactor: 'mini'
    })]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        usernameEditor = _ref2[0],
        passwordEditor = _ref2[1];
      that.$usernameEditor = usernameEditor;
      that.$passwordEditor = passwordEditor;
    });
  };

  /**
   * Loads the given baja.UsernameAndPassword into the editor.
   *
   * @param {baja.UsernameAndPassword} usernameAndPassword
   * @returns {Promise} A promise to be resolved once the widget has been loaded
   */
  UsernameAndPasswordEditor.prototype.doLoad = function (usernameAndPassword) {
    var that = this,
      promises = [];

    // extensions of BUsernameAndPassword may have set the hidden flag on username and/or password
    if (hidden(usernameAndPassword, 'username')) {
      that.$getUsernameElement().toggle(false);
    } else {
      that.$getUsernameElement().toggle(true);
      promises.push(that.$getUsernameEditor().load(usernameAndPassword.getUsername()));
    }
    if (hidden(usernameAndPassword, 'password')) {
      that.$getPasswordElement().toggle(false);
    } else {
      that.$getPasswordElement().toggle(true);
      promises.push(that.$getPasswordEditor().load(usernameAndPassword.getPassword()));
    }

    // If you can't change the password, don't allow changing of the username cf. BUsernameAndPasswordFE#doLoadValue
    if (that.$getPasswordEditor().isReadonly()) {
      promises.push(that.$getUsernameEditor().setEnabled(false));
    }
    return Promise.all(promises);
  };

  /**
   * Read the individual child editors and assemble them into a `UsernameAndPassword`
   *
   * @returns {Promise.<baja.UsernameAndPassword>} promise to be resolved with a `baja.UsernameAndPassword` value
   */
  UsernameAndPasswordEditor.prototype.doRead = function () {
    var readValue = this.value().newCopy(true);
    return Promise.all([this.$getUsernameEditor().read(), this.$getPasswordEditor().read()]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        username = _ref4[0],
        password = _ref4[1];
      // readValue - because it's a copy of this.value() - is unmounted, so calls to #set() are synchronous
      readValue.set({
        slot: 'username',
        value: username
      })["catch"](logError);
      readValue.set({
        slot: 'password',
        value: password
      })["catch"](logError);
      return readValue;
    });
  };

  /**
   * save the UsernameAndPassword component
   * @param {baja.Component} readValue - a baja:UsernameAndPassword component
   * @param {Object} params
   * @returns {Promise} A promise to be resolved once the widget has been saved
   */
  UsernameAndPasswordEditor.prototype.doSave = function (readValue, params) {
    var username = readValue.get('username');
    var password = readValue.get('password');
    var loadedValue = this.value();
    var _ref5 = params || {},
      batch = _ref5.batch,
      progressCallback = _ref5.progressCallback;
    var prom = Promise.all([loadedValue.set({
      slot: 'username',
      value: username,
      batch: batch
    }), loadedValue.set({
      slot: 'password',
      value: password,
      batch: batch
    })]);
    if (progressCallback) {
      progressCallback(batchSaveMixin.COMMIT_READY);
    }
    return prom;
  };

  /**
   * Return the username editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/StringEditor}
   */
  UsernameAndPasswordEditor.prototype.$getUsernameEditor = function () {
    return this.$usernameEditor;
  };

  /**
   * Return the password editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/PasswordEditor}
   */
  UsernameAndPasswordEditor.prototype.$getPasswordEditor = function () {
    return this.$passwordEditor;
  };

  /**
   * @private
   * @returns {JQuery} element containing the username editor
   */
  UsernameAndPasswordEditor.prototype.$getUsernameElement = function () {
    return this.jq().find('.usernameElement');
  };

  /**
   * @private
   * @returns {JQuery} element containing the password editor
   */
  UsernameAndPasswordEditor.prototype.$getPasswordElement = function () {
    return this.jq().find('.passwordElement');
  };

  /**
   * Enables or disables the view of the UsernameAndPasswordEditor.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  UsernameAndPasswordEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Make the UsernameAndPasswordEditor readonly (or not).
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  UsernameAndPasswordEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */
  UsernameAndPasswordEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return UsernameAndPasswordEditor;
});
