function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/compat/CompositeTimeEditor
 */
define(['baja!', 'bajaux/events', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor'], function (baja, events, $, Promise, BaseEditor, OrderedMapEditor) {
  'use strict';

  var dateTimeUtil = require('bajaScript/baja/obj/dateTimeUtil');
  var MODIFY_EVENT = events.MODIFY_EVENT,
    AMPM = new baja.OrderedMap(),
    getTimeOnlyFormat = dateTimeUtil.getTimeOnlyFormat,
    DEFAULT_TIME_FORMAT = dateTimeUtil.DEFAULT_TIME_FORMAT,
    timeFieldAndSeparatorRegex = dateTimeUtil.$timeFieldAndSeparatorRegex(),
    hours24; // True if using 24-hour timeFormat ('H' or 'HH')

  //TODO: i18n?
  AMPM.put('AM', 'AM');
  AMPM.put('PM', 'PM');

  /**
   * Editor for working with `baja.Time` values. Consists of almost nothing
   * but an array of `IntegerEditor`s for the hours, minutes, seconds, and
   * milliseconds of the time.
   *
   * Set the `nativeHtml` bajaux Property to true to flip the integer editors
   * into native HTML mode (`type=number`, with spinners) in supported
   * browsers.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/compat/CompositeTimeEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */
  var CompositeTimeEditor = function CompositeTimeEditor() {
    BaseEditor.apply(this, arguments);
  };
  CompositeTimeEditor.prototype = Object.create(BaseEditor.prototype);
  CompositeTimeEditor.prototype.constructor = CompositeTimeEditor;

  /**
   * Get the hour editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/IntegerEditor}
   */
  CompositeTimeEditor.prototype.$getHourEditor = function () {
    return this.jq().children('.hour').data('widget');
  };

  /**
   * Get the minute editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/IntegerEditor}
   */
  CompositeTimeEditor.prototype.$getMinuteEditor = function () {
    return this.jq().children('.min').data('widget');
  };

  /**
   * Get the second editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/IntegerEditor}
   */
  CompositeTimeEditor.prototype.$getSecondEditor = function () {
    return this.jq().children('.sec').data('widget');
  };

  /**
   * Get the millisecond editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/IntegerEditor}
   */
  CompositeTimeEditor.prototype.$getMillisecondEditor = function () {
    return this.jq().children('.ms').data('widget');
  };

  /**
   * Get the AM/PM editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */
  CompositeTimeEditor.prototype.$getAmpmEditor = function () {
    return this.jq().children('.ampm').data('widget');
  };

  /**
   * Instantiates the `IntegerEditor`s for each component of the Time object.
   * Seconds and milliseconds will be shown/hidden according to the
   * `showSeconds` and `showMilliseconds` facets.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  CompositeTimeEditor.prototype.doInitialize = function (dom) {
    var that = this,
      props = that.properties(),
      int0 = baja.Integer.DEFAULT,
      showMilliseconds = !!props.getValue('showMilliseconds'),
      showSeconds = showMilliseconds || props.getValue('showSeconds') !== false,
      timeString = getTimeOnlyFormat(props.getValue('timeFormat') || DEFAULT_TIME_FORMAT),
      nativeHtml = !!props.getValue('nativeHtml'),
      zeroPadHour = true;
    hours24 = false;

    // Make sure 24-hour time field ('H|HH') and AMPM time field('a') do not
    // coexist in the same timeFormat. Remove the AMPM field and its preceding
    // separator characters if so.
    if (timeString.search('H') >= 0 && timeString.search('a') >= 0) {
      timeString = timeString.replace(/([^a-zA-Z]*)(a)/g, '');
    }

    // Append an AMPM time field ('a') if timeString has an 12-hour time field
    // ('h|hh') but no AMPM time field.
    if (timeString.search('h') >= 0 && timeString.search('a') < 0) {
      timeString = timeString + ' a';
    }
    timeString = timeString.replace(new RegExp(timeFieldAndSeparatorRegex.source, 'g'), function (match, separator, fieldFormat) {
      function domString(editorType) {
        return '<span class="' + editorType + '-separator">' + separator + '</span><span class="' + editorType + '" title="' + fieldFormat + '"/>';
      }
      switch (fieldFormat) {
        case 'H':
          zeroPadHour = false;
          hours24 = true;
          return domString('hour');
        case 'h':
          zeroPadHour = false;
          return domString('hour');
        case 'HH':
          hours24 = true;
          return domString('hour');
        case 'hh':
          return domString('hour');
        case 'mm':
          return domString('min');
        case 'ss':
          var str = domString('sec');
          separator = '.';
          fieldFormat = 'ms';
          return str + domString('ms');
        case 'a':
          return domString('ampm');
        default:
          return "";
      }
    });
    dom.html(timeString);
    var hourDiv = dom.children('.hour'),
      minDiv = dom.children('.min'),
      secDiv = dom.children('.sec'),
      msDiv = dom.children('.ms'),
      ampmDiv = dom.children('.ampm');
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    if (!showSeconds) {
      secDiv.hide();
      dom.children('.sec-separator').hide();
    }
    if (!showMilliseconds) {
      msDiv.hide();
      dom.children('.ms-separator').hide();
    }
    return Promise.all([hourDiv.length && that.buildChildFor({
      value: int0,
      dom: hourDiv,
      properties: {
        min: hours24 ? 0 : 1,
        max: hours24 ? 23 : 12,
        zeroPad: zeroPadHour ? 2 : 0,
        nativeHtml: nativeHtml
      },
      formFactor: 'mini'
    }), minDiv.length && that.buildChildFor({
      value: int0,
      dom: minDiv,
      properties: {
        min: 0,
        max: 59,
        zeroPad: 2,
        nativeHtml: nativeHtml
      },
      formFactor: 'mini'
    }), secDiv.length && that.buildChildFor({
      value: int0,
      dom: secDiv,
      properties: {
        min: 0,
        max: 59,
        zeroPad: 2,
        nativeHtml: nativeHtml
      },
      formFactor: 'mini'
    }), msDiv.length && that.buildChildFor({
      value: int0,
      dom: msDiv,
      properties: {
        min: 0,
        max: 999,
        zeroPad: 3,
        nativeHtml: nativeHtml
      },
      formFactor: 'mini'
    }), ampmDiv.length && that.buildChildFor({
      value: AMPM,
      type: OrderedMapEditor,
      dom: ampmDiv,
      formFactor: 'mini'
    })]).then(function () {
      //TODO: use fieldWidth for maxlength?
      $('input', hourDiv).attr('maxlength', '2');
      $('input', minDiv).attr('maxlength', '2');
      $('input', secDiv).attr('maxlength', '2');
      $('input', msDiv).attr('maxlength', '3');
    });
  };

  /**
   * Load the hour, minute, second, and millisecond components of the time into
   * the different integer editors.
   *
   * @param {baja.Time} value
   * @returns {Promise}
   */
  CompositeTimeEditor.prototype.doLoad = function (value) {
    var that = this,
      hour = value.getHour(),
      min = value.getMinute(),
      sec = value.getSecond(),
      ms = value.getMillisecond(),
      promises = [],
      hourEd = that.$getHourEditor(),
      minEd = that.$getMinuteEditor(),
      secEd = that.$getSecondEditor(),
      msEd = that.$getMillisecondEditor(),
      ampmEd = that.$getAmpmEditor();
    if (hourEd) {
      promises.push(hourEd.load(hours24 ? hour : hour % 12 || 12));
    }
    if (minEd) {
      promises.push(minEd.load(min));
    }
    if (secEd) {
      promises.push(secEd.load(sec));
    }
    if (msEd) {
      promises.push(msEd.load(ms));
    }
    if (ampmEd) {
      promises.push(ampmEd.setSelectedKey(hour < 12 ? 'AM' : 'PM'));
    }
    return Promise.all(promises);
  };

  /**
   * Read the values of the hour, minute, second, and millisecond editors and
   * construct a `baja:Time` instance.
   *
   * @returns {Promise}
   */
  CompositeTimeEditor.prototype.doRead = function () {
    var that = this,
      hourEd = that.$getHourEditor(),
      minEd = that.$getMinuteEditor(),
      secEd = that.$getSecondEditor(),
      msEd = that.$getMillisecondEditor(),
      ampmEd = that.$getAmpmEditor(),
      time = that.value(),
      // If any editors do not exist, get the value of that field from when it
      // was originally created with that.value()
      hourP = hourEd ? hourEd.validate() : time.getHour(),
      minP = minEd ? minEd.validate() : time.getMinute(),
      secP = secEd ? secEd.validate() : time.getSecond(),
      msP = msEd ? msEd.validate() : time.getMillisecond(),
      ampmP = ampmEd ? ampmEd.validate() : 'AM';
    return Promise.all([hourP, minP, secP, msP, ampmP]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 5),
        hour = _ref2[0],
        min = _ref2[1],
        sec = _ref2[2],
        ms = _ref2[3],
        ampm = _ref2[4];
      return baja.Time.make({
        // If hourEd exists, check if it's 12 or 24 hour format, otherwise use
        // the 24 hour value from when it was created with a baja Time object
        hour: hourEd && !hours24 ? hour % 12 + (ampm === 'AM' ? 0 : 12) : hour,
        min: min,
        sec: sec,
        ms: ms
      });
    });
  };

  /**
   * Set all child editors' readonly status.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  CompositeTimeEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Set all child editors' enabled status.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  CompositeTimeEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Destroys all child editors.
   *
   * @returns {Promise}
   */
  CompositeTimeEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return CompositeTimeEditor;
});
