function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/util/FloatingPointHelper
 */
define(['baja!', 'lex!webEditors', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/numberUtils'], function (baja, lexs, _, numberUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var bajaNumberUtil = require('bajaScript/baja/obj/numberUtil');
  var toDisplay = numberUtils.toDisplay;
  function localizeNumerals(numStr, lang) {
    var num = +numStr;
    if (isNaN(num)) {
      var format = bajaNumberUtil.getInternationalFormat(lang);
      if (format) {
        var numerals = [];
        var index = {};
        for (var i = 0; i < 10; i++) {
          var numeralStr = format.format(i);
          numerals.push(numeralStr);
          index[numeralStr] = i;
        }
        var _numerals = new RegExp("[".concat(numerals.join(""), "]"), "g");
        var _index = function _index(d) {
          return index[d];
        };
        numStr = numStr.replace(_numerals, _index);
        num = +numStr;
      }
    }
    return num;
  }

  /**
   * A helper class for working with floating point values.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/util/FloatingPointHelper
   * @param {Function} ctor constructor for the type of number you wish to
   * edit. Defaults to `baja.Double`.
   * @param {Object} [config]
   * @param {Number} [config.precision] how many decimal points to show
   * @param {Boolean} [config.forceSign] always include the sign, even with
   * positive values
   * @param {Boolean} [config.showSeparators] include separators, as in "1,000"
   * @param {Number} [config.zeroPad] pad the number with zeroes to ensure at
   * least this many digits to the left of the decimal sign
   */
  var FloatingPointHelper = function FloatingPointHelper(ctor, config) {
    var instance = ctor && ctor.DEFAULT;
    var type = typeof instance !== 'undefined' && instance.getType();
    if (!type || !type.is('baja:Float')) {
      instance = baja.Double.DEFAULT;
    }
    this.$instance = instance;
    this.$config = config || {};
  };

  /**
   * Coerce a number to the expected type.
   * @param {Number|baja.Float} num
   * @returns {Number|baja.Float}
   */
  FloatingPointHelper.prototype.toType = function (num) {
    return this.$instance.make(+num);
  };

  /**
   * Parses a floating point string, respecting special encodings like `+inf`
   * and `precision` facet.
   *
   * @param {String} str the string to parse
   * @returns {baja.Double|baja.Float} the parsed number
   */
  FloatingPointHelper.prototype.parse = function (str) {
    var instance = this.$instance;
    if (str === '-inf' || str === '+inf' || str === 'nan') {
      return instance.decodeFromString(str);
    }
    var lang = this.$config.languageTag || baja.getLanguage();
    var _bajaNumberUtil$getNu = bajaNumberUtil.getNumberCharacters(lang),
      grouping = _bajaNumberUtil$getNu.grouping,
      decimal = _bajaNumberUtil$getNu.decimal;
    var decimals = new RegExp('\\' + decimal, 'g');

    // if the "." is not used for decimals or grouping, do not allow it in the string
    //  The decimal is a special case because if it is in the string, it is possible
    //  for the string to be resolved to a number.  Other characters in the string
    //  do not have the same effect.
    if (decimal !== "." && grouping !== "." && str.includes(".")) {
      throw invalidError(str);
    }

    // treat all whitespace equally - i don't think a french keyboard has an nnbsp key
    var groups = grouping.match(/\s/) ? '\\s' : '\\' + grouping;
    // Added the `\\` before to escape the decimal because it does not have it yet
    //  but the groups got was escaped in the previouse line.
    var badPattern = new RegExp("\\".concat(decimal, ".*(\\").concat(decimal, "|").concat(groups, ")"));

    // if we have more than one decimal point or the grouping char is after the decimal point
    //  the str is not a valid number
    if (badPattern.exec(str)) {
      throw invalidError(str);
    }
    groups = new RegExp(groups, 'g');
    str = str.replace(groups, '').replace(decimals, '.');
    var num = localizeNumerals(str, lang);
    if (isNaN(num)) {
      throw invalidError(str);
    }
    return this.toType(num);
  };

  /**
   * Formats a number into its string representation, respecting special
   * encodings like `+inf` and `precision`, `showSeparators`, and `forceSign`
   * facets.
   *
   * @param {baja.Double|baja.Float|Number} number the number to format
   * @returns {Promise.<String>} the formatted string
   */
  FloatingPointHelper.prototype.format = function (number) {
    return toDisplay(number, _.omit(this.$config, 'radix'));
  };
  function invalidError(str) {
    return new Error(webEditorsLex.get('NumericEditor.invalidNumberFormat', str));
  }
  return FloatingPointHelper;
});
