function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*jshint browser: true, debug: true */

define(['baja!', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/promiseMux', 'bajaux/registry/RegistryEntry', 'nmodule/webEditors/rc/servlets/registry'], function (baja, Promise, _, promiseMux, RegistryEntry, registry) {
  'use strict';

  /**
   * Wait this many milliseconds for additional requests to come in before
   * making the post up to the station servlets.
   *
   * @inner
   * @constant
   * @type {Number}
   */
  var POST_DELAY = 20;
  function muxedFetchAgents() {
    return promiseMux({
      exec: function exec(typeSpecs) {
        var batch = new baja.comm.Batch(),
          prom = Promise.all([registry.getTypeInfo(typeSpecs, {
            batch: batch
          }), registry.getAgentOnInfo(typeSpecs, {
            is: 'web:IJavaScript',
            batch: batch
          })]);
        batch.commit();
        return prom.then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            typeArray = _ref2[0],
            agentArrays = _ref2[1];
          return _.map(typeSpecs, function (typeSpec, i) {
            return [typeArray[i], agentArrays[i]];
          });
        });
      },
      cache: true,
      delay: POST_DELAY
    });
  }
  var fetchAgents = muxedFetchAgents();

  ////////////////////////////////////////////////////////////////
  // Utility functions
  ////////////////////////////////////////////////////////////////

  /**
   * Retrieve JSON data from the registry for the requested type specs.
   *
   * @inner
   * @param {Array.<String|Type>} typeSpecs
   * @returns {Promise} promise to be resolved with an array containing two
   * objects: the first for direct type information, the second for agent-on
   * information.
   */
  function retrieveJson(typeSpecs) {
    return Promise.all(_.map(typeSpecs, fetchAgents)).then(function (arrays) {
      //each POST resolves an array with two elements
      var typeObj = {},
        agentObj = {};
      _.each(typeSpecs, function (typeSpec, i) {
        var arr = arrays[i];
        typeObj[typeSpec] = arr[0];
        agentObj[typeSpec] = arr[1];
      });
      return [typeObj, agentObj];
    });
  }

  /**
   * Given a JSON object retrieved from one of the registry servlets, build up
   * a registry entry that can be stored in the field editor registry.
   *
   * @inner
   * @param {{ js: {id: string, deps: Array.<Array.<string>> }, interfaces: Array.<string> }} jsonObj
   * @returns {module:bajaux/registry/RegistryEntry}
   */
  function toEntry(jsonObj) {
    var js = jsonObj.js;
    if (js) {
      return new RegistryEntry({
        rjs: js.id,
        deps: js.deps,
        tags: jsonObj.interfaces
      });
    }
  }

  /**
   * Makes the call to the registry servlets to retrieve the type info, then
   * assemble that type info into `RegistryEntry`s.
   *
   * @inner
   * @param {Array.<String>} typeSpecs
   * @returns {Promise} promise to be resolved with a two-dimensional
   * array of registry entries. First dimension corresponds to the type specs
   * passed in, second dimension is entries per type spec.
   */
  function retrieveEntries(typeSpecs) {
    return retrieveJson(typeSpecs).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        typeJson = _ref4[0],
        agentJson = _ref4[1];
      //typeJson: typeSpec -> { interfaces: [], js: { deps: [[]], id: '', type: '', wd: true  } }
      //agentJson: typeSpec -> [ { interfaces: [], js: { deps: [[]], id: '', type: '', wd: true } } ]
      return _.map(typeSpecs, function (typeSpec) {
        var typeObj = typeJson[typeSpec],
          typeEntry = typeObj && toEntry(typeObj),
          agentArr = agentJson[typeSpec] || [],
          agentEntries = _.map(agentArr, toEntry);
        return _.compact(typeEntry ? [typeEntry].concat(agentEntries) : agentEntries);
      });
    });
  }
  function findMatching(entries, params) {
    return _.filter(entries, function (entry) {
      return entry.matches(params);
    });
  }

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * API Status: **Private**
   *
   * Module for retrieving type and agent information from the station and
   * assembling it into entries to be stored in the local station registry.
   *
   * This module calls out to
   * {@link module:nmodule/webEditors/rc/servlets/registry|registry} module,
   * which does the direct HTTP communications with the server. Think of that
   * one as a low-level registry interop module, with this one doing the work
   * of orchestrating multiple calls to it and packaging the raw data returned
   * into nice, usable results.
   *
   * @exports nmodule/webEditors/rc/fe/registry/servletViews
   */
  var exports = {};

  /**
   * Retrieve the default registry entry for the given type spec. This will be
   * whatever appears first in the agent list for that type, that matches the
   * requested parameters.
   *
   * @param {String} typeSpec
   * @param {Object} [params]
   * @returns {Promise.<module:bajaux/registry/RegistryEntry|undefined>} promise to be resolved with a
   * registry entry, or `undefined` if none matching
   */
  exports.getDefaultEntry = function (typeSpec, params) {
    return exports.getEntries(typeSpec).then(function (entries) {
      return findMatching(entries, params)[0];
    });
  };

  /**
   * Retrieve registry entries for all `BIJavaScript` agent registrations on
   * the given type (including the type itself, if it is `BIJavaScript`).
   *
   * @param {String|Array.<String>} typeSpec
   * @returns {Promise.<Array.<module:bajaux/registry/RegistryEntry>>}
   */
  exports.getEntries = function (typeSpec) {
    var isArray = Array.isArray(typeSpec),
      typeSpecs = isArray ? typeSpec : Array.prototype.slice.call(arguments);
    return retrieveEntries(typeSpecs).then(function (arrays) {
      if (!isArray && typeSpecs.length === 1) {
        return arrays[0];
      }
      return arrays;
    });
  };

  /**
   * Delete all cached promises, causing future requests to always call back
   * up to the station. Note that these promises will be wiped on page reload
   * anyway. Mostly for test purposes.
   *
   * @private
   */
  exports.$clear = function () {
    fetchAgents = muxedFetchAgents();
  };
  return exports;
});
