function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/export/rc/transformers/TableModelToCsv
 */
define(['baja!', 'lex!webEditors', 'Promise', 'underscore', 'niagaraSystemProperties', 'nmodule/webEditors/rc/transform/transformer/TableModelToJson', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'baja!file:ITableToCsv'], function (baja, lexs, Promise, _, systemProperties, TableModelToJson, typeUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0],
    isSimple = typeUtils.isSimple;

  /**
   * Converts a TableModel or PaginationModel to CSV format.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/transform/transformer/TableModelToCsv
   * @implements module:nmodule/export/rc/Transformer
   */
  var TableModelToCsv = /*#__PURE__*/function () {
    function TableModelToCsv() {
      _classCallCheck(this, TableModelToCsv);
    }
    return _createClass(TableModelToCsv, [{
      key: "getDisplayName",
      value: /** @returns {string} */
      function getDisplayName() {
        return webEditorsLex.get('converters.TableModelToCsv.displayName');
      }

      /** @returns {string} */
    }, {
      key: "getIcon",
      value: function getIcon() {
        return webEditorsLex.get('converters.TableModelToCsv.icon');
      }

      /** @returns {string} `text/csv` */
    }, {
      key: "getMimeType",
      value: function getMimeType() {
        return 'text/csv';
      }

      /** @returns {string} `csv` */
    }, {
      key: "getFileExtension",
      value: function getFileExtension() {
        return 'csv';
      }

      /** @returns {string} `table` */
    }, {
      key: "getFileName",
      value: function getFileName() {
        return 'table';
      }

      /**
       * @returns {baja.Component}
       */
    }, {
      key: "getDefaultConfig",
      value: function getDefaultConfig() {
        var comp = baja.$('file:ITableToCsv');
        comp.add({
          slot: 'showUnseen',
          value: true,
          cx: {
            displayName: webEditorsLex.get('export.showUnseen')
          }
        });
        comp.add({
          slot: 'maxRecords',
          value: baja.Integer.MAX_VALUE,
          cx: {
            displayName: webEditorsLex.get('export.maxRecords')
          }
        });
        return comp;
      }

      /**
       * @param {baja.Component} config
       * @returns {object}
       */
    }, {
      key: "getExportContextObject",
      value: function getExportContextObject(config) {
        var obj = config.getSlots().toValueMap(),
          lineEnding = obj.useCRLF ? '\r\n' : '\n';
        return _.extend(_.omit(obj, 'facets', 'useCRLF'), obj.facets.toObject(), {
          lineEnding: lineEnding
        });
      }

      /**
       * Transform the contents of the TableModel or PaginationModel into CSV.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/TableModel|module:nmodule/webEditors/rc/wb/table/pagination/PaginationModel} tableModel
       * @param {object} [cx] context; also used for toString()ing values
       * @param {string} [cx.delimiter=','] custom delimiter
       * @param {boolean} [cx.includeBOM=true] set to false to omit the UTF-8
       * byte order mark from the CSV (be aware that omitting the BOM does not
       * play nice with Excel)
       * @param {boolean} [cx.includeHeaders=true] set to false to not include
       * header columns in the CSV
       * @param {string} [cx.lineEnding='\n'] choose a custom line ending like \r\n
       * @param {boolean} [cx.showUnseen=true] set to false to prevent unseen
       * columns from being included
       * @returns {Promise.<string>}
       */
    }, {
      key: "transform",
      value: function transform(tableModel) {
        var cx = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var _cx$delimiter = cx.delimiter,
          delimiter = _cx$delimiter === void 0 ? ',' : _cx$delimiter,
          _cx$includeHeaders = cx.includeHeaders,
          includeHeaders = _cx$includeHeaders === void 0 ? true : _cx$includeHeaders,
          _cx$lineEnding = cx.lineEnding,
          lineEnding = _cx$lineEnding === void 0 ? '\n' : _cx$lineEnding,
          _cx$includeBOM = cx.includeBOM,
          includeBOM = _cx$includeBOM === void 0 ? true : _cx$includeBOM;
        if (this.delimiterContainsFunctionCharacter(delimiter)) {
          throw new Error(webEditorsLex.get('export.delimiterFunctionError'));
        }
        return new TableModelToJson().transform(tableModel, _.extend({}, cx, {
          rawJson: true
        })).then(function (_ref) {
          var columns = _ref.columns,
            rows = _ref.rows,
            columnContexts = _ref.$metadata.columnContexts;
          var escapeRegex = new RegExp('[' + delimiter + '\\n]');
          var header = includeBOM ? "\uFEFF" : '';
          if (includeHeaders) {
            header += columns.map(function (c) {
              return escape(c, escapeRegex);
            }).join(delimiter) + lineEnding;
          }

          // never show units in individual cells.
          columnContexts = columnContexts.map(function (columnContext) {
            return _.extend({
              precision: 0
            }, columnContext, {
              showUnits: false
            });
          });
          return Promise.all(rows.map(function (row) {
            return Promise.all(row.map(function (value, i) {
              return valueToCell(value, escapeRegex, columnContexts[i]);
            })).then(function (cells) {
              return cells.join(delimiter);
            });
          })).then(function (rowStrings) {
            return header + rowStrings.join(lineEnding);
          });
        });
      }

      /**
       * Returns true if delimiter.substring(1) contains one of the function characters
       *  =, +, -, @.
       *
       * @param delimiter
       * @returns {boolean}
       */
    }, {
      key: "delimiterContainsFunctionCharacter",
      value: function delimiterContainsFunctionCharacter(delimiter) {
        return delimiter.indexOf('=') > 0 || delimiter.indexOf('+') > 0 || delimiter.indexOf('-') > 0 || delimiter.indexOf('@') > 0;
      }
    }]);
  }();
  /** @returns {Promise.<string>} */
  function valueToCell(value, escapeRegex, cx) {
    if (value === null || typeof value === 'undefined') {
      return Promise.resolve('');
    }
    return Promise.resolve(isSimple(value) ? value.toString(cx) : String(value)).then(function (string) {
      return escape(string, escapeRegex);
    });
  }
  function escape(string, escapeRegex) {
    string = string.replace(/"/g, '""');
    if (preventCSVInjection()) {
      string = string.replace(/^[=@+-]/g, " $&");
    }
    return string.match(escapeRegex) ? "\"".concat(string, "\"") : string;
  }
  function preventCSVInjection() {
    var flagString = systemProperties['niagara.export.preventCSVInjection'];
    if (flagString) {
      var B = Boolean;
      var flag = new B().decodeFromString(flagString);
      return flag.valueOf();
    } else {
      // default value is true
      return true;
    }
  }
  return TableModelToCsv;
});
