function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/ActionsCommand
 */
define(['baja!', 'lex!webEditors', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/wb/ActionFirer'], function (baja, lexs, Command, feDialogs, BaseEditor, ActionFirer) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];

  /**
   * Slot does not have HIDDEN slot flag.
   * @inner
   * @param {baja.Slot} slot
   * @returns {boolean}
   */
  function notHidden(slot) {
    return !(slot.getFlags() & baja.Flags.HIDDEN);
  }

  /**
   * Return true if the value is a mounted components with at least one
   * Action slot.
   *
   * @inner
   * @param {baja.Component} comp
   * @returns {boolean}
   */
  function hasMountedActions(comp) {
    return isMountedComponent(comp) && comp.getSlots().actions().filter(notHidden).toArray().length > 0;
  }
  function isMountedComponent(comp) {
    return baja.hasType(comp, 'baja:Component') && comp.isMounted();
  }

  /**
   * Editor has a value loaded that is capable of firing actions (either a
   * mounted Component with non-hidden Actions, or an Action itself).
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/fe/baja/BaseEditor} ed
   * @returns {boolean}
   */
  function canFireActions(ed) {
    var value = ed.value();
    if (hasMountedActions(value)) {
      return true;
    } else if (ed.isComplexSlotEditor() && value instanceof baja.Action && notHidden(value) && hasMountedActions(ed.getComplex())) {
      return true;
    }
    return false;
  }
  function isBaseEditor(ed) {
    return ed instanceof BaseEditor;
  }

  /**
   * A command for firing Actions on an editor's `Component` value.
   *
   * Will enable itself if the editor has a `Component` loaded with at least
   * one Action slot to fire, or if the editor is a `ComplexSlotEditor` on
   * a mounted Component with an Action slot loaded directly.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/ActionsCommand
   * @param {module:nmodule/webEditors/rc/fe/baja/BaseEditor} ed the
   * `BaseEditor` to bind this `Command` to
   * @throws {Error} if no `BaseEditor` provided
   */
  var ActionsCommand = function ActionsCommand(ed) {
    if (!isBaseEditor(ed)) {
      throw new Error('BaseEditor required');
    }
    var that = this;
    Command.call(that, {
      module: 'webEditors',
      lex: 'commands.actions',
      enabled: canFireActions(ed),
      /**
       * Shows an `ActionFirer` dialog, if appropriate.
       *
       * @alias module:nmodule/webEditors/rc/wb/commands/ActionsCommand#invoke
       * @see module:nmodule/webEditors/rc/wb/ActionFirer
       */
      func: function func() {
        if (!canFireActions(ed)) {
          return;
        }
        var value = ed.value();
        if (value instanceof baja.Action) {
          return feDialogs.action({
            component: ed.getComplex(),
            slot: value
          });
        }
        return ActionFirer.showActionDialog({
          component: value,
          title: webEditorsLex.get('commands.actions.description')
        });
      }
    });

    /**
     * Allows this Command to update its own enabled status based on the value
     * currently loaded in the watched `BaseEditor`. If actions can be fired
     * on the editor's loaded value, this command will be enabled.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/commands/ActionsCommand
     */
    function $updateEnabled() {
      that.setEnabled(canFireActions(ed));
      var value = ed.value();
      if (isMountedComponent(value) && !value.isSubscribed()) {
        var _onSubscribed = function onSubscribed() {
          $updateEnabled();
          value.detach('subscribed', _onSubscribed);
        };
        value.attach('subscribed', _onSubscribed);
      }
    }
    ed.on('loaded', $updateEnabled);
    that.$updateEnabled = $updateEnabled;
  };
  ActionsCommand.prototype = Object.create(Command.prototype);
  ActionsCommand.prototype.constructor = ActionsCommand;
  return ActionsCommand;
});
