function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/AddSlotCommand
 */
define(['baja!', 'lex!webEditors', 'bajaux/commands/Command', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, lexs, Command, Promise, _, compUtils, typeUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var extend = _.extend,
    result = _.result;
  var bulkAdd = compUtils.bulkAdd,
    formatDisplayNames = compUtils.formatDisplayNames,
    getDisplayName = compUtils.getDisplayName,
    getUniqueName = compUtils.getUniqueName,
    promptForAddParameters = compUtils.promptForAddParameters,
    promptForSlotName = compUtils.promptForSlotName;
  var isComponent = typeUtils.isComponent;

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  function isFrozenSlot(comp, slotName) {
    var slot = comp.getSlot(slotName);
    return slot && slot.isFrozen();
  }
  function getDynamicSlotNames(comp) {
    return _.map(comp.getSlots().dynamic().toArray(), String);
  }

  /**
   * Reorder the dynamic slots of the component after adding a slot, to ensure
   * that the added slot is at the desired index in the component's slot list.
   *
   * @inner
   * @param {baja.Component} comp
   * @param {Object} params
   * @param {Array.<String>} params.slots the slots to move
   * @param {String} [params.before] move the new slots to be just before this
   * one
   * @param {String} [params.after] move the new slots to be just after this one
   * (only one of `before` or `after` will be used)
   * @returns {Promise} promise to be resolved after the reorder is finished
   */
  function doReorder(comp, params) {
    var slots = params.slots,
      before = params.before,
      after = params.after,
      slotName = String(before || after);
    if (slots && slots.length) {
      slots = _.map(slots, String);
      var allDynamicSlots = getDynamicSlotNames(comp),
        unmovedDynamicSlots = _.difference(allDynamicSlots, slots);
      if (isFrozenSlot(comp, slotName)) {
        return comp.reorder({
          dynamicProperties: slots.concat(unmovedDynamicSlots)
        });
      }
      var idx = _.indexOf(unmovedDynamicSlots, slotName);
      if (idx !== -1) {
        if (after) {
          idx++;
        }
        var slotsBefore = unmovedDynamicSlots.slice(0, idx),
          slotsAfter = unmovedDynamicSlots.slice(idx),
          toReorder = slotsBefore.concat(slots).concat(slotsAfter);
        return comp.reorder({
          dynamicProperties: toReorder
        });
      }
    }
    return Promise.resolve();
  }
  function isAnnotation(value) {
    return baja.hasType(value, 'baja:WsAnnotation');
  }

  /**
   * Do the slot add.
   *
   * @inner
   * @param {baja.Component} comp
   * @param {Object} params
   * @param {String} params.slotName
   * @param {baja.Value} params.value
   * @param {Number} params.flags
   * @param {Object} [params.properties]
   * @returns {Promise}
   */
  function doAdd(comp, params) {
    var flags = params.flags,
      properties = params.properties,
      slotName = params.slotName,
      value = params.value;
    if (isComponent(value)) {
      value = value.newCopy(true);
      _.each(properties, function (valueToAdd, slotName) {
        if (slotName === 'wsAnnotation' && isAnnotation(valueToAdd)) {
          var existingAnno = value.get(slotName);
          if (isAnnotation(existingAnno)) {
            valueToAdd = valueToAdd.merge(existingAnno);
          }
        }
        value[value.has(slotName) ? 'set' : 'add']({
          slot: slotName,
          value: valueToAdd
        });
      });
    }
    if (comp.isMounted()) {
      //NCCB-35064
      slotName = baja.SlotPath.unescape(slotName);
    }
    return comp.add({
      slot: slotName + '?',
      value: value,
      flags: flags
    });
  }

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * A command for adding a new slot to an editor's `Component` value.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/AddSlotCommand
   * @param {baja.Component} component the component to invoke this command on
   * @param {object} params
   * @param {boolean} [params.undoable] true if the command should be undoable
   * @throws {Error} if no `Widget` provided
   */
  var AddSlotCommand = function AddSlotCommand(component) {
    var _this = this;
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      undoable = _ref.undoable;
    var ensureCanAdd = function ensureCanAdd(comp) {
      if (!_this.canPerformCommand(comp)) {
        throw new Error('cannot perform command');
      }
    };
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.addSlot',
      func: function func(params) {
        var comp = _this.$component;
        ensureCanAdd(comp);
        return _this.performCommand(comp, [], params || {});
      },
      undoable: undoable && function (params) {
        var comp = _this.$component;
        ensureCanAdd(comp);
        return _this.$makeUndoable(comp, [], params);
      }
    });
    this.setComponent(component);
  };
  AddSlotCommand.prototype = Object.create(Command.prototype);
  AddSlotCommand.prototype.constructor = AddSlotCommand;
  AddSlotCommand.prototype.setComponent = function (component) {
    this.setEnabled(this.canPerformCommand(component));
    this.$component = component;
  };

  /**
   * Require ADMIN_WRITE permissions.
   *
   * @param {baja.Component} comp
   * @returns {Boolean} true if I have admin write permissions on this component
   */
  AddSlotCommand.prototype.canPerformCommand = function (comp) {
    return isComponent(comp) && comp.getPermissions().hasAdminWrite();
  };

  /**
   * Either adds a new slot to the loaded component directly, or shows an Add
   * Slot dialog, then adds a new slot to the command's currently loaded
   * component using the data the user entered.
   *
   * @see module:nmodule/webEditors/rc/fe/baja/util/compUtils.promptForAddParameters
   * @param {baja.Component} comp
   * @param {Array.<baja.Slot>} slots
   * @param {Object} params
   * @param {String} [params.slotName] pass this and `value` to add a new slot
   * without prompting the user
   * @param {baja.Value} [params.value] pass this and `slotName` to add a new
   * slot without prompting the user
   * @param {String} [params.before] pass this to specify that the
   * added slot should go immediately before this one
   * @param {String} [params.after] pass this to specify that the
   * added slot should go immediately after this one
   * @param {Array.<baja.Value>} [params.bulkValues] pass an array of values
   * to add an arbitrary number of values; user will be prompted for a slot
   * name only if exactly one value is being added
   * @param {Array.<String>} [params.names] if using `bulkValues`, optionally
   * use this to pre-specify slot names to use
   * @param {Object} [params.properties] if adding a Component, specify a map
   * of baja Values to be set or added as Properties on that Component
   * @returns {Promise}
   * @see module:nmodule/webEditors/rc/fe/baja/util/compUtils#bulkAdd
   *
   * @example
   *   <caption>Add a number of new values with specified slot names.</caption>
   *   return addSlotCommand.invoke({
   *     bulkValues: [
   *       baja.$('control:NumericPoint'),
   *       baja.$('control:NumericPoint'),
   *       baja.$('control:NumericPoint')
   *     ],
   *     names: [ 'point1', 'point2', 'point3' ]
   *   });
   *
   * @example
   *   <caption>Add a number of new values; slot names will be auto-generated
   *   from the values' type specs.</caption>
   *   return addSlotCommand.invoke({
   *     bulkValues: [
   *       baja.$('control:NumericPoint'),
   *       baja.$('control:StringPoint')
   *     ]
   *   });
   *
   * @example
   *   <caption>Add a value with a specified slot name (user will not be
   *   prompted)</caption>
   *   return addSlotCommand.invoke({
   *     slotName: 'myNewPoint',
   *     value: baja.$('control:NumericPoint'),
   *     properties: { wsAnnotation: baja.$('baja:WsAnnotation', '1,2,3,4') }
   *   });
   *
   * @example
   *   <caption>Add a value, specifying which slot the new slot should go
   *   after.</caption>
   *   return addSlotCommand.invoke({
   *     slotName: 'larrySlot',
   *     value: 'Larry Fine',
   *     after: 'moeSlot'
   *   });
   *
   * @example
   *   <caption>Add a value, prompting the user for a slot name.</caption>
   *   return addSlotCommand.invoke({
   *     value: baja.$('control:NumericPoint')
   *   });
   */
  AddSlotCommand.prototype.performCommand = function (comp, slots, params) {
    var _this2 = this;
    var toAddTo = getTarget(comp, slots);
    var bulkValues = params.bulkValues;
    if (bulkValues) {
      if (!bulkValues.length) {
        return Promise.resolve();
      }
      return this.$promptForBulkSlotNames(params).then(function (names) {
        return names !== null && _this2.$bulkAdd(toAddTo, params, names);
      });
    }
    return this.$getSingleAddParams(toAddTo, params).then(function (addParams) {
      return addParams && _this2.$singleAdd(toAddTo, addParams);
    });
  };

  /**
   * @private
   * @param {baja.Component} toAddTo
   * @param {object} params params passed to `invoke`
   * @param {string[]} [names] names to use for the bulk values (may come from
   * a user prompt)
   * @returns {Promise} to be resolved after the bulk values have been added to
   * the component
   */
  AddSlotCommand.prototype.$bulkAdd = function (toAddTo, params, names) {
    var after = params.after,
      before = params.before,
      bulkValues = params.bulkValues,
      origin = params.origin;
    return bulkAdd(toAddTo, bulkValues, {
      names: names,
      origin: origin
    }).then(function (result) {
      return doReorder(toAddTo, {
        slots: result.insertNames,
        before: before,
        after: after
      }).then(function () {
        return result;
      });
    });
  };

  /**
   * @private
   * @param {object} params params passed to `invoke`
   * @returns {Promise.<string[]|null>} the names to use for the slots being
   * added in bulk, or null if the user was prompted and canceled
   */
  AddSlotCommand.prototype.$promptForBulkSlotNames = function (params) {
    var bulkValues = params.bulkValues,
      names = params.names;
    if (bulkValues.length === 1) {
      var value = bulkValues[0];
      var defaultSlotName = names && names[0] || toDefaultSlotName(value);
      var uniqueName = getUniqueName(this.$component, defaultSlotName);
      return this.$promptForSlotName(uniqueName).then(function (name) {
        return name && [name];
      });
    } else {
      return Promise.resolve(names);
    }
  };

  /**
   * @private
   * @param {baja.Component} toAddTo
   * @param {object} addParams
   * @returns {Promise} to be resolved after a single new slot has been added
   * to the component
   */
  AddSlotCommand.prototype.$singleAdd = function (toAddTo, addParams) {
    var after = addParams.after,
      before = addParams.before,
      slotName = addParams.slotName;
    return doAdd(toAddTo, addParams).then(function (addedSlot) {
      return doReorder(toAddTo, {
        slots: [slotName],
        before: before,
        after: after
      }).then(function () {
        return addedSlot;
      });
    });
  };

  /**
   * @private
   * @param {baja.Component} toAddTo
   * @param {object} params params passed to `invoke()`
   * @returns {Promise.<object|null>} resolves to an object that can be passed
   * to `baja.Component#add` to add the slot
   */
  AddSlotCommand.prototype.$getSingleAddParams = function (toAddTo, params) {
    var after = params.after,
      before = params.before,
      properties = params.properties,
      slotName = params.slotName,
      value = params.value;
    if (baja.hasType(value)) {
      if (slotName) {
        return Promise.resolve(params);
      } else {
        var defaultSlotName = result(value, 'getNavName') || value.getType().getTypeName();
        var uniqueName = getUniqueName(this.$component, defaultSlotName);
        return this.$promptForSlotName(uniqueName).then(function (slotName) {
          return extend({
            slotName: slotName
          }, params);
        });
      }
    }
    return this.$promptForAddParams(toAddTo, params).then(function (addParams) {
      return addParams && _.extend(addParams, {
        after: after,
        before: before,
        properties: properties
      });
    });
  };

  /**
   * @private
   * @param {baja.Component} comp
   * @param {Array.<baja.Slot>} slots
   * @param {object} params params passed to `invoke`
   * @returns {Promise.<module:bajaux/commands/Command~Undoable>}
   */
  AddSlotCommand.prototype.$makeUndoable = function (comp, slots) {
    var _this3 = this;
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var toAddTo = getTarget(comp, slots);
    var bulkValues = params.bulkValues;
    var getText = function getText(suffix, names) {
      return webEditorsLex.get({
        key: 'commands.addSlot.' + suffix,
        args: [formatDisplayNames(names), getDisplayName(toAddTo)]
      });
    };
    if (bulkValues) {
      if (!bulkValues.length) {
        return;
      }
      return this.$promptForBulkSlotNames(params).then(function (names) {
        if (names === null) {
          return;
        }
        var undoKey;
        var insertNames;
        return {
          redo: function redo() {
            return _this3.$bulkAdd(toAddTo, params, names).then(function (result) {
              undoKey = result.undoKey;
              insertNames = result.insertNames;
            });
          },
          undo: function undo() {
            if (undoKey) {
              return baja.transfer.undo({
                undoKey: undoKey
              });
            } else {
              return Promise.all(insertNames.map(function (slot) {
                return toAddTo.remove({
                  slot: slot
                });
              }));
            }
          },
          redoText: function redoText() {
            return getText('redoText', names.map(baja.SlotPath.unescape));
          },
          undoText: function undoText() {
            return getText('undoText', insertNames.map(function (slot) {
              return comp.getDisplayName(slot);
            }));
          }
        };
      });
    }
    return this.$getSingleAddParams(toAddTo, params).then(function (addParams) {
      if (!addParams) {
        return;
      }
      var slotName = addParams.slotName;
      if (slotName == null) {
        return;
      }
      var addedSlot;
      return {
        redo: function redo() {
          return _this3.$singleAdd(toAddTo, addParams).then(function (s) {
            addedSlot = s;
          });
        },
        undo: function undo() {
          return toAddTo.remove({
            slot: addedSlot
          });
        },
        redoText: function redoText() {
          return getText('redoText', [baja.SlotPath.unescape(slotName)]);
        },
        undoText: function undoText() {
          return getText('undoText', [toAddTo.getDisplayName(slotName)]);
        }
      };
    });
  };

  /**
   * @private
   * @param {baja.Component} toAddTo
   * @param {object} params params passed to `invoke`
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/commands/AddSlotEditor~AddSlotParams>}
   */
  AddSlotCommand.prototype.$promptForAddParams = function (toAddTo, params) {
    return promptForAddParameters(toAddTo, params);
  };

  /**
   * @private
   * @param {baja.Value} value the value being added
   * @returns {Promise.<string>} the slot name entered by the user
   */
  AddSlotCommand.prototype.$promptForSlotName = function (value) {
    return promptForSlotName(value);
  };
  function getTarget(comp, _ref2) {
    var _ref3 = _slicedToArray(_ref2, 1),
      firstSlot = _ref3[0];
    return firstSlot ? comp.get(firstSlot) : comp;
  }
  function toDefaultSlotName(value) {
    return result(value, 'getNavName') || value.getType().getTypeName();
  }
  return AddSlotCommand;
});
