/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/CompositeEditorCommand
 */
define(['lex!workbench', 'Promise', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/commands/ComponentEditorCommand', 'nmodule/webEditors/rc/wb/composite/CompositeEditor', 'nmodule/webEditors/rc/wb/menu/menuUtils'], function (lexs, Promise, feDialogs, ComponentEditorCommand, CompositeEditor, menuUtils) {
  'use strict';

  var workbenchLex = lexs[0];

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * A command for compositing slots on an editor's `Component` value.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/commands/ComponentEditorCommand
   * @alias module:nmodule/webEditors/rc/wb/commands/CompositeEditorCommand
   * @param {baja.Component} component the component on which to Composite
   * slots
   * @throws {Error} if no `Widget` provided
   * @see nmodule/webEditors/rc/wb/composite/CompositeEditor
   */
  var CompositeEditorCommand = function CompositeEditorCommand(component) {
    var that = this;
    ComponentEditorCommand.call(that, {
      module: 'webEditors',
      lex: 'commands.composite'
    }, component);
  };
  CompositeEditorCommand.prototype = Object.create(ComponentEditorCommand.prototype);
  CompositeEditorCommand.prototype.constructor = CompositeEditorCommand;

  /**
   * Make sure we have admin write permissions on the parent component
   *
   * @param {baja.Component} comp the parent component of the slot being composited
   * @returns {Boolean} true if I can Composite the slot
   */
  CompositeEditorCommand.prototype.canPerformCommand = function (comp) {
    return comp.getPermissions().hasAdminWrite();
  };

  /**
   * @param {baja.Component} comp Parent component of the slot being composited
   * @param {Array.<baja.Slot>} slots the slots to composite (*Note*: only the
   * first given slot will be composited)
   * @returns {Promise}
   */
  CompositeEditorCommand.prototype.performCommand = function (comp, slots) {
    var slot = slots[0];
    if (!slot) {
      return Promise.reject(new Error('slot to composite required'));
    }
    return feDialogs.showFor({
      title: workbenchLex.get('compositeEditor.title'),
      type: CompositeEditor,
      value: comp.get(slot)
    });
  };
  return CompositeEditorCommand;
});
