/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/LinkFromCommand
 */
define(['underscore', 'nmodule/webEditors/rc/wb/commands/LinkCommand'], function (_, LinkCommand) {
  'use strict';

  var extend = _.extend;

  /**
   * @class
   * @extends module:nmodule/webEditors/rc/wb/commands/LinkCommand
   * @alias module:nmodule/webEditors/rc/wb/commands/LinkFromCommand
   * @param {object} params
   * @param {baja.Component|Array.<baja.Component>} params.subject the link source component(s)
   */
  var LinkFromCommand = function LinkFromCommand(params) {
    LinkCommand.call(this, extend({
      direction: 'from',
      lex: 'commands.linkFrom'
    }, params));
  };
  LinkFromCommand.prototype = Object.create(LinkCommand.prototype);
  LinkFromCommand.prototype.constructor = LinkFromCommand;

  /**
   *
   * @param {module:nmodule/webEditors/rc/wb/commands/LinkFromCommand|*} cmd
   * @returns {module:nmodule/webEditors/rc/wb/commands/LinkFromCommand|null}
   */
  LinkFromCommand.prototype.merge = function (cmd) {
    if (!(cmd instanceof LinkFromCommand)) {
      return null;
    }
    var mySubject = this.$subject || [];
    var hisSubject = cmd.$subject || [];
    return new LinkFromCommand({
      subject: mySubject.concat(hisSubject)
    });
  };

  /**
   * Make a LinkFromCommand and initialize it.
   *
   * @param {baja.Component|Array.<baja.Component>} subject the link source component(s)
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/commands/LinkFromCommand>} promise
   * that resolves to a LinkFromCommand after the command has been initialized.
   */
  LinkFromCommand.make = function (subject) {
    return new LinkFromCommand({
      subject: subject
    }).init();
  };
  return LinkFromCommand;
});
