function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/RelateCommand
 */

define(['baja!', 'baja!baja:Relation', 'lex!baja,webEditors', 'bajaux/commands/Command', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/links/RelatePad', 'nmodule/webEditors/rc/wb/util/TransferDataManager'], function (baja, types, lexs, Command, Promise, _, feDialogs, compUtils, typeUtils, RelatePad, TransferDataManger) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    bajaLex = _lexs[0],
    webEditorsLex = _lexs[1];
  var all = _.all,
    flatten = _.flatten;
  var formatDisplayNames = compUtils.formatDisplayNames;
  var isComponent = typeUtils.isComponent;
  var DUPLICATE_RELATION = bajaLex.get('relationcheck.relationAlreadyExists');
  var RELATE_TO_SELF = bajaLex.get('relationcheck.cannotRelateToSelf');
  var transferDataManager = TransferDataManger.getInstance();

  /**
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/RelateCommand
   * @param {object} params
   * @param {string} params.lex
   * @param {baja.Component|Array.<baja.Component>} params.subject the
   * components on which the command will be invoked
   * @param {baja.Component|Array.<baja.Component>} params.object the components
   * on the other end of the relations to be created
   * @param {string} [params.direction='from'] the direction the relation will go -
   * `to` means relation goes out from subject to object (subject receives the
   * `Relation`), `from` means relation goes in from object to subject (object
   * receives the `Relation`). In both cases, the object is what you called
   * Relate Mark on, the subject is what you called Relate From or Relate To on.
   * To keep it straight in your head, imagine the end result of two related
   * components on the wiresheet: []----[] - `from` means i did Relate Mark on
   * the left and Relate From on the right, `to` means i did Relate Mark on the
   * right and Relate To on the left. or: if i invoke Relate To, the guy i
   * invoke the command on gets a Relation to my Relate Marked component; if i
   * invoke Relate From, my Relate Marked component gets a Relation to the guy i
   * invoked the command on.
   */
  var RelateCommand = /*#__PURE__*/function (_Command) {
    function RelateCommand() {
      var _this;
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _classCallCheck(this, RelateCommand);
      var _params$direction = params.direction,
        direction = _params$direction === void 0 ? 'from' : _params$direction,
        lex = params.lex,
        object = params.object,
        relationId = params.relationId,
        subject = params.subject;
      _this = _callSuper(this, RelateCommand, [{
        module: 'webEditors',
        lex: lex,
        undoable: function undoable() {
          return _this.$makeUndoable();
        }
      }]);
      _this.$direction = direction;
      _this.$lex = lex;
      _this.$object = object && [].concat(object);
      _this.$relationId = relationId;
      _this.$subject = [].concat(subject);
      return _this;
    }

    /**
     * @param {baja.Component} source
     * @param {baja.Component} target
     * @param {string} relationId
     * @returns {boolean} if a relation from source to target exists
     */
    _inherits(RelateCommand, _Command);
    return _createClass(RelateCommand, [{
      key: "init",
      value:
      /**
       * Resolves once the command has been initialized.
       *
       * @returns {Promise}
       */
      function init() {
        var _this2 = this;
        return this.getRelationMark().then(function (marks) {
          return _this2.setEnabled(marks.length > 0);
        });
      }

      /**
       * Resolves the `baja:INavNode` that are currently selected via relation mark.
       *
       * @returns {Promise.<Array.<baja.NavNode>>}
       */
    }, {
      key: "getRelationMark",
      value: function getRelationMark() {
        return transferDataManager.getRelationMark();
      }

      /**
       * @private
       * @returns {Promise.<module:bajaux/commands/Command~Undoable>}
       */
    }, {
      key: "$makeUndoable",
      value: function $makeUndoable() {
        var _this3 = this;
        return this.getSourceTarget().then(function (_ref) {
          var sources = _ref.sources,
            targets = _ref.targets;
          //Promise.resolve(this.$relationId || RelateCommand.$promptForRelationId(this)
          var relationId = _this3.$relationId;
          if (relationId) {
            return {
              relationId: relationId,
              sources: sources,
              targets: targets
            };
          }
          return RelateCommand.$promptForRelationId({
            sources: sources,
            targets: targets
          });
        }).then(function (result) {
          if (!result) {
            return;
          }
          var relationId = result.relationId,
            sources = result.sources,
            targets = result.targets;
          var checks;
          var sourceNames = formatDisplayNames(sources);
          var targetNames = formatDisplayNames(targets);
          var allSourcesAndTargetsMounted = function allSourcesAndTargetsMounted() {
            return all(sources.concat(targets), function (c) {
              return isComponent(c) && c.isMounted();
            });
          };
          return {
            redo: function redo() {
              checks = checkRelations(sources, targets, relationId);
              return addRelations(checks);
            },
            undo: function undo() {
              return removeRelations(checks);
            },
            undoText: function undoText() {
              return webEditorsLex.get({
                key: 'commands.relate.undoText',
                args: [sourceNames, targetNames]
              });
            },
            redoText: function redoText() {
              return webEditorsLex.get({
                key: 'commands.relate.redoText',
                args: [sourceNames, targetNames]
              });
            },
            canUndo: allSourcesAndTargetsMounted,
            canRedo: allSourcesAndTargetsMounted
          };
        });
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/links/RelatePad~RelationParams} obj
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/links/RelatePad~RelationParams>}
       */
    }, {
      key: "$saveRelations",
      value:
      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/links/RelatePad~RelationParams} obj
       * @returns {Promise} resolve when all relations are saved
       */
      function $saveRelations(_ref2) {
        var sources = _ref2.sources,
          targets = _ref2.targets,
          relationId = _ref2.relationId;
        var checks;
        try {
          checks = checkRelations(sources, targets, relationId);
        } catch (invalidError) {
          return feDialogs.error(invalidError);
        }
        return addRelations(checks);
      }

      /**
       * Resolves an array of the display names for all of the currently selected
       * `baja:INavNode` via relation mark.
       *
       * @returns {Promise.<Array.<String>>}
       */
    }, {
      key: "resolveRelationMarkDisplayNames",
      value: function resolveRelationMarkDisplayNames() {
        return getRelationMark().then(function (marks) {
          return marks.map(function (mark) {
            return mark.getNavDisplayName();
          });
        });
      }

      /**
       * Resolves an Object with the sources and the targets to be considered when
       * the relation command is invoked. This method must be implemented by child
       * classes.
       *
       * @returns {Promise.<Object>}
       */
    }, {
      key: "getSourceTarget",
      value: function getSourceTarget() {
        var invokeTargets = this.$subject;
        var invokeTargetsOnLeft = this.$direction === 'to';
        return Promise.resolve(this.$object || RelateCommand.$getRelationMarkedComponents()).then(function (markedComponents) {
          if (invokeTargetsOnLeft) {
            return {
              sources: invokeTargets,
              targets: markedComponents
            };
          } else {
            return {
              sources: markedComponents,
              targets: invokeTargets
            };
          }
        });
      }
    }, {
      key: "toDisplayName",
      value:
      /**
       * Resolves the name to be displayed for this command. The display names for
       * the `baja:INavNodes` list will be limited to 30 characters.
       *
       * @returns {Promise.<String>}
       */
      function toDisplayName() {
        var _this4 = this;
        return this.resolveRelationMarkDisplayNames().then(function (markNames) {
          var namesString = formatDisplayNames(markNames);
          return webEditorsLex.get(_this4.$lex, namesString);
        });
      }
    }], [{
      key: "hasRelation",
      value: function hasRelation(source, target, relationId) {
        var relationsOnly = function relationsOnly(slot) {
          return slot.isProperty() && slot.getType().is('baja:Relation') && !slot.getType().is('baja:Link');
        };
        var relations = source.getSlots().filter(relationsOnly).toValueArray();
        var _iterator = _createForOfIteratorHelper(relations),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var relation = _step.value;
            if (relation.getSourceOrd().toString() === getHandleOrd(target).toString() && relation.getRelationId() === relationId) {
              return true;
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
        return false;
      }
    }, {
      key: "$promptForRelationId",
      value: function $promptForRelationId(_ref3) {
        var sources = _ref3.sources,
          targets = _ref3.targets;
        return RelatePad.doDialog({
          sources: sources,
          targets: targets
        });
      }
    }, {
      key: "$getRelationMarkedComponents",
      value: function $getRelationMarkedComponents() {
        return getRelationMark().then(resolveNavNodesToLeasedComponents);
      }
    }]);
  }(Command);
  return RelateCommand;

  /**
   * @param {Array.<baja.Component>} sources
   * @param {Array.<baja.Component>} targets
   * @param {string} relationId
   * @returns {RelationCheck[]}
   */
  function checkRelations(sources, targets, relationId) {
    return flatten(sources.map(function (source) {
      return targets.map(function (target) {
        if (RelateCommand.hasRelation(source, target, relationId)) {
          throw new Error(DUPLICATE_RELATION);
        }
        if (source.getNavOrd().toString() === target.getNavOrd().toString()) {
          throw new Error(RELATE_TO_SELF);
        }
        return {
          source: source,
          target: target,
          relationId: relationId
        };
      });
    }));
  }

  /**
   * @param {RelationCheck[]} relationChecks
   * @returns {Promise.<RelationCheck[]>}
   */
  function addRelations(relationChecks) {
    return Promise.all(relationChecks.map(function (relationCheck) {
      var source = relationCheck.source,
        target = relationCheck.target,
        relationId = relationCheck.relationId;
      return source.add({
        slot: "relation?",
        value: baja.$('baja:Relation', {
          relationId: relationId,
          sourceOrd: getHandleOrd(target)
        })
      }).then(function (slotName) {
        relationCheck.slotName = slotName;
        return relationCheck;
      });
    }));
  }

  /**
   * @param {Array.<RelationCheck>} relationChecks
   * @returns {Promise}
   */
  function removeRelations(relationChecks) {
    return Promise.all(relationChecks.map(function (relationCheck) {
      var source = relationCheck.source,
        slotName = relationCheck.slotName;
      return source.remove(slotName);
    }));
  }
  function getHandleOrd(component) {
    return baja.Ord.make("h:" + component.getHandle());
  }
  function resolveNavNodesToLeasedComponents(nodes) {
    return Promise.all(nodes.map(function (navNode) {
      return navNode.getNavOrd().get({
        lease: true
      });
    }));
  }
  function getRelationMark() {
    return transferDataManager.getRelationMark();
  }

  /**
   * @private
   * @inner
   * @typedef {object} RelationCheck
   * @property {baja.Component} source
   * @property {baja.Component} target
   * @property {string} relationId
   * @property {string} slotName
   */
});
