function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/UndoCommand
 */
define(['bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu'], function (Command, CommandGroup, feDialogs, CommandGroupContextMenu) {
  'use strict';

  /**
   * A command to invoke Undos.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/commands/UndoCommand
   * @extends module:bajaux/commands/Command
   */
  var UndoCommand = /*#__PURE__*/function (_Command) {
    /**
     * Bind the command to the UndoManager and ensure it's kept up to date with
     * status events from it.
     *
     * @param {module:bajaux/commands/UndoManager} mgr
     */
    function UndoCommand(mgr) {
      var _this;
      _classCallCheck(this, UndoCommand);
      _this = _callSuper(this, UndoCommand, [{
        module: 'bajaux',
        lex: 'commands.undo',
        enabled: false,
        func: function func() {
          return mgr.undo()["catch"](feDialogs.error);
        }
      }]);
      mgr.on('undoStatus', function (undoStatus) {
        var description = undoStatus.description,
          displayName = undoStatus.displayName,
          enabled = undoStatus.enabled;
        _this.setDescriptionFormat(description);
        _this.setDisplayNameFormat(displayName);
        _this.setEnabled(enabled);
      });
      return _this;
    }

    /**
     * When UndoCommand is invoked from a CommandButton, do the undo via a
     * popup with the command's description, so the user doesn't blindly click
     * on an undo arrow without knowing what action they're about to take.
     *
     * @param {JQuery.Event} event
     * @returns {Promise}
     */
    _inherits(UndoCommand, _Command);
    return _createClass(UndoCommand, [{
      key: "invokeFromEvent",
      value: function invokeFromEvent(event) {
        return UndoCommand.$invokeWithPopup(this, event);
      }

      /**
       * @private
       * @param {module:bajaux/commands/Command} cmd
       * @param {JQuery.Event} event
       * @returns {Promise}
       */
    }], [{
      key: "$invokeWithPopup",
      value: function $invokeWithPopup(cmd, event) {
        var proxyCmd = new Command({
          displayName: cmd.getDescriptionFormat(),
          icon: cmd.getIcon(),
          func: function func() {
            return cmd.invoke();
          }
        });
        var group = new CommandGroup({
          commands: [proxyCmd]
        });
        return CommandGroupContextMenu.show({
          event: event,
          group: group
        });
      }
    }]);
  }(Command);
  return UndoCommand;
});
