function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 *
 * @module nmodule/webEditors/rc/wb/links/LinkOrRelatePad
 */
define(['baja!', 'lex!baja,webEditors', 'log!nmodule.webEditors.rc.wb.links.LinkOrRelatePad', 'bajaux/events', 'bajaux/spandrel', 'Promise', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/links/LinkPad', 'nmodule/webEditors/rc/wb/links/RelatePad', 'css!nmodule/webEditors/rc/fe/webEditors-structure'], function (baja, lexs, log, events, spandrel, Promise, BooleanEditor, feDialogs, LinkPad, RelatePad) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    bajaLex = _lexs[0],
    webEditorsLex = _lexs[1];
  var MODIFY_EVENT = events.MODIFY_EVENT;
  var logError = log.severe.bind(log);
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        isRelation: false
      }
    };
  };

  /**
   * Editor for creating links and relations between components.
   *
   * Following `bajaux` `Properties` are supported.
   *
   * `selectedSlot` property is an `Object` and it will be set by the caller, for example: WbInteractionController.
   * `selected` source-component's slot or/and target-component's slot,
   * will let the SlotChooser know to pre-select a component's slot upon its doLoad.
   *
   * @example
   * Source slot in16 will be selected upon load by the SlotChooser
   * selectedSlot: {
   *   source:  'in16',
   * }
   *
   * Target slot in4 will be selected upon load by the SlotChooser
   * selectedSlot: {
   *   target: 'in4'
   * }
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/webEditors/rc/wb/links/LinkOrRelatePad
   */
  var LinkOrRelatePad = /*#__PURE__*/function (_spandrel) {
    function LinkOrRelatePad(params) {
      var _this;
      _classCallCheck(this, LinkOrRelatePad);
      _this = _callSuper(this, LinkOrRelatePad, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.validators().add(function () {
        if (_this.properties().getValue('isRelation')) {
          return _this.$getRelatePad().validate();
        }
        return _this.$getLinkPad().validate();
      });
      return _this;
    }
    _inherits(LinkOrRelatePad, _spandrel);
    return _createClass(LinkOrRelatePad, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.on(MODIFY_EVENT, '.typeEditor', function () {
          _this2.$getTypeEditor().read().then(function (isRelation) {
            _this2.properties().setValue('isRelation', isRelation);
            _this2.$toggleEditorVisibility();
          })["catch"](logError);
          return false;
        });
        dom.on(MODIFY_EVENT, '.relatePad, .typeEditor, .linkPad', function () {
          _this2.setModified(true);
          return false;
        });
      }

      /**
       * Returns the result of the user selection including details of the users
       * selection.
       *
       * @return {Promise.<module:nmodule/webEditors/rc/wb/links/LinkOrRelatePad~result>}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var _this3 = this;
        return this.$getTypeEditor().read().then(function (isRelation) {
          if (isRelation) {
            return Promise.all(['relate', _this3.$getRelatePad().read()]);
          }
          return Promise.all(['link', _this3.$getLinkPad().read()]);
        }).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            type = _ref2[0],
            value = _ref2[1];
          return {
            type: type,
            value: value
          };
        });
      }
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this4 = this;
        return _superPropGet(LinkOrRelatePad, "doLoad", this, 3)([value]).then(function () {
          return _this4.$toggleEditorVisibility();
        });
      }

      /**
       * Open a dialog for the LinkOrRelatePad editor.
       *
       * @param {module:nmodule/webEditors/rc/wb/links/LinkOrRelatePad~loadInfo} value
       * @param {Object} properties
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/links/LinkOrRelatePad~result>}
       */
    }, {
      key: "$getTypeEditor",
      value:
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
      function $getTypeEditor() {
        return this.queryWidget('typeEditor');
      }

      /**
       * @private
       */
    }, {
      key: "$toggleEditorVisibility",
      value: function $toggleEditorVisibility() {
        var isRelation = this.properties().getValue('isRelation');
        this.$getLinkPad().jq().toggle(!isRelation);
        this.$getRelatePad().jq().toggle(isRelation);
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getLinkPad",
      value: function $getLinkPad() {
        return this.queryWidget('editor/link');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getRelatePad",
      value: function $getRelatePad() {
        return this.queryWidget('editor/relation');
      }

      /**
       * Requests focus on LinkPad.
       */
    }, {
      key: "requestFocus",
      value: function requestFocus() {
        var linkPad = this.$getLinkPad();
        linkPad && linkPad.requestFocus();
      }
    }], [{
      key: "doDialog",
      value: function doDialog(value, properties) {
        return feDialogs.showFor({
          title: webEditorsLex.get('LinkOrRelatePad.addLinkOrRelation'),
          value: {
            value: value
          },
          type: LinkOrRelatePad,
          properties: properties
        });
      }
    }]);
  }(spandrel(function (obj, _ref3) {
    var properties = _ref3.properties;
    var isRelation = properties.isRelation,
      selectedSlot = properties.selectedSlot,
      typeEditor = {
        dom: '<div class="typeEditor"></div>',
        value: isRelation,
        type: BooleanEditor,
        properties: {
          trueText: webEditorsLex.get('LinkOrRelatePad.relate'),
          falseText: webEditorsLex.get('LinkOrRelatePad.link'),
          falseIcon: bajaLex.get('neutral.icon'),
          trueIcon: bajaLex.get('neutral.icon')
        }
      };
    return {
      typeEditor: typeEditor,
      editor: {
        dom: "<div class=\"LinkOrRelatePad-editor\"></div>",
        kids: {
          relation: {
            dom: "<div class=\"relatePad\"></div>",
            value: obj.value,
            type: RelatePad
          },
          link: {
            dom: "<div class=\"linkPad\"></div>",
            value: obj.value,
            type: LinkPad,
            properties: {
              selectedSlot: selectedSlot
            }
          }
        }
      }
    };
  }));
  /**
   * @typedef module:nmodule/webEditors/rc/wb/links/LinkOrRelatePad~result
   * @property {String} type the selected operation type: `link` or `relate`.
   * @property {module:nmodule/webEditors/rc/wb/links/LinkPad~LinkCheckParams|String|null} value
   * the value to be considered for the operation. If link selected, this will
   * be the link information or null if no selection was make on the LinkPad.
   * If relate, this will be the type of relation the user selected (such as
   * `n:child`).
   */
  /**
   * @typedef module:nmodule/webEditors/rc/wb/links/LinkOrRelatePad~loadInfo
   * @property {Array.<baja.Component>} sources the components that the relation
   * or link starts from
   * @property {Array.<baja.Component>} targets the components that the relation
   * or link goes to
   */
  return LinkOrRelatePad;
});
