function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/links/LinkPad
 */
define(['baja!', 'baja!baja:Component', 'log!nmodule.webEditors.rc.wb.links.LinkPad', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'lex!webEditors', 'underscore', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/baja/linkCheckUtil', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/links/SlotChooser', 'hbs!nmodule/webEditors/rc/wb/links/template/LinkPad'], function (baja, types, log, Command, CommandButton, lexs, _, Promise, fe, linkCheckUtil, feDialogs, BaseWidget, typeUtils, SlotChooser, tplLinkPad) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var extend = _.extend;
  var checkLinks = linkCheckUtil.checkLinks;
  var isComponent = typeUtils.isComponent;
  var logError = log.severe.bind(log);

  /**
   * Editor to link slots between components
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @alias module:nmodule/webEditors/rc/wb/links/LinkPad
   * @param {Object} params
   */
  var LinkPad = function LinkPad(params) {
    var that = this;
    that.$isSwapped = false;
    BaseWidget.apply(that, arguments);
    that.$swapCommand = new Command({
      module: 'webEditors',
      lex: 'commands.linking.reverse',
      func: function func() {
        return that.$handleSwapButton();
      }
    });
    that.getCommandGroup().add(that.$swapCommand);
    that.validators().add(function () {
      if (that.$getOutgoingSlotChooser().getSelectedSlot() && that.$getIncomingSlotChooser().getSelectedSlot()) {
        return;
      }
      throw new Error(webEditorsLex.get('LinkPad.needSourceAndTarget'));
    });
  };
  LinkPad.prototype = Object.create(BaseWidget.prototype);
  LinkPad.prototype.constructor = LinkPad;

  ////////////////////////////////////////////////////////////////
  // Private functions
  ////////////////////////////////////////////////////////////////

  /**
   * Get the swap command button
   *
   * @private
   * @returns {Command}
   */
  LinkPad.prototype.$getSwapCommand = function () {
    return this.$swapCommand;
  };

  /**
   * Get the element containing the specified slot chooser.
   *
   * @private
   * @param {Boolean} incoming
   * @returns {jQuery}
   */
  LinkPad.prototype.$getSlotChooserElement = function (incoming) {
    if (incoming) {
      return this.jq().find('.LinkPad-incoming-SlotChooser');
    } else {
      return this.jq().find('.LinkPad-outgoing-SlotChooser');
    }
  };

  /**
   * Get the element containing the incoming slot chooser.
   *
   * @private
   * @returns {jQuery}
   */
  LinkPad.prototype.$getIncomingElement = function () {
    return this.$getSlotChooserElement(!this.$isSwapped);
  };

  /**
   * Get the incoming `SlotChooser`.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/wb/links/SlotChooser}
   */
  LinkPad.prototype.$getIncomingSlotChooser = function () {
    return this.$getIncomingElement().data('widget');
  };

  /**
   * Get the element containing the outgoing slot chooser.
   *
   * @private
   * @returns {jQuery}
   */
  LinkPad.prototype.$getOutgoingElement = function () {
    return this.$getSlotChooserElement(this.$isSwapped);
  };

  /**
   * Get the outgoing `SlotChooser`.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/wb/links/SlotChooser}
   */
  LinkPad.prototype.$getOutgoingSlotChooser = function () {
    return this.$getOutgoingElement().data('widget');
  };

  /**
   * Create a filter and set it on specified SlotChooser
   *
   * The new filter will indicate if a link is valid based on the opposing `SlotChooser`
   * current selection.
   *
   * @private
   * @param {module:nmodule/webEditors/rc/wb/links/SlotChooser} filterTarget
   */
  LinkPad.prototype.$setFilter = function (filterTarget) {
    var that = this;
    return filterTarget.setEnableFilter(function (slot, batch) {
      var sourceSlot, targetSlot;
      if (filterTarget.$isTarget) {
        sourceSlot = that.$getOutgoingSlotChooser().getSelectedSlot();
        targetSlot = slot;
      } else {
        sourceSlot = slot;
        targetSlot = that.$getIncomingSlotChooser().getSelectedSlot();
      }
      if (!sourceSlot || !targetSlot) {
        return [true, null, null];
      }
      return checkLinks({
        sources: that.$sources,
        targets: that.$targets,
        sourceSlot: sourceSlot,
        targetSlot: targetSlot,
        batch: batch
      }, true).then(function (linkChecks) {
        var lastGoodLink;
        for (var i = 0; i < linkChecks.length; i++) {
          var linkCheckGroup = linkChecks[i];
          for (var j = 0; j < linkCheckGroup.length; j++) {
            var linkCheck = linkCheckGroup[j];
            if (linkCheck) {
              var serverResult = linkCheck.serverLinkCheck;
              if (!linkCheck.isValid()) {
                return [linkCheck.isValid(), linkCheck.getInvalidReason(), serverResult];
              }
              lastGoodLink = [linkCheck.isValid(), linkCheck.getInvalidReason(), serverResult];
            }
          }
        }
        if (lastGoodLink) {
          return lastGoodLink;
        }
        return false;
      });
    });
  };
  LinkPad.prototype.getSubscriber = function () {
    var that = this;
    if (!that.$subscriber) {
      that.$subscriber = new baja.Subscriber();
    }
    return that.$subscriber;
  };

  ////////////////////////////////////////////////////////////////
  // LinkPad event handlers
  ////////////////////////////////////////////////////////////////

  /**
   * Event handler that is called when one of the child SlotChooser has a selection change.
   *
   * @private
   * @param {Slot} selected
   * @param {Slot} previouslySelected
   * @param {SlotChooser} slotChooser
   * @returns {Promise}
   */
  LinkPad.prototype.$handleChoice = function (selected, previouslySelected, slotChooser) {
    var that = this;
    if (slotChooser.$isTarget) {
      // If the slotChooser is a target, set the filter on the outgoing first,
      // and then set the filter on the incoming.
      return that.$setFilter(that.$getOutgoingSlotChooser()).then(function () {
        return that.$setFilter(that.$getIncomingSlotChooser());
      });
    } else {
      // If the slotChooser is not a target, set the filter on the incoming first,
      // and then set the filter on the outgoing.
      return that.$setFilter(that.$getIncomingSlotChooser()).then(function () {
        return that.$setFilter(that.$getOutgoingSlotChooser());
      });
    }
  };

  /**
   * Event handler that is called the swap button is pressed
   *
   * @private
   */
  LinkPad.prototype.$handleSwapButton = function () {
    var that = this,
      outChooser = that.$getOutgoingSlotChooser(),
      inChooser = that.$getIncomingSlotChooser();

    // Invert the isSwapped indicator
    that.$isSwapped = !that.$isSwapped;

    // Swap the columns on-screen using a flex box
    that.jq().find('.LinkPad-flex-container').toggleClass('LinkPad-flex-reversed', that.$isSwapped);

    // Swap the targets
    inChooser.$isTarget = false;
    outChooser.$isTarget = true;

    // Swap the incoming / outgoing "Target" vs "Source" titles
    var outText, inText;
    if (that.$isSwapped) {
      inText = webEditorsLex.get('SlotChooser.source');
      outText = webEditorsLex.get('SlotChooser.target');
    } else {
      inText = webEditorsLex.get('SlotChooser.target');
      outText = webEditorsLex.get('SlotChooser.source');
    }
    that.jq().find('.LinkPad-outgoing-title-ts').text(outText);
    that.jq().find('.LinkPad-incoming-title-ts').text(inText);

    // Swap sources with targets;
    var tmp = that.$sources;
    that.$sources = that.$targets;
    that.$targets = tmp;

    // Re-filter in case a slot combination is no longer valid, preferring to
    // deselect the incoming slot chooser over the outgoing chooser.
    return that.$setFilter(that.$getIncomingSlotChooser()).then(function () {
      return that.$setFilter(that.$getOutgoingSlotChooser());
    });
  };

  ////////////////////////////////////////////////////////////////
  // LinkPad bajaux implementation
  ////////////////////////////////////////////////////////////////

  /**
   * Initializes the incoming and outgoing slot choosers
   * @param {JQuery} dom
   * @returns {Promise} A promise to be resolved once the widget has
   * initialized
   */
  LinkPad.prototype.doInitialize = function (dom) {
    dom.html(tplLinkPad({
      source: webEditorsLex.get('SlotChooser.source'),
      target: webEditorsLex.get('SlotChooser.target')
    })).addClass('LinkPad');
    var _ref = this.properties().getValue('selectedSlot') || {},
      source = _ref.source,
      target = _ref.target;
    var that = this,
      formFactor = that.getFormFactor(),
      props = that.properties(),
      readonly = that.isReadonly(),
      inReadonly = props.getValue('editIncoming') === false || readonly,
      outReadonly = props.getValue('editOutgoing') === false || readonly,
      //Source
      outChooser = new SlotChooser({
        formFactor: formFactor,
        readonly: outReadonly,
        properties: {
          selectedSlot: source
        }
      }),
      //Target
      inChooser = new SlotChooser({
        formFactor: formFactor,
        readonly: inReadonly,
        properties: {
          selectedSlot: target
        }
      });
    function eventHandler(selection, previousSelection, slotChooser) {
      that.setModified(true);
      that.$handleChoice(selection, previousSelection, slotChooser)["catch"](logError);
    }
    outChooser.on('selectionChanged', eventHandler);
    inChooser.on('selectionChanged', eventHandler);
    inChooser.$isTarget = true;
    return Promise.all([fe.buildFor({
      value: that.$getSwapCommand(),
      dom: dom.find('.js-dialog-button-swap'),
      type: CommandButton
    }), outChooser.initialize(that.$getOutgoingElement()), inChooser.initialize(that.$getIncomingElement())]);
  };

  /**
   * Implement the BaseWidget doLoad
   *
   * @param {Object} value
   * @param {Array.<baja.Component>} value.sources components that are being linked.
   * @param {Array.<baja.Component>} value.targets components that are being linked.
   * @param {String} [sourceSlot] optional source slot to pre-select
   * @param {String} [targetSlot] optional target slot to pre-select
   *
   * @returns {Promise} resolves after sources and targets are loaded into their
   * corresponding slot choosers.
   */
  LinkPad.prototype.doLoad = function (value) {
    var that = this;
    if (!_.isObject(value)) {
      die('object required');
    }
    var sources = value.sources,
      targets = value.targets;
    if (!_.isArray(sources) || !_.isArray(targets)) {
      die('LinkPad requires sources and targets specified');
    }
    var source = sources[0],
      target = targets[0],
      dom = that.jq();

    // TODO support multiple sources / targets
    if (!isComponent(source)) {
      die('LinkPad source must be a component');
    }
    if (!isComponent(target)) {
      die('LinkPad target must be a component');
    }
    that.$sources = sources;
    that.$targets = targets;
    dom.find('.LinkPad-outgoing-title-comp').text(getDisplayName(sources));
    dom.find('.LinkPad-incoming-title-comp').text(getDisplayName(targets));
    var subscriptions = that.getSubscriber().subscribe(sources.concat(targets));

    // Wait for the subscriptions to finish, then load sources and targets
    return subscriptions.then(function () {
      return Promise.all([that.$getOutgoingSlotChooser().load(sources), that.$getIncomingSlotChooser().load(targets)]).then(function () {
        value.sourceSlot && that.$getOutgoingSlotChooser().setSelectedSlot(sources[0].getSlot(value.sourceSlot), true);
        value.targetSlot && that.$getIncomingSlotChooser().setSelectedSlot(targets[0].getSlot(value.targetSlot), true);
      });
    });
  };
  function getDisplayName(list) {
    var displayName = list[0].getDisplayName();
    if (list.length > 1) {
      displayName += " (" + list.length + ")...";
    }
    return displayName;
  }

  /**
   * Read the parameters the user has chosen to create new links. Actual link
   * creation is up to the caller.
   *
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/links/LinkPad~LinkCheckParams>}
   */
  LinkPad.prototype.doRead = function () {
    var that = this;
    return Promise.all([that.$getIncomingSlotChooser().read(), that.$getOutgoingSlotChooser().read()]).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        _ref3$ = _slicedToArray(_ref3[0], 1),
        inOrd = _ref3$[0],
        _ref3$2 = _slicedToArray(_ref3[1], 1),
        outOrd = _ref3$2[0];
      if (inOrd && outOrd) {
        var ini = inOrd.lastIndexOf('/'),
          outi = outOrd.lastIndexOf('/'),
          sourceSlotName = outOrd.substr(outi + 1),
          targetSlotName = inOrd.substr(ini + 1);
        return {
          sources: that.$sources,
          targets: that.$targets,
          sourceOrd: that.$sources[0].getOrdInSession(),
          sourceSlot: sourceSlotName,
          targetSlot: targetSlotName
        };
      }
      // Return null if the in or out slot chooser returned null
      return null;
    });
  };

  /**
   * Requests focus on the Incoming and Outgoing SlotChooser widgets.
   */
  LinkPad.prototype.requestFocus = function () {
    var incomingSlotChooser = this.$getIncomingSlotChooser();
    incomingSlotChooser && incomingSlotChooser.scrollToSelectedSlot();
    var outgoingSlotChooser = this.$getOutgoingSlotChooser();
    outgoingSlotChooser && outgoingSlotChooser.scrollToSelectedSlot();
  };

  /**
   * Remove LinkPad class and destroy slot choosers.
   * @returns {Promise}
   */
  LinkPad.prototype.doDestroy = function () {
    var that = this;
    that.jq().removeClass('LinkPad');
    that.getSubscriber().detach();
    return that.getChildWidgets().destroyAll().then(function () {
      that.getSubscriber().unsubscribeAll()["catch"](logError);
      return null;
    });
  };

  /**
   * Show the LinkPad dialog, and if the OK button is clicked, create the link.
   *
   * @param {Object} params
   * @param {Array.<Component>} params.sources array of `baja:Component` objects that are
   * the sources objects to be linked.
   * @param {Array.<Component>} params.targets array of `baja:Component` objects that are
   * the target objects to be linked.
   * @param {object} [params.properties]
   * @param {boolean} [params.readonly]
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/links/LinkPad~AddLinkResults>|null} resolves
   * to the results of adding the links, or null if the user canceled the dialog
   */
  LinkPad.doDialog = function (params) {
    return LinkPad.promptForLinkCheck(params).then(function (linkCheckParams) {
      if (linkCheckParams) {
        //Check, make, add link by passing addLink to checkLinks
        return checkLinks(extend({
          addLink: true
        }, linkCheckParams)).then(function (linkChecks) {
          return extend({
            linkChecks: linkChecks
          }, linkCheckParams);
        });
      }
    });
  };

  /**
   * @param {object} params
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/links/LinkPad~LinkCheckParams>}
   */
  LinkPad.promptForLinkCheck = function (params) {
    var properties = params.properties,
      readonly = params.readonly,
      sources = params.sources,
      targets = params.targets,
      sourceSlot = params.sourceSlot,
      targetSlot = params.targetSlot;
    return feDialogs.showFor({
      value: {
        sources: sources,
        targets: targets,
        sourceSlot: sourceSlot,
        targetSlot: targetSlot
      },
      properties: properties,
      readonly: readonly,
      type: LinkPad,
      formFactor: 'compact'
    });
  };

  /**
   * @typedef {object} module:nmodule/webEditors/rc/wb/links/LinkPad~LinkCheckParams
   * @property {Array.<baja.Component>} sources
   * @property {string} sourceSlot
   * @property {Array.<baja.Component>} targets
   * @property {string} targetSlot
   */

  /**
   * @typedef {object} module:nmodule/webEditors/rc/wb/links/LinkPad~AddLinkResults
   * @property {Array.<baja.Component>} sources
   * @property {string} sourceSlot
   * @property {Array.<baja.Component>} targets
   * @property {string} targetSlot
   * @property {Array.<Array.<baja.LinkCheck>>} linkChecks
   */

  function die(msg) {
    throw new Error(msg);
  }
  return LinkPad;
});
