/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/menu/newComponents
 */
define(['baja!', 'baja!baja:Folder,baja:UnrestrictedFolder,' + 'baja:WsTextBlock,control:BooleanWritable,control:NumericWritable,' + 'control:EnumWritable,control:StringWritable', 'Promise', 'nmodule/webEditors/rc/wb/menu/Separator'], function (baja, types, Promise, Separator) {
  'use strict';

  //TODO: newComponents.bog needs to exist on a jace in some form or another. hooray

  /**
   * Currently a placeholder.
   *
   * In the future, this will asynchronously fetch the contents of
   * `newComponents.bog` from the station, or some analog of it, and resolve it
   * for use in the "new" context menu section.
   *
   * In the meantime, this just spits back a hardcoded set of the components
   * from the default `newComponents.bog`: folders and writable points.
   *
   * @alias module:nmodule/webEditors/rc/wb/menu/newComponents
   * @returns {Promise} promise to be resolved with an object literal:
   * display name to component instance mapping.
   */
  function getNewComponents() {
    return Promise.resolve({
      Folder: baja.$('baja:Folder'),
      IconFolder: baja.$('baja:Folder', {
        icon: baja.$('baja:Icon', 'module://icons/x16/page.png')
      }),
      TextBlock: baja.$('baja:WsTextBlock'),
      Separator: new Separator(),
      BooleanWritable: baja.$('control:BooleanWritable'),
      NumericWritable: baja.$('control:NumericWritable'),
      EnumWritable: baja.$('control:EnumWritable'),
      StringWritable: baja.$('control:StringWritable')
    });
  }
  return getNewComponents;
});
