function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/MgrSheet
 */
define(['lex!webEditors', 'log!nmodule.webEditors.rc.wb.mgr.MgrSheet', 'Promise', 'underscore', 'bajaux/Properties', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/mgr/model/MgrModelCompositeBuilder'], function (lexs, log, Promise, _, Properties, DisplayOnlyEditor, PropertySheet, MgrModelCompositeBuilder) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var logFine = log.fine.bind(log);

  /**
   * @class
   * @alias module:nmodule/webEditors/rc/wb/mgr/MgrSheet
   * @extends module:nmodule/webEditors/rc/wb/PropertySheet
   * @param params
   */
  var MgrSheet = function MgrSheet(params) {
    var builder = params && params.data && params.data.builder;
    if (!(builder instanceof MgrModelCompositeBuilder)) {
      throw new Error('MgrModelCompositeBuilder required');
    }
    this.$baseBuilder = builder;
    PropertySheet.apply(this, arguments);
  };
  MgrSheet.prototype = Object.create(PropertySheet.prototype);
  MgrSheet.prototype.constructor = MgrSheet;

  /**
   * Decorates a `MgrModelCompositeBuilder` to be aware of the Property Sheet
   * in which it lives.
   *
   * In the `MgrModelCompositeBuilder`, each column in the `MgrModel` will
   * define field editors for that column by implementing `getConfigFor`. Here,
   * `MgrSheet` will put that field editor into one row of the Property Sheet.
   *
   * @returns {module:nmodule/webEditors/rc/wb/mgr/model/MgrModelCompositeBuilder}
   */
  MgrSheet.prototype.makeBuilder = function () {
    var that = this;
    var builder = this.$baseBuilder;
    var getConfigFor = builder.getConfigFor;
    builder.getDomFor = function (key) {
      return that.$buildSubEditorDom(key);
    };
    builder.getConfigFor = function (key) {
      return Promise.all([Promise["try"](function () {
        return getConfigFor.call(builder, key);
      })["catch"](function (err) {
        var msg = webEditorsLex.get({
          key: 'mgr.cannotEdit.message',
          args: [key]
        });
        logFine(msg, err);
        return {
          type: DisplayOnlyEditor
        };
      }), that.getOrdBase()]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          config = _ref2[0],
          ordBase = _ref2[1];
        var RowCtor = that.$getRowConstructor();
        return _.extend({}, config, {
          type: RowCtor,
          data: {
            builder: builder,
            key: key,
            displayWidget: config.type
          },
          properties: Properties.extend(that.properties(), {
            ordBase: ordBase,
            allowHyperlink: false
          }, config.properties).toObject()
        });
      });
    };
    return builder;
  };
  return MgrSheet;
});
