function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/HyperlinkCommand
 */

define(['baja!', 'Promise', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, Promise, Command, feDialogs) {
  'use strict';

  /**
   * Standard command that hyperlinks to the supplied ord
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/HyperlinkCommand
   * @extends module:/bajaux/commands/Command
   */
  return /*#__PURE__*/function (_Command) {
    function HyperlinkCommand() {
      var _this;
      _classCallCheck(this, HyperlinkCommand);
      return _this = _callSuper(this, HyperlinkCommand, [{
        module: 'webEditors',
        lex: "commands.mgr.hyperlink",
        enabled: false,
        func: function func() {
          niagara.env.hyperlink(_this.$ord)["catch"](feDialogs.error);
        }
      }]);
    }

    /**
     * Checks to see if the current user has read permission on the supplied ord
     * override if other permissions are required.
     * @private
     * @returns {Promise<boolean>}
     */
    _inherits(HyperlinkCommand, _Command);
    return _createClass(HyperlinkCommand, [{
      key: "$chkPermissions",
      value: function $chkPermissions() {
        if (this.$bypassPermissionCheck) {
          return Promise.resolve(true);
        } else {
          return this.$ord.resolve().then(function () {
            return true;
          })["catch"](function (ignore) {
            return false;
          });
        }
      }

      /**
       * Sets the ord that will be hyperlinked to and the enabled state of the command based on if
       * the user permission for the ord
       * Warning, if the supplied ord is a BQL query, it will be executed twice. Once when permissions
       * are checked and then when the command is invoked, unless you turn off the permission check
       * @param {baja.Ord} ord
       * @returns {Promise}
       */
    }, {
      key: "setOrd",
      value: function setOrd(ord) {
        var _this2 = this;
        this.$ord = ord;
        return this.$chkPermissions().then(function (enable) {
          _this2.setEnabled(enable);
        });
      }

      /**
       * Returns the current set ord for the command
       * @returns {baja.Ord}
       */
    }, {
      key: "getOrd",
      value: function getOrd() {
        return this.$ord;
      }

      /**
       * Creates the hyperlink command
       * Warning, if the supplied ord is a BQL query, it will be executed twice. Once when permissions
       * are checked and then when the command is invoked, unless you turn off the permission check
       * @param {baja.Ord} ord
       * @param {Object} params any additional setup parameters that are required
       * @param {boolean} [params.checkPermissions=true] Turn off the permission check on the supplied ORD by
       * setting this to false
       * @param {String} [params.displayNameFormat] Alternative display name format value
       * @param {String} [params.descriptionFormat] Alternative description format value
       * @param {String} [params.icon] Alternative icon
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/commands/HyperlinkCommand>}
       */
    }], [{
      key: "make",
      value: function make(ord, params) {
        params = params || {};
        var cmd = new HyperlinkCommand();
        cmd.$bypassPermissionCheck = params.checkPermissions === false;
        var _params = params,
          displayNameFormat = _params.displayNameFormat,
          descriptionFormat = _params.descriptionFormat,
          icon = _params.icon;
        return cmd.setOrd(ord).then(function () {
          if (displayNameFormat) {
            cmd.setDisplayNameFormat(displayNameFormat);
          }
          if (descriptionFormat) {
            cmd.setDescriptionFormat(descriptionFormat);
          }
          if (icon) {
            cmd.setIcon(icon);
          }
          return cmd;
        });
      }
    }]);
  }(Command);
});
