/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mixin/MultiSheetCommands
 */
define(['baja!', 'bajaux/events', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/wb/commands/AddSlotCommand', 'nmodule/webEditors/rc/wb/commands/ConfigFacetsCommand', 'nmodule/webEditors/rc/wb/commands/ConfigFlagsCommand', 'nmodule/webEditors/rc/wb/commands/DeleteCommand', 'nmodule/webEditors/rc/wb/commands/RenameCommand', 'nmodule/webEditors/rc/wb/commands/ReorderSlotsCommand', 'nmodule/webEditors/rc/wb/commands/SetDisplayNameCommand', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function (baja, events, $, Promise, _, AddSlotCommand, ConfigFacetsCommand, ConfigFlagsCommand, DeleteCommand, RenameCommand, ReorderSlotsCommand, SetDisplayNameCommand, mixinUtils) {
  'use strict';

  var applyMixin = mixinUtils.applyMixin,
    MODIFY_EVENT = events.MODIFY_EVENT,
    MIXIN_NAME = 'multiSheetCommands';
  function toGetter(obj) {
    return function () {
      return obj;
    };
  }
  function isComponent(comp) {
    return baja.hasType(comp, 'baja:Component');
  }
  function toSlots(subject) {
    if (!subject) {
      return [];
    }
    var slots = _.map(subject, function (ed) {
      return ed.getSlot();
    });
    if (!_.compact(slots).length) {
      return [];
    }
    return slots;
  }
  function toSlotCommand(cmd) {
    var _invoke = cmd.invoke;
    cmd.setSubject = function (subject, updateEnabled) {
      this.$subject = subject;
      this.validateSlots(toSlots(subject), updateEnabled);
    };
    cmd.invoke = function (params) {
      var inSlots = params && params.slots;
      return _invoke.call(this, $.extend({}, params, {
        slots: inSlots || toSlots(this.$subject)
      }));
    };
    return cmd;
  }
  function toSingleSlotCommand(cmd) {
    var slotCmd = toSlotCommand(cmd),
      _setSubject = slotCmd.setSubject;
    slotCmd.setSubject = function (subject, updateEnabled) {
      _setSubject.apply(this, arguments);
      if (subject.length !== 1) {
        this.setEnabled(false);
      }
    };
    return slotCmd;
  }
  function getRow(dom) {
    return dom.closest('.PropertySheetRow').data('widget');
  }

  /**
   * When in offline mode, invoking one of these commands will not enable the
   * Save Bog command. This is because Save Bog updates synchronously (see
   * WbCommands.updateBogCommands), but our JS commands complete asynchronously.
   * To get around this, we make sure that these commands emit a MODIFY_EVENT,
   * to force the Workbench user to click the Save command, thereby enabling
   * Save Bog. (The Save will be a no-op if the command was the only change
   * made, but no harm done.)
   *
   * @param {module:bajaux/commands/Command} cmd
   * @param {module:nmodule/webEditors/rc/wb/MultiSheet} ed
   * @returns {module:bajaux/commands/Command} the updated command
   */
  function toModifier(cmd, ed) {
    var invoke = cmd.invoke;
    cmd.invoke = function () {
      return invoke.apply(cmd, arguments).then(function (result) {
        if (baja.isOffline()) {
          ed.trigger(MODIFY_EVENT);
        }
        return result;
      });
    };
    return cmd;
  }
  function getSelectedKids(ed) {
    var selectedWidgets = _.filter(ed.$getKidRows(), function (kid) {
      return kid.$isSelected();
    });
    if (!selectedWidgets.length) {
      selectedWidgets = [ed];
    }
    return selectedWidgets;
  }
  function addCommands(ed) {
    var group = ed.getCommandGroup(),
      addSlotCommand = new AddSlotCommand(null, {
        undoable: true
      }),
      deleteCommand = toSlotCommand(new DeleteCommand()),
      renameCommand = toSingleSlotCommand(new RenameCommand()),
      configFlagsCommand = toSlotCommand(new ConfigFlagsCommand()),
      configFacetsCommand = toSlotCommand(new ConfigFacetsCommand()),
      setDisplayNameCommand = toSingleSlotCommand(new SetDisplayNameCommand()),
      reorderSlotsCommand = new ReorderSlotsCommand();
    group.add(toModifier(addSlotCommand, ed), toModifier(deleteCommand, ed), toModifier(renameCommand, ed), toModifier(configFlagsCommand, ed), toModifier(configFacetsCommand, ed), toModifier(setDisplayNameCommand, ed), toModifier(reorderSlotsCommand, ed));
    ed.$getAddSlotCommand = toGetter(addSlotCommand);
    ed.$getDeleteCommand = toGetter(deleteCommand);
    ed.$getRenameCommand = toGetter(renameCommand);
    ed.$getConfigFlagsCommand = toGetter(configFlagsCommand);
    ed.$getConfigFacetsCommand = toGetter(configFacetsCommand);
    ed.$getSetDisplayNameCommand = toGetter(setDisplayNameCommand);
    ed.$getReorderSlotsCommand = toGetter(reorderSlotsCommand);
    ed.$updateCommands = function () {
      var value = this.getComplex() || this.value(),
        enabled = this.isEnabled() && !this.isReadonly(),
        subject = getSelectedKids(this);
      addSlotCommand.setComponent(value);
      addSlotCommand.setEnabled(enabled && isComponent(value) && value.getPermissions().hasAdminWrite());
      deleteCommand.setComponent(value);
      deleteCommand.setSubject(subject, enabled);
      renameCommand.setComponent(value);
      renameCommand.setSubject(subject, enabled);
      configFlagsCommand.setComponent(value);
      configFlagsCommand.setSubject(subject, enabled);
      configFacetsCommand.setComponent(value);
      configFacetsCommand.setSubject(subject, enabled);
      setDisplayNameCommand.setComponent(value);
      setDisplayNameCommand.setSubject(subject, enabled);
      reorderSlotsCommand.setComponent(value);
      reorderSlotsCommand.setEnabled(enabled && isComponent(value) && value.getPermissions().hasAdminWrite());
    };
  }
  var exports = {};
  var addMultiSheetCommands = function addMultiSheetCommands(target) {
    if (!applyMixin(target, MIXIN_NAME, exports)) {
      return;
    }
    addCommands(target);
    var _doInitialize = target.doInitialize,
      _doLoad = target.doLoad;
    target.doInitialize = function (dom) {
      var that = this;
      return Promise.resolve(_doInitialize.apply(that, arguments)).then(function () {
        dom.on('click', '.col-name > .editable', function () {
          var cmd = that.$getRenameCommand();
          cmd.invoke({
            slots: [getRow($(this)).getSlot()]
          });
          return false;
        });
        dom.on('click', '.col-flags > .editable', function () {
          var cmd = that.$getConfigFlagsCommand();
          cmd.invoke({
            slots: [getRow($(this)).getSlot()]
          });
          return false;
        });
        dom.on('click', '.col-facets > .editable', function () {
          var cmd = that.$getConfigFacetsCommand();
          cmd.invoke({
            slots: [getRow($(this)).getSlot()]
          });
          return false;
        });
        dom.on('click', '.col-display .editable', function () {
          var cmd = that.$getSetDisplayNameCommand();
          cmd.invoke({
            slots: [getRow($(this)).getSlot()]
          });
          return false;
        });
      });
    };
    target.doLoad = function (value) {
      var that = this;
      return _doLoad.apply(that, arguments).then(function () {
        that.$updateCommands();
        return null; //squelch "promise not returned"
      });
    };
  };
  return addMultiSheetCommands;
});
