/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson.
 */

/*jshint browser: true*/

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/profile/HtmlViewerWidget
 */
define(["bajaux/Widget", "nmodule/webEditors/rc/wb/profile/ServletViewWidget"], function (Widget, ServletViewWidget) {
  "use strict";

  /**
   * A widget that renders an HTML view in an iframe.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/profile/HtmlViewerWidget
   * @extends module:nmodule/webEditors/rc/wb/profile/ServletViewWidget
   */
  var HtmlViewerWidget = function HtmlViewerWidget() {
    ServletViewWidget.apply(this, arguments);
  };
  HtmlViewerWidget.prototype = Object.create(ServletViewWidget.prototype);
  HtmlViewerWidget.prototype.constructor = HtmlViewerWidget;
  HtmlViewerWidget.prototype.resolve = Widget.prototype.resolve;
  HtmlViewerWidget.prototype.doLoad = function (value) {
    return this.$loadFromUri(value.getReadUri());
  };
  return HtmlViewerWidget;
});
