/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 *
 * Intercepts drag and drop events to provide key pieces to make these events
 * work on mobile devices.
 *
 * This includes dealing with the standard context menu found on web.
 *
 * @module nmodule/webEditors/rc/wb/profile/mobileDragAndDrop
 */

define(['jquery'], function ($) {
  'use strict';

  (function fixMobileDragAndDrop() {
    function isWithinBoundingRect(element, x, y) {
      var boundingRect = element.getBoundingClientRect();
      return x >= boundingRect.left && x <= boundingRect.right && y >= boundingRect.top && y <= boundingRect.bottom;
    }
    function hideContextMenu() {
      $('.context-menu-list').trigger('contextmenu:hide');
    }
    var selector = '[draggable=true], a';
    function preventDefault(e) {
      e.preventDefault();
    }
    var abort = function abort() {
      return false;
    };
    var _drag = function drag(event) {
      if (!isWithinBoundingRect(event.target, event.clientX, event.clientY)) {
        hideContextMenu();
        var targetJq = $(event.target);
        targetJq.on('contextmenu', abort);
        targetJq.off('drag', _drag);
      }
    };
    $('body').on('dragstart', selector, function (e) {
      var targetJq = $(e.target);
      targetJq.on('drag', _drag);
    })
    // This prevents iOS from trying to open the link into a new tab on initial drag
    .on('touchmove', 'a', preventDefault).on('dragend', selector, function (e) {
      var targetJq = $(e.target);
      targetJq.off('contextmenu', abort);
      targetJq.off('drag', _drag);
    })
    // This listener enables drop to work in iOS browsers.
    .on('dragover dragenter dragleave dragexit drop', preventDefault);
  })();
});
