function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module nmodule/webEditors/rc/wb/table/model/ComponentTableModel
 */
define(['baja!', 'log!nmodule.webEditors.rc.wb.table.model.ComponentTableModel', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/promiseMux', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/table/model/ComponentSource', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn', 'nmodule/webEditors/rc/wb/table/model/source/ContainerComponentSource'], function (baja, log, Promise, _, promiseMux, typeUtils, ComponentSource, Row, TableModel, PropertyColumn, ContainerComponentSource) {
  'use strict';

  var find = _.find,
    noop = _.noop,
    throttle = _.throttle,
    uniq = _.uniq,
    without = _.without;
  var getSlotNames = typeUtils.getSlotNames,
    isComponent = typeUtils.isComponent;
  var logError = log.severe.bind(log);
  var DEFAULT_CHANGE_EVENT_THROTTLE_MS = 250;

  /**
   * API Status: **Development**
   *
   * Table model where each row in the table represents a `Component`.
   *
   * A `ComponentTableModel` is backed by a `ComponentSource`, which provides
   * the list of `Components` to build into table rows.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/table/model/TableModel
   * @alias module:nmodule/webEditors/rc/wb/table/model/ComponentTableModel
   * @param {Object|baja.Component} params parameters object, or a `Component`
   * if no parameters required.
   * @param {baja.Component|module:nmodule/webEditors/rc/wb/table/model/ComponentSource} params.componentSource
   * the source of components to build into table rows.
   * If a `Component` is given it will just be wrapped in a `ComponentSource`
   * with no parameters.
   * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Column>} params.columns
   * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>|Array.<baja.Component>} [params.rows=params.componentSource.getComponents()] optionally,
   * specify the TableModel's initial set of rows. By default, the rows will be all the components
   * contained within the ComponentSource.
   */
  var ComponentTableModel = function ComponentTableModel(params) {
    var _this = this;
    params = baja.objectify(params, 'componentSource');
    var _params = params,
      columns = _params.columns,
      rows = _params.rows;
    var _params2 = params,
      componentSource = _params2.componentSource,
      rowsChangedEventDelay = _params2.rowsChangedEventDelay;
    if (isComponent(componentSource)) {
      componentSource = new ContainerComponentSource(componentSource);
    }
    if (!(componentSource instanceof ComponentSource)) {
      throw new Error('Component or ComponentSource required');
    }
    if (rowsChangedEventDelay === undefined) {
      rowsChangedEventDelay = DEFAULT_CHANGE_EVENT_THROTTLE_MS;
    }
    this.$componentSource = componentSource;
    this.$rowsChangedEventDelay = rowsChangedEventDelay;
    this.$emitThrottledRowsChangedEvent = promiseMux({
      exec: function exec(rowArguments) {
        var comps = _.map(rowArguments, function (rowArg) {
          return rowArg.comp;
        });
        var allRows = _this.$getRowsUnsafe();
        var existingRows = [];
        // may be assigned from an async MgrModel
        var processRow = _this.$processRowAsync || noop;
        uniq(comps).forEach(function (comp) {
          var existingRow = find(allRows, function (row) {
            return row.getSubject() === comp;
          });
          if (existingRow) {
            existingRows.push(existingRow);
          }
        });
        if (!existingRows.length) {
          return comps;
        }
        return Promise.all(existingRows.map(processRow)).then(function () {
          _this.emit('rowsChanged', existingRows);
          return comps;
        });
      },
      delay: rowsChangedEventDelay
    });
    var rowsReordered = throttle(function () {
      _this.$resortRows();
    }, rowsChangedEventDelay, {
      leading: false
    });
    var addAndRemoveRows = promiseMux({
      /**
       * This throttles the addition / removal of rows in the table.
       *
       * @inner
       * @param {Array.<Object>} updates where each object has an `add` and `remove` array that
       * contain the components to add or remove
       * @returns {Promise} resolves when all rows have been added / removed
       */
      exec: function exec(updates) {
        var allAddComps = [];
        var allRemoveComps = [];

        // Combine all add / remove calls into two arrays.
        updates.forEach(function (update) {
          var _update$add = update.add,
            add = _update$add === void 0 ? [] : _update$add,
            _update$remove = update.remove,
            remove = _update$remove === void 0 ? [] : _update$remove;
          allAddComps.push.apply(allAddComps, _toConsumableArray(add));
          allRemoveComps.push.apply(allRemoveComps, _toConsumableArray(remove));
        });

        // Remove any components that are in both the add and remove arrays.
        var toAddComps = without.apply(void 0, [allAddComps].concat(allRemoveComps));
        var toRemoveComps = without.apply(void 0, [allRemoveComps].concat(allAddComps));

        // Turn the components to remove into the corresponding rows
        var toRemoveRows = [];
        toRemoveComps.forEach(function (comp) {
          var obj = _this.$getRowForSubject(comp);
          if (obj) {
            toRemoveRows.push(obj.row);
          }
        });
        return Promise.all([toAddComps.length && _this.insertRows(toAddComps)["catch"](logError), toRemoveRows.length && _this.removeRows(toRemoveRows)["catch"](logError)]).then(function () {
          return updates; //ensures that the expected number of items in the array are resolved for promiseMux.
        });
      },
      delay: rowsChangedEventDelay,
      coalesce: false
    });
    componentSource.on('added', function (addedComps) {
      return addAndRemoveRows({
        add: addedComps
      });
    }).on('removed', function (removedComps) {
      return addAndRemoveRows({
        remove: removedComps
      });
    }).on('changed', function (comp) {
      _this.$emitThrottledRowsChangedEvent(new RowsChangedArgument(comp));
    }).on('reordered', function () {
      rowsReordered();
    });
    TableModel.call(this, {
      columns: columns,
      rows: rows || componentSource.getComponents()
    });
  };
  ComponentTableModel.prototype = Object.create(TableModel.prototype);
  ComponentTableModel.prototype.constructor = ComponentTableModel;

  /**
   * @private
   * @param {baja.Component} comp
   * @param {String|Type} childType
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/model/ComponentTableModel>} a table
   * model showing one column for every frozen property of the specified type, and one row for every
   * child of the given component matching that type
   */
  ComponentTableModel.$makeBasic = function (comp, childType) {
    return baja.importTypes([childType]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        type = _ref2[0];
      return new ComponentTableModel({
        componentSource: new ContainerComponentSource({
          container: comp,
          filter: [type]
        }),
        columns: getSlotNames(type).map(function (slotName) {
          return new PropertyColumn(slotName, {
            type: type
          });
        })
      });
    });
  };

  /**
   * Find the first row that has the given subject (identity equal).
   *
   * @private
   * @param {*} subject
   * @returns {Object} object with `row` (the actual Row) and `index`
   * properties, or undefined if not found
   */
  ComponentTableModel.prototype.$getRowForSubject = function (subject) {
    var rows = this.getRows();
    for (var i = 0; i < rows.length; i++) {
      if (rows[i].getSubject() === subject) {
        return {
          row: rows[i],
          index: i
        };
      }
    }
  };

  /**
   * Re-sort the rows in this TableModel to match the current ordering of component slots.
   * @private
   */
  ComponentTableModel.prototype.$resortRows = function () {
    var comps = this.getComponentSource().getComponents();
    this.sort(function (row1, row2) {
      var index1 = comps.indexOf(row1.getSubject());
      var index2 = comps.indexOf(row2.getSubject());
      return index1 - index2;
    });
  };

  /**
   * Get the `ComponentSource` backing this table model.
   *
   * @returns {module:nmodule/webEditors/rc/wb/table/model/ComponentSource}
   */
  ComponentTableModel.prototype.getComponentSource = function () {
    return this.$componentSource;
  };

  /**
   * Return the delay (in milliseconds) used by throttled 'rowsChanged' event
   * emission function.
   *
   * @private
   */
  ComponentTableModel.prototype.$getRowsChangedEventDelay = function () {
    return this.$rowsChangedEventDelay;
  };

  /**
   * Ensures that the row's icon is set to the component's icon.
   * @param {baja.Component|module:nmodule/webEditors/rc/wb/table/model/Row} comp
   * @returns {module:nmodule/webEditors/rc/wb/table/model/Row}
   * @since Niagara 4.14
   */
  ComponentTableModel.prototype.makeRow = function (comp) {
    return comp instanceof Row ? comp : new Row(comp, comp.getIcon());
  };

  /*
   * promiseMux coalescing keys on the `toString()` of the object passed in and a Component's toString defaults to just its Type.
   * If available, this class uses the component's handle for the toString so the coalescing from station side changes works properly.
   * @class
   * @inner
   */
  var RowsChangedArgument = /*#__PURE__*/function () {
    function RowsChangedArgument(comp) {
      _classCallCheck(this, RowsChangedArgument);
      this.comp = comp;
    }

    /**
     * @returns {string}
     */
    return _createClass(RowsChangedArgument, [{
      key: "toString",
      value: function toString() {
        var comp = this.comp;
        if (baja.hasType(comp, 'baja:Component')) {
          var handle = comp.getHandle();
          if (handle) {
            return handle;
          }
        }
        return comp.toString();
      }
    }]);
  }();
  return ComponentTableModel;
});
