function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/table/tree/impl/JSONTreeTableModel
 */
define(['Promise', 'underscore', 'nmodule/webEditors/rc/wb/table/tree/TreeTableModel', 'nmodule/webEditors/rc/wb/tree/JSONTreeNode'], function (Promise, _, TreeTableModel, JSONTreeNode) {
  'use strict';

  /**
   * A `TreeTableModel` backed by a simple JSON object or array. Tree nodes
   * are provided as
   * {@link module:nmodule/webEditors/rc/wb/tree/JSONTreeNode JSONTreeNode}s.
   *
   * You should not typically call this constructor directly - as with all
   * `TreeTableModel`s, use the `.make()` method.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/table/tree/impl/JSONTreeTableModel
   * @extends module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel
   */
  var JSONTreeTableModel = function JSONTreeTableModel(params) {
    var data = params && params.data;
    if (!data || _typeof(data) !== 'object') {
      throw new Error('object required');
    }
    TreeTableModel.call(this, _.extend(params, {
      node: new JSONTreeNode(data)
    }));
  };
  JSONTreeTableModel.prototype = Object.create(TreeTableModel.prototype);
  JSONTreeTableModel.prototype.constructor = JSONTreeTableModel;

  /**
   * Create a new `JSONTreeTableModel` instance.
   *
   * @param {Object} params
   * @param {Object|Array} params.data the JSON data value to back this model
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/impl/JSONTreeTableModel>}
   * promise to be resolved with the model instance, or rejected if the JSON
   * data was invalid
   */
  JSONTreeTableModel.make = function (params) {
    return Promise["try"](function () {
      var model = new JSONTreeTableModel(params);
      return model.$expandForNode(model.getRootNode(), 0).then(_.constant(model));
    });
  };
  return JSONTreeTableModel;
});
