function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

define(['baja!', 'lex!bajaui,webEditors', 'dialogs', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/commands/CutCommand', 'nmodule/webEditors/rc/wb/commands/CopyCommand', 'nmodule/webEditors/rc/wb/commands/PasteCommand', 'nmodule/webEditors/rc/wb/commands/PasteSpecialCommand', 'nmodule/webEditors/rc/wb/commands/RenameCommand'], function (baja, lexs, dialogs, Promise, _, feDialogs, compUtils, typeUtils, CutCommand, CopyCommand, PasteCommand, PasteSpecialCommand, RenameCommand) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    bajauiLex = _lexs[0],
    webEditorsLex = _lexs[1];
  var all = _.all,
    isEmpty = _.isEmpty;
  var formatDisplayNames = compUtils.formatDisplayNames,
    getUniqueName = compUtils.getUniqueName;
  var isComponent = typeUtils.isComponent;

  /**
   * API Status: **Private**
   * @exports nmodule/webEditors/rc/wb/transfer/transferUtils
   */
  var exports = {};

  /**
   * Perform the function from this module that corresponds to the given
   * transfer op name.
   *
   * @param {string} transferOp
   * @param {Array} subject
   * @param {Object} [params] additional params to pass to invoke call
   * @returns {Promise}
   */
  exports.doDefault = function (transferOp, subject, params) {
    var func = exports[transferOp];
    if (func) {
      return isEmpty(params) ? func(subject) : func(subject, params);
    }
    return Promise.reject(new Error('transfer op "' + transferOp + '" not supported'));
  };

  /**
   * Decide whether the transfer op is supported based on usual Niagara
   * rules.
   *
   * - `delete`: subject must be all Components on which you have admin write
   *   privileges and those Components must be stored as dynamic properties.
   * - `rename`: subject must be exactly one parented Component on which you
   *   have admin write privileges and those Components must be stored as dynamic properties.
   *   (We do not yet have the ability to do find-replace for renaming multiple Components as we do in Workbench.)
   * - 'copy': subject must be all Components.
   * - 'cut': subject must be all Components on which you have admin write and those Components must be stored as dynamic properties.
   * - 'paste': clipboard must have valid data and subject must have admin write
   *   privileges.
   *
   * @param {string} transferOp
   * @param {Array} subject
   * @returns {boolean}
   */
  exports.isDefaultEnabled = function (transferOp, subject) {
    switch (transferOp) {
      case 'delete':
        return allComponents(subject) && allDynamic(subject) && allAdminWrite(subject);
      case 'duplicate':
        var first = subject[0];
        var parent = isComponent(first) && first.getParent();
        return !!parent && allComponents(subject) && shareSameParent(subject) && hasAdminWrite(parent);
      case 'rename':
        return subject.length === 1 && allComponents(subject) && allDynamic(subject) && allAdminWrite(subject) && !!subject[0].getParent();
      case 'copy':
        return allComponents(subject) && !isWb();
      case 'cut':
        return allComponents(subject) && allDynamic(subject) && allAdminWrite(subject) && !isWb();
      case 'paste':
      case 'pasteSpecial':
        {
          return subject.length === 1 && allAdminWrite(subject) && allComponents(subject) && !isWb();
        }
    }
  };

  //TODO: these will ultimately need to route through an RPC to allow delegation
  //to the component space.

  /**
   * Confirm for deletion, then delete all components in the subject.
   *
   * @param {Array.<baja.Component>} subject
   * @returns {Promise.<module:bajaux/commands/Command~Undoable|undefined>} if
   * undo is possible, resolve an undoable to undelete
   */
  exports["delete"] = function (subject) {
    if (!allComponents(subject)) {
      return Promise.reject(new Error(webEditorsLex.get('commands.delete.error.notComponents')));
    }
    return exports.$confirmDelete().then(function (userConfirmed) {
      if (!userConfirmed) {
        return;
      }
      var deleteOrds = subject.map(function (comp) {
        return String(comp.getNavOrd());
      });
      var names = formatDisplayNames(subject.map(function (comp) {
        return comp.getDisplayName();
      }));
      var undoKey;
      return {
        redo: function redo() {
          return baja.transfer["delete"]({
            deleteOrds: deleteOrds
          }).then(function (k) {
            undoKey = k;
          });
        },
        undo: function undo() {
          return baja.transfer.undo({
            undoKey: undoKey
          });
        },
        undoText: function undoText() {
          return webEditorsLex.get({
            key: 'commands.delete.undoText',
            args: [names]
          });
        },
        redoText: function redoText() {
          return webEditorsLex.get({
            key: 'commands.delete.redoText',
            args: [names]
          });
        }
      };
    });
  };

  /**
   * Prompt the user to confirm deletion
   * @private
   * @returns {Promise.<boolean>}
   */
  exports.$confirmDelete = function () {
    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve) {
      dialogs.showOkCancel({
        title: webEditorsLex.get('commands.delete.confirm.title'),
        text: webEditorsLex.get('commands.delete.confirm.content')
      }).ok(function () {
        return resolve(true);
      }).cancel(function () {
        return resolve(false);
      });
    });
  };

  /**
   * Duplicate all components in the subject. If only one component is being
   * duplicated, the user will be prompted for the new slot name.
   *
   * @param {Array.<baja.Component>} subject
   * @returns {Promise.<module:bajaux/commands/Command~Undoable|undefined>} if
   * undo is possible, resolve an undoable to remove the duplicates
   */
  exports.duplicate = function (subject) {
    var sourceOrds = subject.map(function (comp) {
      return comp.getNavOrd();
    });
    var first = subject[0];
    var target = first.getParent();
    var namesPromise;
    if (subject.length === 1) {
      var defaultSlotName = getUniqueName(target, first.getName());
      namesPromise = exports.$promptForSlotName(baja.SlotPath.unescape(defaultSlotName)).then(function (slotName) {
        return slotName === null ? null : [baja.SlotPath.escape(slotName)];
      });
    } else {
      namesPromise = Promise.resolve();
    }
    return namesPromise.then(function (names) {
      if (names === null) {
        return;
      }
      var redoDisplay = formatDisplayNames(subject.map(function (comp) {
        return comp.getDisplayName();
      }));
      var copyResult;
      return {
        redo: function redo() {
          return baja.transfer.copy({
            sourceOrds: sourceOrds,
            target: target,
            names: names
          }).then(function (result) {
            copyResult = result;
          });
        },
        undo: function undo() {
          return baja.transfer.undo({
            undoKey: copyResult.undoKey
          });
        },
        undoText: function undoText() {
          if (!copyResult) {
            return;
          }
          var undoDisplay = formatDisplayNames(copyResult.insertNames.map(baja.SlotPath.unescape));
          return webEditorsLex.get('commands.duplicate.undoText', undoDisplay);
        },
        redoText: function redoText() {
          return webEditorsLex.get('commands.duplicate.redoText', redoDisplay);
        }
      };
    });
  };

  /**
   * @private
   * @param {string} defaultSlotName default slot name to prompt the user (unescaped)
   * @returns {Promise.<string|null>} user-entered slot name (unescaped), or null if canceled
   */
  exports.$promptForSlotName = function (defaultSlotName) {
    return feDialogs.showFor({
      title: bajauiLex.get('name'),
      value: defaultSlotName,
      formFactor: 'mini'
    });
  };

  /**
   * Prompt for a new slot name and rename the given component.
   * @param {Array.<baja.Component>} subject (must be exactly 1)
   * @returns {Promise.<module:bajaux/commands/Command~Undoable|undefined>}
   */
  exports.rename = function (subject) {
    if (subject.length !== 1) {
      return Promise.reject(new Error(webEditorsLex.get('commands.rename.error.subjectLength')));
    }
    if (!allComponents(subject) || !subject[0].getParent()) {
      return Promise.reject(new Error(webEditorsLex.get('commands.rename.error.parented')));
    }
    var comp = subject[0];
    return new RenameCommand(comp.getParent()).undoable({
      slots: [comp.getPropertyInParent()]
    });
  };

  /**
   * Cut a list of components to the clipboard
   *
   * @param {Array.<baja.Component>} subject
   * @returns {Promise}
   */
  exports.cut = function (subject) {
    if (!allComponents(subject)) {
      return Promise.reject(new Error(webEditorsLex.get('commands.cut.error.notComponents')));
    }
    return new CutCommand(subject).invoke();
  };

  /**
   * Copy a list of components to the clipboard
   *
   * @param {Array.<baja.Component>} subject
   * @returns {Promise}
   */
  exports.copy = function (subject) {
    if (!allComponents(subject)) {
      return Promise.reject(new Error(webEditorsLex.get('commands.copy.error.notComponents')));
    }
    return new CopyCommand(subject).invoke();
  };

  /**
   * Paste components from the clipboard
   *
   * @param {Array} subject
   * @param {object} [params]
   * @returns {Promise}
   */
  exports.paste = function (subject, params) {
    if (subject.length !== 1) {
      return Promise.reject(new Error(webEditorsLex.get('commands.paste.error.subjectLength')));
    }
    return new PasteCommand(subject[0]).invoke(params);
  };

  /**
   * Paste components from the clipboard with additional options.
   *
   * @param {Array} subject
   * @param {object} [params]
   * @returns {Promise}
   */
  exports.pasteSpecial = function (subject, params) {
    if (subject.length !== 1) {
      return Promise.reject(new Error(webEditorsLex.get('commands.paste.error.subjectLength')));
    }
    return new PasteSpecialCommand(subject[0]).invoke(params);
  };
  function hasAdminWrite(comp) {
    return comp.getPermissions().hasAdminWrite();
  }
  function allAdminWrite(comps) {
    return all(comps, hasAdminWrite);
  }
  function isDynamic(comp) {
    var prop = comp.getPropertyInParent();
    return prop && !prop.isFrozen();
  }
  function allDynamic(comps) {
    return all(comps, isDynamic);
  }
  function allComponents(comps) {
    return all(comps, isComponent);
  }
  function shareSameParent(comps) {
    var parent = comps[0].getParent();
    return all(comps.slice(1), function (c) {
      return c.getParent() === parent;
    });
  }
  function isWb() {
    return window.niagara && window.niagara.env && window.niagara.env.type === 'wb';
  }
  return exports;
});
