function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'Promise', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/wb/tree/BajaComplexTreeNode', 'nmodule/webEditors/rc/wb/tree/BajaNavTreeNode', 'nmodule/webEditors/rc/wb/tree/stationTree'], function (baja, Promise, spaceUtils, BajaComplexTreeNode, BajaNavTreeNode, stationTree) {
  'use strict';

  var makeOrd = baja.Ord.make;
  var resolveStation = spaceUtils.resolveStation;
  var SESSION_NODE_NAME = 'local';
  var DEFAULT_ORD = baja.Ord.DEFAULT;

  /**
   * API Status: **Private**
   * @exports nmodule/webEditors/rc/wb/tree/nodeUtils
   */
  var exports = {};

  /**
   * Turns the provided ord into a tree node. This enables getting proper node information for
   * nodes across different spaces in the station.
   *
   * @param {String|Ord} ord the ord we want to determine the node for.
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/tree/TreeNode>}
   */
  exports.ordToTreeNode = function (ord) {
    var lastQuery = findLastMatchingOrdQuery(ord, ['file', 'hierarchy', 'history', 'slot']);
    var lastScheme = lastQuery ? lastQuery.getSchemeName() : "";
    var ordStr = lastQuery && lastScheme !== 'slot' ? lastQuery.toString() : ord.toString();
    switch (lastScheme) {
      case 'file':
        return resolveNodeForTargetSpace(ordStr, stationTree.makeFileSpaceNode);
      case 'hierarchy':
        return resolveNodeForTargetSpace(ordStr, stationTree.makeHierarchySpaceNode);
      case 'history':
        return resolveNodeForTargetSpace(ordStr, stationTree.makeHistorySpaceNode);
      default:
        return makeOrd(ordStr).get().then(function (node) {
          return new BajaComplexTreeNode(node);
        });
    }
  };

  /**
   * Turns the provided `baja:INavNode` into a TreeNode.
   *
   * @param {baja.NavNode} node a `baja:INavNode`
   * @returns {module:nmodule/webEditors/rc/wb/tree/BajaNavTreeNode}
   */
  exports.navNodeToTreeNode = function (node) {
    return new BajaNavTreeNode(node);
  };

  /**
   * Given an ORD, convert it to a path of node names. This is a convenient way to know the path to
   * a node from the top of the station tree. This is useful when doing something such as
   * preselecting a node in a tree.
   *
   * @param {baja.Ord} ord
   * @param {baja.Component} [ordBase]
   * @returns {Promise.<Array.<String>>}
   */
  exports.ordToPath = function (ord, ordBase) {
    var body = SESSION_NODE_NAME;
    if (ord.equals(DEFAULT_ORD)) {
      return Promise.resolve([body]);
    }
    var query = relativize(ord).parse(),
      slotPath = query.get('slot'),
      file = query.get('file'),
      hierarchy = query.get('hierarchy'),
      history = query.get('history'),
      module = query.get('module');
    if (slotPath) {
      return resolveStation(ordBase).then(function (station) {
        return [body, String(relativize(station.getNavOrd()))].concat(splitToPath(slotPath.getBody().substring(1)));
      });
    } else if (hierarchy) {
      body += '/hierarchy' + hierarchy.getBody(); //body starts with '/'
      return Promise.resolve(splitToPath(body).map(baja.SlotPath.unescape));
    } else if (file) {
      //strip leading "^" - it's assumed we're looking in the file obj
      body += '/file/' + file.getBody().replace(/^\^/, '');
    } else if (history) {
      body += '/history' + history.getBody(); //body starts with '/'
      return Promise.resolve(splitToPath(body).map(baja.SlotPath.unescape));
    } else if (module) {
      body += '/module' + module.getBody().substring(1);
    } else {
      body += '/' + ord;
    }
    return Promise.resolve(splitToPath(body));
  };

  /**
   * Determines whether or not the given value is a `baja:INavNode`.
   *
   * @param {baja.Ord|String|baja.Value|null} value
   * @returns {boolean}
   */
  exports.isNavNode = function isNavNode(value) {
    return baja.hasType(value, 'baja:INavNode');
  };

  /**
   * @param {baja.Ord|string} ord
   * @returns {baja.Ord}
   */
  function relativize(ord) {
    return makeOrd(ord).relativizeToSession();
  }

  /**
   * @param str
   * @returns {Array.<String>}
   */
  function splitToPath(str) {
    var path = str.split("/");
    if (path[path.length - 1] === "") {
      path.pop();
    }
    return path;
  }

  /**
   * @param {String|baja.Ord} value the ord to consider
   * @param {Array.<String>} schemes the schemes to look for in the ord such as `file` and `slot`
   * @returns {module:baja/ord/OrdQuery|null} the last matching ord query in the provided ord or
   * null if none of the provided schemes are found
   */
  function findLastMatchingOrdQuery(value, schemes) {
    var ord = makeOrd(value);
    var list = ord.parse();
    for (var i = list.size() - 1; i >= 0; i--) {
      var query = list.get(i);
      var scheme = query.getSchemeName();
      if (schemes.indexOf(scheme) !== -1) {
        return query;
      }
    }
    return null;
  }

  /**
   * @param {String} ordStr
   * @param {function} makeTargetSpace a function that resolves to the station space the provided
   * ord is contained in
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/tree/TreeNode>}
   */
  function resolveNodeForTargetSpace(ordStr, makeTargetSpace) {
    return Promise.all([makeTargetSpace(), exports.ordToPath(ordStr)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        spaceRoot = _ref2[0],
        path = _ref2[1];
      return spaceRoot.getDescendent(path.slice(2, path.length));
    });
  }
  return exports;
});
