/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/TimeFormatEditor
 */
define(['lex!webEditors', 'bajaux/Properties', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/compat/RelevantStringEditor'], function (lexs, Properties, $, Promise, _, RelevantStringEditor) {
  'use strict';

  var webEditorsLex = lexs[0];

  //c&p'ed from wbutil:TimeFormatFE
  var PREDEFINED = ["D-MMM-YY h:mm:ss a z", "D-M-YY h:mm:ss a z", "D-MMM-YY HH:mm:ss z", "D-M-YY HH:mm:ss z", "MMM/D/YY h:mm:ss a z", "M/D/YY h:mm:ss a z", "MMM/D/YY HH:mm:ss z", "M/D/YY HH:mm:ss z", "h:mm:ss a D-MMM-YY z", "h:mm:ss a D-M-YY z", "HH:mm:ss D-MMM-YY z", "HH:mm:ss D-M-YY z", "h:mm:ss a MMM/D/YY z", "h:mm:ss a M/D/YY z", "HH:mm:ss MMM/D/YY z", "HH:mm:ss M/D/YY z"];

  /**
   * Editor for changing a `User`'s desired time format. This simply extends
   * `RelevantStringEditor` and provides a predefined list of time formats to
   * load into the datalist.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/TimeFormatEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/compat/RelevantStringEditor
   */
  var TimeFormatEditor = function TimeFormatEditor(params) {
    params = params || {};
    RelevantStringEditor.call(this, $.extend({}, params, {
      module: 'webEditors',
      keyName: 'TimeFormatEditor',
      properties: _.extend({}, params.properties, {
        datalist: this.$getOptions().join(';'),
        filterWhileTyping: false,
        multiline: false
      })
    }));
  };
  TimeFormatEditor.prototype = Object.create(RelevantStringEditor.prototype);
  TimeFormatEditor.prototype.constructor = TimeFormatEditor;

  /**
   * Get the string to display to the user when the default format
   * (empty string) is selected.
   *
   * @private
   * @returns {String}
   */
  TimeFormatEditor.prototype.$getDefaultDisplay = function () {
    return webEditorsLex.get('TimeFormatEditor.default');
  };

  /**
   * Get all available time format options.
   *
   * @private
   * @returns {Array.<String>}
   */
  TimeFormatEditor.prototype.$getOptions = function () {
    return [this.$getDefaultDisplay()].concat(PREDEFINED);
  };

  /**
   * If an empty string is loaded, show the "default" display. Otherwise show
   * the string.
   *
   * @param {String} value
   * @returns {Promise}
   */
  TimeFormatEditor.prototype.doLoad = function (value) {
    return RelevantStringEditor.prototype.doLoad.call(this, value === '' ? this.$getDefaultDisplay() : value);
  };

  /**
   * If the "default" value is selected, resolve an empty string; otherwise
   * resolve the entered value.
   *
   * @returns {Promise} promise to be resolved with a string
   */
  TimeFormatEditor.prototype.doRead = function () {
    var that = this;
    return Promise.resolve(RelevantStringEditor.prototype.doRead.apply(that, arguments)).then(function (str) {
      return str === that.$getDefaultDisplay() ? '' : str;
    });
  };
  return TimeFormatEditor;
});
