function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/TransferDataManager
 */
define(['baja!', 'underscore', 'Promise', 'bajaux/dragdrop/NavNodeEnvelope', 'nmodule/webEditors/rc/util/SyncedSessionStorage'], function (baja, _, Promise, NavNodeEnvelope, SyncedSessionStorage) {
  'use strict';

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////
  var omit = _.omit;
  var CLIPBOARD_STORAGE_ITEM = 'Clipboard';
  var CLIPBOARD_OP_STORAGE_ITEM = 'Clipboard_op';
  var LINK_MARK_STORAGE_ITEM = 'LinkMark';
  var RELATION_MARK_STORAGE_ITEM = 'RelationMark';
  var getStorage = SyncedSessionStorage.getInstance;
  getStorage(); //kick it off immediately

  var isNavNodes = function isNavNodes(nodes) {
    if (!_.isArray(nodes)) {
      return false;
    }
    var _iterator = _createForOfIteratorHelper(nodes),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var node = _step.value;
        if (!baja.hasType(node, 'baja:INavNode')) {
          return false;
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
    return true;
  };
  var saveNodesToStorage = function saveNodesToStorage(itemName, nodes) {
    var envelope = new NavNodeEnvelope(nodes);
    return Promise.all([getStorage(), envelope.toJson()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        storage = _ref2[0],
        jsonObject = _ref2[1];
      var jsonString = JSON.stringify(jsonObject);
      storage.setItem(itemName, jsonString);
      return jsonString;
    });
  };
  var getNodesFromStorage = function getNodesFromStorage(itemName) {
    return getStorage().then(function (storage) {
      var jsonString = storage.getItem(itemName),
        nodes = jsonString ? JSON.parse(jsonString) : [],
        node = nodes[0];
      if (node && node.typeSpec) {
        var envelope = new NavNodeEnvelope(nodes);
        return envelope.toValues();
      }
      return [];
    });
  };

  /**
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/TransferDataManager
   */
  var TransferDataManager = /*#__PURE__*/function () {
    function TransferDataManager() {
      _classCallCheck(this, TransferDataManager);
    }
    return _createClass(TransferDataManager, [{
      key: "getLinkMark",
      value:
      /**
       * @returns {Promise.<Array.<baja.NavNode>>} resolves to an array of `NavNode`s
       */
      function getLinkMark() {
        return getNodesFromStorage(LINK_MARK_STORAGE_ITEM);
      }

      /**
       * @param {Array.<baja.NavNode>} nodes - Array of baja:INavNode
       * @returns {Promise<String>} Promise that will be resolved to the JSON stringify
       *    of the NavNodes.
       */
    }, {
      key: "setLinkMark",
      value: function setLinkMark(nodes) {
        if (!nodes) {
          return saveNodesToStorage(LINK_MARK_STORAGE_ITEM, []);
        }
        if (!isNavNodes(nodes)) {
          return Promise.reject(new Error('TransferDataManager.setLinkMark ' + 'requires an array of NavNodes'));
        }
        return saveNodesToStorage(LINK_MARK_STORAGE_ITEM, nodes);
      }

      /**
       * @param {Array.<baja.NavNode>} nodes
       * @returns {Promise<String>} Promise that will be resolved to the JSON stringify
       *    of the NavNodes.
       */
    }, {
      key: "setRelationMark",
      value: function setRelationMark(nodes) {
        if (!nodes) {
          return saveNodesToStorage(RELATION_MARK_STORAGE_ITEM, []);
        }
        if (!isNavNodes(nodes)) {
          return Promise.reject(new Error('TransferDataManager.setRelationMark requires an array of NavNodes'));
        }
        return saveNodesToStorage(RELATION_MARK_STORAGE_ITEM, nodes);
      }

      /**
       * @returns {Promise.<Array.<baja.NavNode>>}
       */
    }, {
      key: "getRelationMark",
      value: function getRelationMark() {
        return getNodesFromStorage(RELATION_MARK_STORAGE_ITEM);
      }

      /**
       * Save a list of nav nodes to the clipboard for a move
       *
       * @param {Array.<baja.NavNode>} nodes array of baja:INavNode
       * @returns {Promise}
       */
    }, {
      key: "cut",
      value: function cut(nodes) {
        return this.$transferToClipboard(nodes, 'move');
      }

      /**
       * Save a list of nav nodes to the clipboard for a copy
       *
       * @param {Array.<baja.NavNode>} nodes array of baja:INavNode
       * @returns {Promise}
       */
    }, {
      key: "copy",
      value: function copy(nodes) {
        return this.$transferToClipboard(nodes, 'copy');
      }

      /**
       * Save a list of nav nodes to the clipboard for a clipboard operation.
       *
       * @private
       * @param {Array.<baja.NavNode>} nodes array of baja:INavNode
       * @param {String} [clipboardOp='copy']
       * @return {Promise}
       */
    }, {
      key: "$transferToClipboard",
      value: function $transferToClipboard(nodes) {
        var clipboardOp = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'copy';
        // Reject if nodes is not an array of baja:INavNodes.
        if (!_.isArray(nodes) || !baja.hasType(nodes[0], 'baja:INavNode')) {
          return Promise.reject(new Error('TransferDataManager requires an array of NavNodes'));
        }

        // Convert array of INavNodes to a JSON string using NavNodeEnvelope
        var envelope = new NavNodeEnvelope(nodes);
        return Promise.all([getStorage(), envelope.toJson()]).then(function (args) {
          var storage = args[0],
            json = JSON.stringify(args[1]);
          storage.setItem(CLIPBOARD_STORAGE_ITEM, json);
          storage.setItem(CLIPBOARD_OP_STORAGE_ITEM, clipboardOp);
          return json;
        });
      }

      /**
       * Pastes the components currently on the clipboard into the target
       * component.
       *
       * @param {baja.Component} target
       * @param {object} [params]
       * @param {PasteMark} [params.mark] configures what we're
       * copying or moving - if not given, what's currently on the clipboard
       * will be used
       * @param {string[]} [params.names]
       * @param {boolean} [params.keepLinks]
       * @param {boolean} [params.keepRelations]
       * @param {number} [params.numCopies]
       * @param {string} [params.origin]
       * @see baja.transfer.copy
       * @returns {Promise.<{ undoKey: string, insertNames: string[] }>}
       */
    }, {
      key: "paste",
      value: function paste(target, params) {
        return Promise.all([params && params.mark || this.$getPasteMark(), getStorage()]).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            mark = _ref4[0],
            storage = _ref4[1];
          if (!mark) {
            return;
          }
          var nodes = mark.nodes,
            op = mark.op;
          var sourceOrds = nodes.map(function (node) {
            return node.ord;
          });
          var pasteConfig = Object.assign({
            sourceOrds: sourceOrds,
            target: target
          }, omit(params, 'mark'));
          if (op === 'copy') {
            return baja.transfer.copy(pasteConfig);
          } else if (op === 'move') {
            return baja.transfer.move(pasteConfig).then(function (result) {
              storage.removeItem(CLIPBOARD_STORAGE_ITEM);
              storage.removeItem(CLIPBOARD_OP_STORAGE_ITEM);
              return result;
            });
          } else {
            throw new Error("Unknown Clipboard Op: " + op);
          }
        });
      }

      /**
       * @private
       * @returns {Promise.<PasteMark|null>}
       */
    }, {
      key: "$getPasteMark",
      value: function $getPasteMark() {
        return Promise.all([this.getClipboard(), this.getClipboardOp()]).then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 2),
            clipboard = _ref6[0],
            op = _ref6[1];
          if (!clipboard) {
            return null;
          }
          var nodes = JSON.parse(clipboard);
          return {
            nodes: nodes,
            op: op
          };
        });
      }

      /**
       * @returns {Promise.<string>} That resolves to the current copy mark
       */
    }, {
      key: "getClipboard",
      value: function getClipboard() {
        return getStorage().then(function (storage) {
          return storage.getItem(CLIPBOARD_STORAGE_ITEM);
        });
      }

      /**
       * @returns {Promise.<String>} That resolves to the current clipboard op.
       */
    }, {
      key: "getClipboardOp",
      value: function getClipboardOp() {
        return getStorage().then(function (storage) {
          return storage.getItem(CLIPBOARD_OP_STORAGE_ITEM);
        });
      }
    }]);
  }();
  TransferDataManager.INSTANCE = new TransferDataManager();
  return {
    getInstance: function getInstance() {
      return TransferDataManager.INSTANCE;
    }
  };

  /**
   * @private
   * @typedef {object} PasteMark
   * @property {Array.<{ name: string, displayName: string, ord: string }>} nodes the
   * objects to copy or move (typically set on clipboard by a previous Copy or Cut command)
   * @property {string} op `copy` or `move`
   */
});
