function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 *
 * @module nmodule/webEditors/rc/wb/util/category/ShowOrHideAllCategoriesCommand
 */

define(['baja!', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/PropertySheet', 'bajaux/commands/Command'], function (baja, $, Promise, _, feDialogs, PropertySheet, Command) {
  'use strict';

  /**
   * This command will show/hide all the categories.
   * @class
   * @extends module:bajaux/commands/Command
   * @since Niagara 4.14
   * @alias module:nmodule/webEditors/rc/wb/util/category/ShowOrHideAllCategoriesCommand
   * @param {module:nmodule/webEditors/rc/wb/table/Table} table target table of this command.
   * @param {Object} [params] the Object Literal for the method's arguments.
   * @param {String} [params.module='wbutil'] the module to look up the command's lexicon entry.
   * @param {String} [params.show] to show/hide all the category columns.
   */
  var ShowOrHideAllCategoriesCommand = /*#__PURE__*/function (_Command) {
    function ShowOrHideAllCategoriesCommand(table) {
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$module = _ref.module,
        module = _ref$module === void 0 ? 'wbutil' : _ref$module,
        _ref$lex = _ref.lex,
        lex = _ref$lex === void 0 ? 'category.showAll' : _ref$lex,
        _ref$show = _ref.show,
        show = _ref$show === void 0 ? false : _ref$show;
      _classCallCheck(this, ShowOrHideAllCategoriesCommand);
      return _callSuper(this, ShowOrHideAllCategoriesCommand, [{
        module: module,
        lex: lex,
        enabled: true,
        func: function func() {
          return ShowOrHideAllCategoriesCommand.showOrHideCategories(table, show);
        }
      }]);
    }

    /**
     * @param {module:nmodule/webEditors/rc/wb/table/Table} table
     * @param {boolean} [show]
     * @returns {Promise}
     */
    _inherits(ShowOrHideAllCategoriesCommand, _Command);
    return _createClass(ShowOrHideAllCategoriesCommand, null, [{
      key: "showOrHideCategories",
      value: function showOrHideCategories(table, show) {
        var model = table.getModel(),
          columns = model.getColumns();
        columns.forEach(function (column) {
          if (column.isHidable()) {
            column.setUnseen(!show);
          }
        });
      }
    }]);
  }(Command);
  return ShowOrHideAllCategoriesCommand;
});
