function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/batchJob/rc/BatchJobLogFileUxView
 */

define(['bajaux/spandrel', 'nmodule/batchJob/rc/util/batchJobUtils', 'nmodule/batchJob/rc/util/LogContentWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'css!nmodule/batchJob/rc/batchJob'], function (spandrel, batchJobUtils, LogContentWidget, fe, feDialogs) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-BatchJobLogFileUxView'
      }
    };
  };
  function resolveConstructor(value, config) {
    return fe.params(Object.assign({
      value: value
    }, config)).then(function (params) {
      return params.getWidgetConstructor();
    });
  }

  /**
   * @class
   * @alias module:nmodule/batchJob/rc/BatchJobLogFileUxView
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_spandrel) {
    function BatchJobLogFileUxView(params) {
      _classCallCheck(this, BatchJobLogFileUxView);
      return _callSuper(this, BatchJobLogFileUxView, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @private
     * @returns {module:bajaux/Widget}
     */
    _inherits(BatchJobLogFileUxView, _spandrel);
    return _createClass(BatchJobLogFileUxView, [{
      key: "$getJobView",
      value: function $getJobView() {
        return this.queryWidget(0);
      }

      /**
       * @private
       * @param {module:bajaux/Widget} jobView 
       * @param {String} logContents the string encoded log contents
       */
    }, {
      key: "$updateViewLogCommand",
      value: function $updateViewLogCommand(jobView, logContents) {
        var viewLogCmd = jobView.$getViewLogCommand();
        // override command handler
        viewLogCmd.$func = function () {
          return feDialogs.showFor({
            value: logContents,
            type: LogContentWidget,
            buttons: ['ok']
          });
        };
      }
    }]);
  }(spandrel(function (jobLogFile, _ref) {
    var self = _ref.self,
      formFactor = _ref.formFactor,
      properties = _ref.properties;
    var _properties$getConfig = properties.getConfig,
      getConfig = _properties$getConfig === void 0 ? function () {
        return {
          formFactor: formFactor
        };
      } : _properties$getConfig;
    var job, logContents;
    return batchJobUtils.getJobDetailsFromLog(jobLogFile).then(function (jobLogComp) {
      job = jobLogComp.get('job');
      logContents = jobLogComp.get('logContents');
      // Get the Ux agent registered on this type and load it
      return resolveConstructor(job, getConfig());
    }).then(function (Ctor) {
      return [{
        dom: '<div></div>',
        type: Ctor,
        value: job,
        hooks: {
          postLoad: function postLoad(widget) {
            return self.$updateViewLogCommand(widget, logContents);
          }
        }
      }];
    });
  }));
});
