function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _toArray(r) { return _arrayWithHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/**
 * API Status: **Private**
 * @module nmodule/batchJob/rc/baja/ValueList
 */
define(['baja!', 'lex!batchJob', 'Promise', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, lexs, Promise, typeUtils) {
  'use strict';

  var _baja$SlotPath = baja.SlotPath,
    escape = _baja$SlotPath.escape,
    unescape = _baja$SlotPath.unescape;
  var isSimple = typeUtils.isSimple,
    allSameType = typeUtils.allSameType;
  var batchJobLex = lexs[0];

  /**
   * A 'batchJob:ValueList' stores similar typed encodable BValues.
   *
   * @since Niagara 4.14
   * @class
   * @extends baja.Simple
   * @alias  module:nmodule/batchJob/rc/baja/ValueList
   */
  var ValueList = /*#__PURE__*/function (_baja$Simple) {
    /**
     * Use BValueList.make(...) method to create an object.
     * Constructor should be considered private.
     *
     * @param {Array.<baja.Simple>} valueArray Array of values, zero size will set encoded value to be "".
     * @throws {Error} error will be thrown for type mismatch in the valueArray
     */
    function ValueList(valueArray) {
      var _this;
      _classCallCheck(this, ValueList);
      _this = _callSuper(this, ValueList);
      //All values have to be baja:Simple (and) all values should be of the same type.
      if (!!valueArray.find(function (value) {
        return !isSimple(value);
      }) || !allSameType(valueArray)) {
        throw new Error(batchJobLex.get('valueList.invalidTypeSpec.message'));
      }
      if (valueArray.length) {
        _this.$typeSpec = valueArray[0].getType().getTypeSpec();
      } else {
        //Default instantiation to baja:Value when array is empty.
        _this.$typeSpec = 'baja:Value';
      }
      _this.$valueArray = valueArray;
      return _this;
    }

    /**
     * Makes a ValueList object for any given input.
     *
     * @param {baja.Simple|baja.Simple[]} input
     * @returns {module:nmodule/batchJob/rc/baja/ValueList} a `batchJob:ValueList` instance
     *
     * @example
     * //baja.Simple or baja.Simple[] can be the input.
     * make(baja.Integer.make(30));
     * make([baja.Integer.make(10), baja.Integer.make(20)]);
     * make('MockStation1');
     * make(['MockStation1','MockStation2]);
     */
    _inherits(ValueList, _baja$Simple);
    return _createClass(ValueList, [{
      key: "make",
      value: function make() {
        return ValueList.make.apply(ValueList, arguments);
      }

      /**
       * Escapes the input string, it does not escape .\-+()&`'@[]\n
       *
       * @private
       * @param {String} string
       * @returns {String} escaped string
       */
    }, {
      key: "$escapeString",
      value: function $escapeString(string) {
        var unescapedCharacters = /[.\-+()&`'@[\]]/;
        var anyCharacterInclNewLine = /[\W\w]/g;
        var PREFIX = 'A';
        return string.replace(anyCharacterInclNewLine, function (eachChar) {
          if (unescapedCharacters.exec(eachChar)) {
            return eachChar;
          }
          return escape(PREFIX + eachChar).substring(1);
        });
      }

      /**
       * Encodes the value string
       *
       * @returns {String} encoded valueString will be returned
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        var _this2 = this;
        if (this.$valueArray.length > 0) {
          return [this.$typeSpec].concat(_toConsumableArray(this.$valueArray.map(function (val) {
            return _this2.$escapeString(val.encodeToString());
          }))).join('\n');
        }
        return '';
      }

      /**
       * Decodes the input String into a ValueList Object
       *
       * @param {String} input
       * @returns {module:nmodule/batchJob/rc/baja/ValueList}
       * @throws {Error} throws an error if unsupported baja type is encountered in the input string
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(input) {
        //Throw error if input string is undefined or null.
        if (input === null || input === undefined) {
          throw new Error(batchJobLex.get('valueList.invalidDecodeInput.message'));
        }
        if (input.length > 0) {
          //first argument will be a type like 'baja:String',
          //second argument will be an array of values.
          var _input$split = input.split('\n'),
            _input$split2 = _toArray(_input$split),
            type = _input$split2[0],
            valueArray = _input$split2.slice(1);
          if (baja.lt(type)) {
            valueArray = valueArray.map(function (value) {
              return baja.$(type, unescape(value));
            });
          } else {
            throw new Error(batchJobLex.get('valueList.invalidTypeSpec.message'));
          }
          return new ValueList(valueArray);
        }
        //DEFAULT is returned for an empty input.
        return DEFAULT;
      }

      /**
       * @param {string} string
       * @returns {Promise.<module:nmodule/batchJob/rc/baja/ValueList>}
       */
    }, {
      key: "decodeAsync",
      value: function decodeAsync(string) {
        if (!string) {
          return Promise.resolve(DEFAULT);
        }
        var _string$split = string.split('\n'),
          _string$split2 = _slicedToArray(_string$split, 1),
          type = _string$split2[0];
        return baja.importTypes([type]).then(function () {
          return DEFAULT.decodeFromString(string);
        });
      }

      /**
       * Adds a value to the input ValueList
       *
       * @param {module:nmodule/batchJob/rc/baja/ValueList} valueList
       * @param {baja.Simple} value
       * @returns {module:nmodule/batchJob/rc/baja/ValueList}
       */
    }, {
      key: "getValue",
      value:
      /**
       * @param {Number} index
       * @returns {baja.Simple}
       */
      function getValue(index) {
        return this.$valueArray[index];
      }

      /**
       * @returns {String}
       */
    }, {
      key: "getItemType",
      value: function getItemType() {
        return this.$typeSpec;
      }

      /**
       * @returns {Number}
       */
    }, {
      key: "size",
      value: function size() {
        return this.$valueArray.length;
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "isNull",
      value: function isNull() {
        return this.$valueArray.length === 0;
      }

      /**
       * @returns {Array<baja.Simple>}
       */
    }, {
      key: "toArray",
      value: function toArray() {
        return this.$valueArray;
      }

      /**
       * @param {baja.Simple} value
       * @returns {boolean}
       */
    }, {
      key: "contains",
      value: function contains(value) {
        return !!this.$valueArray.find(function (val) {
          return val.equivalent(value);
        });
      }

      /**
       * @returns {module:nmodule/batchJob/rc/baja/ValueList}
       */
    }], [{
      key: "make",
      value: function make(input) {
        //arguments are checked for null and undefined
        if (input === null || input === undefined) {
          throw new Error(batchJobLex.get('valueList.invalidArguments.message'));
        }
        return new ValueList(Array.isArray(input) ? _toConsumableArray(input) : [input]);
      }
    }, {
      key: "add",
      value: function add(valueList, value) {
        if (!valueList || !valueList.$valueArray) {
          throw new Error(batchJobLex.get('valueList.invalidAddRemoveInput.message'));
        }
        var valueArray = [].concat(_toConsumableArray(valueList.$valueArray), [value]);
        return new ValueList(valueArray);
      }

      /**
       * Removes a value at specific index
       *
       * @param {module:nmodule/batchJob/rc/baja/ValueList} valueList
       * @param {Number} index
       * @returns {module:nmodule/batchJob/rc/baja/ValueList}
       */
    }, {
      key: "remove",
      value: function remove(valueList, index) {
        if (!valueList || !valueList.$valueArray) {
          throw new Error(batchJobLex.get('valueList.invalidAddRemoveInput.message'));
        }
        valueList.$valueArray.splice(index, 1);
        return new ValueList(valueList.$valueArray);
      }
    }, {
      key: "DEFAULT",
      get: function get() {
        return DEFAULT;
      }
    }]);
  }(baja.Simple);
  var DEFAULT = new ValueList([]);
  return ValueList;
});
