function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */
/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/batchJob/rc/util/JobSummariesTable
 */

define(['baja!', 'jquery', 'lex!batchJob', 'Promise', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/spandrel', 'bajaux/util/CommandButtonGroup', 'nmodule/batchJob/rc/util/batchJobUtils', 'nmodule/batchJob/rc/util/LogContentWidget', 'nmodule/batchJob/rc/util/TimestampPropertyColumn', 'nmodule/batchJob/rc/wb/commands/CancelJobCommand', 'nmodule/batchJob/rc/wb/commands/DisposeJobCommand', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/job/commands/ViewLogCommand', 'nmodule/webEditors/rc/wb/job/jobSupport', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/Table'], function (baja, $, lexs, Promise, Command, CommandGroup, spandrel, CommandButtonGroup, batchJobUtils, LogContentWidget, TimestampPropertyColumn, CancelJobCommand, DisposeJobCommand, fe, feDialogs, ViewLogCommand, jobSupport, IconColumn, PropertyColumn, Row, TableModel, Table) {
  'use strict';

  var stateToIconOrd = jobSupport.stateToIconOrd;
  var _lexs = _slicedToArray(lexs, 1),
    BATCH_JOB_LEX = _lexs[0];
  var getDisplayTz = batchJobUtils.getDisplayTz,
    hyperlinkToJob = batchJobUtils.hyperlinkToJob,
    getJobOrd = batchJobUtils.getJobOrd,
    getJobDetailsFromLog = batchJobUtils.getJobDetailsFromLog;

  /**
   * 
   * @param {baja.Value} job the batchJob:IBatchJobSummary instance
   * @param {String} icon
   * @returns {module:nmodule/batchJob/rc/wb/commands/DisposeJobCommand} 
   */
  var makeDisposeJobCommand = function makeDisposeJobCommand(job, icon) {
    var disposeJobCmd = new DisposeJobCommand(job);
    if (icon) {
      disposeJobCmd.setIcon(icon);
    }
    var disposeFunc = disposeJobCmd.getFunction();
    disposeJobCmd.setFunction(function () {
      return disposeFunc().then(function () {
        return niagara.env.reload();
      });
    });
    return disposeJobCmd;
  };

  /**
   * @class
   * @inner
   * @private
   * @extends module:bajaux/commands/Command
   */
  var ViewJobSummaryCommand = /*#__PURE__*/function (_Command) {
    /**
     * 
     * @param {baja.Value} summaryObj a BIBatchJobSummary object
     * @param {baja.Object} base a base to resolve job lookups,
     * @param {String} [icon] command icon
     */
    function ViewJobSummaryCommand(summaryObj, base, icon) {
      var _this;
      _classCallCheck(this, ViewJobSummaryCommand);
      var commandParams = {
        func: function func() {
          return Promise.all([baja.rpc({
            typeSpec: "batchJob:BatchJobRpcUtil",
            method: "getJobOrd",
            args: [_this.$summary.getTimestamp().encodeToString(), String(base.getNavOrd())]
          }), getDisplayTz()]).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              ordStr = _ref2[0],
              timezone = _ref2[1];
            return hyperlinkToJob(ordStr, timezone);
          });
        }
      };
      if (icon) {
        commandParams['icon'] = icon;
        commandParams['displayName'] = "%lexicon(batchJob:BatchJobList.openCommand.displayName)%";
      } else {
        commandParams['module'] = 'batchJob';
        commandParams['lex'] = 'BatchJobList.openCommand';
      }
      _this = _callSuper(this, ViewJobSummaryCommand, [commandParams]);
      _this.$summary = summaryObj;
      _this.$base = base;
      return _this;
    }
    _inherits(ViewJobSummaryCommand, _Command);
    return _createClass(ViewJobSummaryCommand, [{
      key: "setSummary",
      value: function setSummary(summaryObj) {
        this.$summary = summaryObj;
      }
    }]);
  }(Command);
  /**
   * @class
   * @inner
   * @private
   * @extends module:nmodule/webEditors/rc/wb/table/model/columns/IconColumn
   */
  var JobStateIconColumn = /*#__PURE__*/function (_IconColumn) {
    function JobStateIconColumn() {
      _classCallCheck(this, JobStateIconColumn);
      return _callSuper(this, JobStateIconColumn, arguments);
    }
    _inherits(JobStateIconColumn, _IconColumn);
    return _createClass(JobStateIconColumn, [{
      key: "getValueFor",
      value: function getValueFor(row) {
        return baja.Icon.make([row.getIcon()]);
      }
    }]);
  }(IconColumn);
  /**
   * @class
   * @inner
   * @private
   * @extends module:nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn
   */
  var JobStateWithCommandsColumn = /*#__PURE__*/function (_PropertyColumn) {
    /**
     * 
     * @param {String} name 
     * @param {object} params 
     * @param {baja.Value} base 
     */
    function JobStateWithCommandsColumn(name, params, base) {
      var _this2;
      _classCallCheck(this, JobStateWithCommandsColumn);
      _this2 = _callSuper(this, JobStateWithCommandsColumn, [name, params]);
      _this2.$base = base;
      return _this2;
    }
    _inherits(JobStateWithCommandsColumn, _PropertyColumn);
    return _createClass(JobStateWithCommandsColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        var _this3 = this;
        return _superPropGet(JobStateWithCommandsColumn, "buildCell", this, 3)(arguments).then(function () {
          return fe.buildFor({
            dom: $('<div class="-t-JobSummariesTable-JobState-commands"/>').appendTo(dom),
            type: CommandButtonGroup,
            value: new CommandGroup({
              commands: [new ViewJobSummaryCommand(row.getSubject(), _this3.$base, 'module://icons/x16/doubleArrowRight.png'), makeDisposeJobCommand(row.getSubject(), 'module://icons/x16/close.png')]
            }),
            properties: {
              toolbar: true
            }
          });
        });
      }
    }]);
  }(PropertyColumn);
  /**
   * @class
   * @inner
   * @private
   * @extends module:nmodule/batchJob/rc/wb/commands/CancelJobCommand
   */
  var CancelCommand = /*#__PURE__*/function (_CancelJobCommand) {
    function CancelCommand() {
      _classCallCheck(this, CancelCommand);
      return _callSuper(this, CancelCommand, arguments);
    }
    _inherits(CancelCommand, _CancelJobCommand);
    return _createClass(CancelCommand, [{
      key: "$isCancellable",
      value:
      /**
       * @private
       * @returns {boolean} 
       */
      function $isCancellable() {
        var jobs = this.getJobs();
        return jobs.every(function (job) {
          if (job) {
            var jobState = job.get('jobState');
            return jobState.getTag() === 'running' || jobState.getTag() === 'unknown';
          }
          return false;
        });
      }
    }]);
  }(CancelJobCommand);
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-JobSummariesTable'
      }
    };
  };
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;
  function disableCommands(jobTableCmdGrp) {
    jobTableCmdGrp.getChildren().forEach(function (cmd) {
      return cmd.setEnabled(false);
    });
  }

  /**
   * A utility widget that lists batch jobs with a set of useful commands.
   * Prototype Job List {@link module:nmodule/batchJob/rc/PrototypeJobList} and 
   * Niagara Job List {@link module:nmodule/provisioningNiagara/rc/wb/NiagaraNetworkUxJobList} 
   * are examples of views that use this widget.
   * A "base" property when set will be used for looking up a job. 
   * For example, BBatchJobRpcUtil.getJobOrd RPC will look up for a mounted job or a file against this base.
   * 
   * @class
   * @alias module:nmodule/batchJob/rc/util/JobSummariesTable
   * @extends module:bajaux:Widget
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_spandrel) {
    function JobSummariesTable(params) {
      _classCallCheck(this, JobSummariesTable);
      return _callSuper(this, JobSummariesTable, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @private
     * @returns {baja.Component|null} 
     */
    _inherits(JobSummariesTable, _spandrel);
    return _createClass(JobSummariesTable, [{
      key: "$getBase",
      value: function $getBase() {
        return this.properties().getValue('base');
      }

      /**
       * @private
       * @param {Array.<baja.Value>} summaries the batchJob:IBatchJobSummary objects
       * @param {baja.Value} base a base to resolve job lookups against
       * @returns {module:nmodule/webEditors/rc/wb/table/model/TableModel} 
       */
    }, {
      key: "$makeTableModel",
      value: function $makeTableModel(summaries, base) {
        return new TableModel({
          columns: [new JobStateIconColumn(), new TimestampPropertyColumn('timestamp', {
            displayName: BATCH_JOB_LEX.get('BatchJobList.col.jobStart')
          }), new TimestampPropertyColumn('endTime', {
            displayName: BATCH_JOB_LEX.get('BatchJobList.col.jobEnd')
          }), new PropertyColumn('submitUser', {
            displayName: BATCH_JOB_LEX.get('BatchJobList.col.user')
          }), new JobStateWithCommandsColumn('jobState', {
            displayName: ' '
          }, base)],
          rows: summaries.map(function (summaryComp) {
            var summary = summaryComp.get("summary");
            var row = new Row(summary, stateToIconOrd(summary.getJobState()));
            row.data('jobOrd', summaryComp.get('jobOrd'));
            return row;
          })
        });
      }

      /**
       * @private
       * @return {module:bajaux/commands/CommandGroup}
       */
    }, {
      key: "$makeCommandGroup",
      value: function $makeCommandGroup() {
        this.$viewLogCommand = new ViewLogCommand();
        this.$viewLogCommandOrgFunc = this.$viewLogCommand.$func;
        this.$cancelCommand = this.$makeCancelJobCommand();
        this.$disposeCommand = this.$makeDisposeJobCommand();
        this.$jobSummaryCommand = new ViewJobSummaryCommand(null, this.$getBase());
        this.$jobTableCommandGroup = new CommandGroup({
          commands: [this.$viewLogCommand, this.$jobSummaryCommand, this.$cancelCommand, this.$disposeCommand]
        });

        // Disable all commands by default
        disableCommands(this.$jobTableCommandGroup);
        return this.$jobTableCommandGroup;
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command} 
       */
    }, {
      key: "$getViewLogCommand",
      value: function $getViewLogCommand() {
        return this.$viewLogCommand;
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command} 
       */
    }, {
      key: "$getJobSummaryCommand",
      value: function $getJobSummaryCommand() {
        return this.$jobSummaryCommand;
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command} 
       */
    }, {
      key: "$getCancelCommand",
      value: function $getCancelCommand() {
        return this.$cancelCommand;
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command} 
       */
    }, {
      key: "$getDisposeCommand",
      value: function $getDisposeCommand() {
        return this.$disposeCommand;
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/Table}
       */
    }, {
      key: "$getJobTable",
      value: function $getJobTable() {
        return this.queryWidget('jobContainer/jobTable/*');
      }

      /**
       * @private
       * @param {baja.Value} job the batchJob:IBatchJobSummary instance
       * @param {String} icon
       * @returns {module:nmodule/batchJob/rc/wb/commands/DisposeJobCommand}
       */
    }, {
      key: "$makeDisposeJobCommand",
      value: function $makeDisposeJobCommand(job, icon) {
        var disposeJobCmd = new DisposeJobCommand(job);
        if (icon) {
          disposeJobCmd.setIcon(icon);
          disposeJobCmd.setDisplayNameFormat("");
        }
        var disposeFunc = disposeJobCmd.getFunction();
        disposeJobCmd.setFunction(function () {
          return disposeFunc().then(function () {
            return niagara.env.reload();
          });
        });
        return disposeJobCmd;
      }

      /**
       * @private
       * @returns {module:nmodule/batchJob/rc/util/JobSummariesTable~CancelCommand}
       */
    }, {
      key: "$makeCancelJobCommand",
      value: function $makeCancelJobCommand() {
        var cancelJobCmd = new CancelCommand();
        var cancelFunc = cancelJobCmd.getFunction();
        cancelJobCmd.setFunction(function () {
          return cancelFunc().then(function () {
            return niagara.env.reload();
          });
        });
        return cancelJobCmd;
      }

      /**
       * @private
       * @returns {module:bajaux/commands/CommandGroup}
       */
    }, {
      key: "$getJobCommandGroup",
      value: function $getJobCommandGroup() {
        return this.$jobTableCommandGroup;
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table 
       */
    }, {
      key: "$prepareCommands",
      value: function $prepareCommands(table) {
        var selectedRows = table.getSelectedRows();
        if (selectedRows.length === 0) {
          disableCommands(this.$jobTableCommandGroup);
        } else if (selectedRows.length === 1) {
          var _selectedRows = _slicedToArray(selectedRows, 1),
            selectedRow = _selectedRows[0],
            summary = selectedRow.getSubject();
          var jobSummaryCmd = this.$getJobSummaryCommand();
          jobSummaryCmd.setEnabled(true);
          jobSummaryCmd.setSummary(selectedRow.getSubject());
          this.$prepareDisposeCommand(selectedRows.map(function (row) {
            return row.getSubject();
          }));
          this.$prepareCancelJobCommand([summary]);
          return this.$prepareViewLogCommand(summary, selectedRow.data('jobOrd'));
        } else {
          this.$disableSingleSelectionCommands();
          this.$prepareDisposeCommand(selectedRows.map(function (row) {
            return row.getSubject();
          }));
          this.$prepareCancelJobCommand(selectedRows.map(function (row) {
            return row.getSubject();
          }));
        }
      }

      /**
       * @private
       * @param {baja.Value} summary,
       * @param {baja.Ord} jobOrd
       * @returns {Promise}
       */
    }, {
      key: "$prepareViewLogCommand",
      value: function $prepareViewLogCommand(summary, jobOrd) {
        var _this4 = this;
        var viewLogCmd = this.$getViewLogCommand();
        viewLogCmd.setEnabled(true);
        if (jobOrd !== baja.Ord.DEFAULT) {
          viewLogCmd.$func = this.$viewLogCommandOrgFunc;
          return jobOrd.get().then(function (job) {
            return viewLogCmd.setJobs(job);
          });
        } else {
          // override command handler
          viewLogCmd.$func = function () {
            return getJobOrd(summary.getTimestamp(), _this4.$getBase().getNavOrd()).then(function (jobOrd) {
              return getJobDetailsFromLog(jobOrd).then(function (jobDetailsComp) {
                return feDialogs.showFor({
                  value: jobDetailsComp.get('logContents'),
                  type: LogContentWidget,
                  buttons: ['ok']
                });
              });
            });
          };
        }
      }

      /**
       * @private
       * @param {Array.<baja.Complex>} jobs may be an array of `baja:Job` or `batchJob:IBatchJobSummary` objects
       */
    }, {
      key: "$prepareCancelJobCommand",
      value: function $prepareCancelJobCommand(jobs) {
        var cancelJobCmd = this.$getCancelCommand();
        cancelJobCmd.setJobs(jobs);
        cancelJobCmd.setEnabled(cancelJobCmd.$isCancellable());
      }

      /**
       * @private
       * @param {Array.<baja.Complex>} jobs 
       */
    }, {
      key: "$prepareDisposeCommand",
      value: function $prepareDisposeCommand(jobs) {
        var disposeCmd = this.$getDisposeCommand();
        disposeCmd.setJobs(jobs);
        disposeCmd.setEnabled(disposeCmd.$isComplete());
      }

      /**
       * @private
       */
    }, {
      key: "$disableSingleSelectionCommands",
      value: function $disableSingleSelectionCommands() {
        this.$getJobSummaryCommand().setEnabled(false);
        this.$getViewLogCommand().setEnabled(false);
      }
    }]);
  }(spandrel(function (summaries, _ref3) {
    var properties = _ref3.properties,
      self = _ref3.self;
    var _ref4 = properties || {},
      base = _ref4.base;
    return spandrel.jsx("div", {
      className: "-t-JobSummariesTable-container",
      spandrelKey: "jobContainer"
    }, spandrel.jsx("div", {
      className: "-t-JobSummariesTable-table",
      spandrelKey: "jobTable"
    }, spandrel.jsx(Table, {
      value: self.$makeTableModel(summaries, base),
      on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function (e, table) {
        self.$prepareCommands(table);
      }),
      properties: {
        fixedHeaders: true
      }
    })), spandrel.jsx("div", {
      className: "-t-JobSummariesTable-commands",
      spandrelKey: "jobCommands"
    }, spandrel.jsx(CommandButtonGroup, {
      value: self.$makeCommandGroup()
    })));
  }));
});
