function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/*global niagara: false */

/**
 * API Status: **Private**
 * @module nmodule/batchJob/rc/wb/columns/HyperlinkToLogFileColumn
 */
define(['baja!', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'bajaux/Widget', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, Command, CommandButton, Widget, Promise, fe, Column) {
  'use strict';

  var dateTimeUtil = require('bajaScript/baja/obj/dateTimeUtil');

  /**
   * @param {baja.Complex} state
   * @returns {Boolean} true if step is complete
   */
  function isDeviceJobComplete(state) {
    var stateTag = state.getTag();
    return stateTag === "success" || stateTag === "canceled" || stateTag === "failed";
  }
  /**
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/batchJob/rc/wb/columns/HyperlinkToLogFileColumn
   * @extends module:nmodule/webEditors/rc/wb/table/model/Column
   */
  var HyperlinkToLogFileColumn = /*#__PURE__*/function (_Column) {
    function HyperlinkToLogFileColumn() {
      _classCallCheck(this, HyperlinkToLogFileColumn);
      return _callSuper(this, HyperlinkToLogFileColumn, arguments);
    }
    _inherits(HyperlinkToLogFileColumn, _Column);
    return _createClass(HyperlinkToLogFileColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        var _this = this;
        var deviceStepDetails = row.getSubject();
        return fe.buildFor({
          type: CommandButton,
          value: new OpenCommand({
            deviceStepDetails: deviceStepDetails,
            func: function func() {
              if (isDeviceJobComplete(deviceStepDetails.getState())) {
                return Promise.all([_this.$getFileOrd(deviceStepDetails), _this.$getTimeZoneId(deviceStepDetails)]).then(function (_ref) {
                  var _ref2 = _slicedToArray(_ref, 2),
                    ord = _ref2[0],
                    timeZoneId = _ref2[1];
                  return niagara.env.hyperlink(baja.Ord.make({
                    base: ord,
                    child: new baja.ViewQuery('batchJob:BatchJobStepLogFileUxView?displayTzId=' + timeZoneId)
                  }));
                });
              } else {
                var navOrd = deviceStepDetails.getNavOrd();
                var navOrdStr = navOrd.relativizeToSession();
                navOrd = baja.Ord.make({
                  base: 'station:',
                  child: navOrdStr
                });
                return niagara.env.hyperlink(navOrd);
              }
            }
          }),
          dom: dom
        });
      }

      /**
       * Destroy the CommandButton that was created for this cell.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @param {JQuery} dom
       * @returns {Promise}
       */
    }, {
      key: "destroyCell",
      value: function destroyCell(row, dom) {
        return Widget["in"](dom).destroy();
      }

      /**
       * @private
       * @param {baja.Complex} details can be a mounted or unmounted step details component.
       * Trying to view step details when there is no corresponding network job in the Job Service,
       * will read the job details from the log file (*.bjl) and construct an umounted `details` component.
       * @returns {Promise.<string>} Promise resolved with log file ord.
       */
    }, {
      key: "$getFileOrd",
      value: function $getFileOrd(details) {
        var navOrdStr = String(details.getNavOrd()),
          startTimeStr = details.getStartTime().encodeToString(),
          stepTypeSpecStr = String(details.getStepType());
        return baja.rpc({
          typeSpec: "batchJob:BatchJobRpcUtil",
          method: "getLogFile",
          args: [navOrdStr, startTimeStr, stepTypeSpecStr]
        });
      }

      /**
       * @private
       * @param {baja.Component} stepDetails 
       * @returns {String}
       */
    }, {
      key: "$getTimeZoneId",
      value: function $getTimeZoneId(stepDetails) {
        // TODO Get the timezone from the step start time
        return dateTimeUtil.getCurrentTimeZoneId();
      }
    }]);
  }(Column);
  /**
   * Command to open the log file.
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   * @param {Object} params An Object Literal.
   * @param {Function} [params.func] The function this command will execute to open the log file.
   */
  var OpenCommand = /*#__PURE__*/function (_Command) {
    function OpenCommand(_ref3) {
      var func = _ref3.func;
      _classCallCheck(this, OpenCommand);
      return _callSuper(this, OpenCommand, [{
        func: func,
        module: 'batchJob',
        lex: 'DeviceNetworkJobView.openCommand',
        enabled: true
      }]);
    }
    _inherits(OpenCommand, _Command);
    return _createClass(OpenCommand);
  }(Command);
  return HyperlinkToLogFileColumn;
});
