function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Divya D
 */

/* eslint-env browser */
/**
 * Widget for selecting a camera from a dropdown.
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/playback/CameraChooserWidget
 */

define(['baja!', 'jquery', 'lex!videoDriver', 'bajaux/Widget', 'dialogs', 'Promise', 'bajaux/events', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/videoDriver/rc/rpc/rpc', 'underscore', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, $, lex, Widget, dialogs, Promise, events, Command, BaseWidget, fe, OrderedMapEditor, rpc, _) {
  'use strict';

  var _lex = _slicedToArray(lex, 1),
    videoDriverslex = _lex[0];
  var cameraChooserLabel = videoDriverslex.getSafe('VideoPlaybackView.CameraChooser.label'),
    cameraChooserDefaultSelection = _.unescape(videoDriverslex.getSafe("VideoPlaybackChooserView.ChooseCameraBox.ChooseCamera")),
    MODIFY_EVENT = events.MODIFY_EVENT;
  var tpl = function tpl() {
    return "\n    <span class=\"title\">".concat(cameraChooserLabel, "</span>\n    <span class=\"ux-select dropdown\"></span>\n  ");
  };
  /**
   * Trims the given ord down to only the slot part.
   * @param {string} ordString
   * @returns {string}
   */
  var trimToSlotPath = function trimToSlotPath(ordString) {
    return ordString === "null" ? "null" : /slot:\/(.)*/.exec(ordString)[0];
  };

  /**
   * Generates a display name with the ord included.
   * @param {string} displayName
   * @param {string} ord
   * @returns {string}
   */
  var getDisplayNameWithOrd = function getDisplayNameWithOrd(displayName, ord) {
    return "".concat(displayName, " (").concat(ord, ")");
  };
  var CameraChooserWidget = /*#__PURE__*/function (_BaseWidget) {
    /**
     *
     * @param {Object} [params]
     * @param {CameraChooserWidget~onCameraChanged} [params.properties.onCameraChanged]
     */
    function CameraChooserWidget(params) {
      var _this;
      _classCallCheck(this, CameraChooserWidget);
      _this = _callSuper(this, CameraChooserWidget, arguments);
      _this.$getCameraArray = _.once(rpc.getAllCameras);
      return _this;
    }

    /**
     * Called when the camera selection changes.
     * @callback CameraChooserWidget~onCameraChanged
     * @param {string} selectedOrd
     */

    /**
     * Sets up the dom for the camera chooser and registers events.
     * @param dom
     * @returns {Promise}
     */
    _inherits(CameraChooserWidget, _BaseWidget);
    return _createClass(CameraChooserWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.html(tpl()).addClass('CameraChooserWidget');
        return this.$getLengthPatternMap().then(function (patternMap) {
          return fe.buildFor({
            dom: _this2.$getDropDown(),
            value: patternMap,
            loadParams: {
              selectedValue: "0"
            },
            type: OrderedMapEditor
          });
        }).then(function () {
          _this2.$getDropDown().on(MODIFY_EVENT, function (event, dropdownWidget) {
            var selectedValue = dropdownWidget.getSelectedValue();
            return Promise.resolve(_this2.value().setMostRecentCameraViewed(baja.Ord.make(selectedValue))).then(function () {
              var cameraChanged = _this2.properties().getValue('onCameraChanged');
              if (cameraChanged) {
                cameraChanged(selectedValue);
              }
            });
          });
        });
      }

      /**
       * Loads the value into the CameraChooser
       *
       * @param {baja.Component} value a `videoDriver:VideoPlaybackChooser` instance
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this3 = this;
        if (!baja.hasType(value, "videoDriver:VideoPlaybackChooser")) {
          return Promise.reject(new Error('CameraChooser must be loaded with videoDriver:VideoPlaybackChooser'));
        }
        var mostRecentCameraOrdString = trimToSlotPath(value.getMostRecentCameraViewed().toString());
        this.$excludedCameraOrds = _.map(value.getExcludeCameras().getOrds(), function (ord) {
          return trimToSlotPath(ord.toString());
        });
        return this.$getLengthPatternMap(mostRecentCameraOrdString).then(function (cameraMap) {
          return _this3.$getDropDownWidget().load(cameraMap, {
            selectedValue: mostRecentCameraOrdString
          });
        });
      }

      /**
       * Loads the ord string specified into the dropdown selection.
       * @private
       * @param {string} ordString
       */
    }, {
      key: "$loadOrdIntoDropdown",
      value: function $loadOrdIntoDropdown(ordString) {
        var dropDownWidget = this.$getDropDownWidget();
        var trimmedOrd = trimToSlotPath(ordString);
        dropDownWidget.setSelectedValue(trimmedOrd);
      }

      /**
       * Destroys the editor and all children of the editor.
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('CameraChooserWidget');
        return Promise.all([this.getChildWidgets().destroyAll()]);
      }

      /**
       * @param  {String} name The name of the Property that's changed.
       * @param  {*} value The new Property value.
       * @return {Promise}
       */
    }, {
      key: "doChanged",
      value: function doChanged(name, value) {
        return Promise.resolve();
      }

      /**
       * Gets the jquery element of the dropdown.
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getDropDown",
      value: function $getDropDown() {
        return this.jq().find('.dropdown');
      }

      /**
       * Gets the widget of the dropdown
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
       */
    }, {
      key: "$getDropDownWidget",
      value: function $getDropDownWidget() {
        return Widget["in"](this.$getDropDown());
      }

      /**
       * This method builds an ordered map for camera keys/values and returns it.
       * Adds a default value to map based upon selectedCameraOrd.
       * @private
       * @param {string} [selectedCameraOrd]
       * @returns {Promise.<module:baja/sys/structures/OrderedMap>}
       */
    }, {
      key: "$getLengthPatternMap",
      value: function $getLengthPatternMap(selectedCameraOrd) {
        var _this4 = this;
        var trimmedCameraOrd = selectedCameraOrd && trimToSlotPath(selectedCameraOrd);
        var map = new baja.OrderedMap();
        return this.$getCameraArray().then(function (cameraArray) {
          map.put(cameraChooserDefaultSelection, baja.Ord.DEFAULT.toString());
          var i,
            isSelectedOrdInList = false,
            duplicateDisplayNames = [];
          for (i = 0; i < cameraArray.length; i++) {
            var split = cameraArray[i].split("|");
            var displayName = baja.SlotPath.unescape(split[0]);
            var slotPath = baja.SlotPath.unescape(split[1]);
            if (!_.contains(_this4.$excludedCameraOrds, slotPath)) {
              var isDisplayNameDuplicate = map.contains(displayName) || duplicateDisplayNames.contains(displayName);
              if (isDisplayNameDuplicate) {
                var originalDisplayName = displayName;
                duplicateDisplayNames.push(originalDisplayName);
                var existingMapValue = map.get(originalDisplayName);
                if (existingMapValue) {
                  map.rename(originalDisplayName, getDisplayNameWithOrd(originalDisplayName, existingMapValue));
                }
                displayName = getDisplayNameWithOrd(displayName, slotPath);
              }
              map.put(displayName, slotPath);
              if (slotPath === trimmedCameraOrd) {
                isSelectedOrdInList = true;
              }
            }
          }
          if (trimmedCameraOrd && trimmedCameraOrd !== baja.Ord.DEFAULT.toString() && isSelectedOrdInList) {
            map.remove(cameraChooserDefaultSelection);
          }
          return map;
        });
      }
    }]);
  }(BaseWidget);
  return CameraChooserWidget;
});
