function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/playback/VideoEventChooser
 */
define(['baja!', 'lex!videoDriver', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'jquery', 'Promise', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/util/ListSelection'], function (baja, lexs, Widget, Command, CommandButton, $, Promise, rpc, BaseWidget, fe, feDialogs, Table, TableModel, JsonObjectPropertyColumn, Row, ListSelection) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    videoDriverLex = _lexs[0],
    sortTimeIndexRow = function sortTimeIndexRow(firstRow, secondRow) {
      var firstTime = firstRow.getSubject().timeIndex.valueOf(),
        secondTime = secondRow.getSubject().timeIndex.valueOf();
      if (firstTime > secondTime) {
        return 1;
      } else if (secondTime < firstTime) {
        return -1;
      } else {
        return 0;
      }
    },
    getLoadingMessage = function getLoadingMessage(leadingText) {
      return leadingText + " - " + videoDriverLex.getSafe('VideoEventChooser.LoadingEvents');
    };
  var CAMERA_ORD_PROPERTY = 'cameraOrd',
    EVENTS_PER_PAGE = 20;
  var tpl = function tpl(pageText) {
    return "\n    <div class=\"browseEventsContainer\">\n      <div class=\"browseEventsButtons\">\n        <span class=\"pageText\">".concat(pageText, "</span>\n        <button type=\"button\" class=\"ux-btn pageUpCommand\"/>\n        <button type=\"button\" class=\"ux-btn pageDownCommand\"/>\n        <button type=\"button\" class=\"ux-btn homePageCommand\"/>\n        <button type=\"button\" class=\"ux-btn findEventsCommand\" />   \n      </div>\n      <div class=\"videoEventChooserTableContainer\">\n        <table class='ux-table videoEventChooserTable'></table>\n        <div class=\"loadingMessage\">Test</div>\n      </div>\n    </div>\n  ");
  };

  /**
   * A widget for selecting video playback events based upon timestamp and description
   */
  var VideoEventChooser = /*#__PURE__*/function (_BaseWidget) {
    function VideoEventChooser() {
      var _this;
      _classCallCheck(this, VideoEventChooser);
      _this = _callSuper(this, VideoEventChooser, arguments);
      _this.validators().add(function (value) {
        if (!value) {
          var errorMsg = videoDriverLex.getSafe("VideoPlaybackView.BrowseEventsCommand.NoSelectionError");
          return Promise.reject(new Error(errorMsg));
        }
      });
      return _this;
    }

    /**
     * Initializes the dom with all elements.
     * @param {jQuery} dom
     * @returns {Promise}
     */
    _inherits(VideoEventChooser, _BaseWidget);
    return _createClass(VideoEventChooser, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        var pageText = videoDriverLex.getSafe("VideoEventChooser.Page");
        dom.html(tpl(pageText));
        return Promise.all([this.$buildCommands(dom), this.$buildEventChooserTable(dom)]).then(function () {
          _this2.$addDoubleClickRowEvent(dom);
          return _this2.$pageHome();
        });
      }

      /**
       * Adds the event handler for double click to notify quick select.
       */
    }, {
      key: "$addDoubleClickRowEvent",
      value: function $addDoubleClickRowEvent() {
        var _this3 = this;
        this.$getEventChooserTable().jq().on('dblclick', 'tr', function () {
          return _this3.read().then(function (value) {
            _this3.jq().trigger(BaseWidget.VALUE_READY_EVENT, [value]);
          });
        });
      }

      /**
       * Creates the command buttons that go in the top bar of the chooser.
       * @private
       * @param {jQuery} dom
       * @returns {Promise<Array.<module:bajaux/util/CommandButton>>}
       */
    }, {
      key: "$buildCommands",
      value: function $buildCommands(dom) {
        var _this4 = this;
        return Promise.all([fe.buildFor({
          type: CommandButton,
          dom: $('.pageUpCommand', dom),
          value: new Command({
            module: 'videoDriver',
            lex: 'VideoEventChooser.PageUp',
            func: function func() {
              return _this4.$pageUp();
            }
          })
        }), fe.buildFor({
          type: CommandButton,
          dom: $('.pageDownCommand', dom),
          value: new Command({
            module: 'videoDriver',
            lex: 'VideoEventChooser.PageDown',
            func: function func() {
              return _this4.$pageDown();
            }
          })
        }), fe.buildFor({
          type: CommandButton,
          dom: $('.homePageCommand', dom),
          value: new Command({
            module: 'videoDriver',
            lex: 'VideoEventChooser.PageHome',
            func: function func() {
              return _this4.$pageHome();
            }
          })
        }), fe.buildFor({
          type: CommandButton,
          dom: $('.findEventsCommand', dom),
          value: new Command({
            module: 'videoDriver',
            lex: 'VideoEventChooser.SeekMore',
            func: function func() {
              return _this4.$findEvents();
            }
          })
        })]);
      }

      /**
       * Creates the table element that the events will be displayed in.
       * @private
       * @param {jQuery} dom
       * @returns {Promise}
       */
    }, {
      key: "$buildEventChooserTable",
      value: function $buildEventChooserTable(dom) {
        var _this5 = this;
        var rows = [],
          selection = new ListSelection();
        selection.setExclusiveFilter(function () {
          return true;
        });
        selection.on('changed', function () {
          _this5.setModified(true);
        });
        return fe.buildFor({
          dom: $(".videoEventChooserTable", dom),
          type: Table,
          value: this.$buildTableModel(rows),
          selection: selection
        });
      }

      /**
       * Fetches the data from the RPC and loads it into the table.
       * @private
       * @param {baja.AbsTime} timeIndex
       * @param {number} fetchVector
       * @param {string} loadingMessage
       * @returns {Promise}
       */
    }, {
      key: "$fetchDataIntoTable",
      value: function $fetchDataIntoTable(timeIndex, fetchVector, loadingMessage) {
        var _this6 = this;
        var loadingMessageElement = this.jq().find(".loadingMessage");
        loadingMessageElement.text(loadingMessage);
        loadingMessageElement.show();
        var cameraOrd = this.properties().getValue(CAMERA_ORD_PROPERTY);
        return rpc.getCameraPlaybackEvents(cameraOrd, timeIndex, fetchVector).then(function (cameraArray) {
          var rows = [];
          for (var i = 0; i < cameraArray.length; i++) {
            rows.push(new Row(cameraArray[i]));
          }
          return _this6.$updateTableRows(rows);
        }).then(function () {
          loadingMessageElement.hide();
        })["catch"](function (error) {
          loadingMessageElement.show();
          var displayedMessage = videoDriverLex.getSafe("VideoEventChooser.LoadingEventsError", [error.message]);
          loadingMessageElement.text(displayedMessage);
        });
      }

      /**
       * Reads the time value of the selected element in the table.
       * @returns {null|baja.AbsTime} the time selected
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var selectedRows = this.$getEventChooserTable().getSelectedRows();
        if (selectedRows.length > 0) {
          return selectedRows[0].getSubject()["timeIndex"];
        }
        return null;
      }
    }, {
      key: "doLoad",
      value: function doLoad(value) {}

      /**
       * Updates the table data to display the events after the most recent event
       * in the table including that event.
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$pageUp",
      value: function $pageUp() {
        var rows = this.$getEventChooserTable().getModel().getRows(),
          pageUpMessage = videoDriverLex.getSafe('VideoEventChooser.PageUp.label'),
          loadingMessage = getLoadingMessage(pageUpMessage);
        rows.sort(sortTimeIndexRow);
        var time = rows.length > 0 ? rows[0].getSubject().timeIndex : baja.AbsTime.now();
        return this.$fetchDataIntoTable(time, EVENTS_PER_PAGE, loadingMessage);
      }

      /**
       * Updates the table data to display the events before the least recent event
       * in the table including that event.
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$pageDown",
      value: function $pageDown() {
        var rows = this.$getEventChooserTable().getModel().getRows(),
          pageDownMessage = videoDriverLex.getSafe('VideoEventChooser.PageDown.label'),
          loadingMessage = getLoadingMessage(pageDownMessage);
        rows.sort(sortTimeIndexRow);
        var time = rows.length > 0 ? rows[rows.length - 1].getSubject().timeIndex : baja.AbsTime.now();
        return this.$fetchDataIntoTable(time, -EVENTS_PER_PAGE, loadingMessage);
      }

      /**
       * Updates the table data to display the home page
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$pageHome",
      value: function $pageHome() {
        var pageHomeMessage = videoDriverLex.getSafe('VideoEventChooser.PageHome.label'),
          loadingMessage = getLoadingMessage(pageHomeMessage);
        return this.$fetchDataIntoTable(baja.AbsTime.now(), EVENTS_PER_PAGE, loadingMessage);
      }

      /**
       * Opens the find events dialog for selecting an AbsTime
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$findEvents",
      value: function $findEvents() {
        var _this7 = this;
        return feDialogs.showFor({
          title: videoDriverLex.get('VideoPlaybackView.PlayFromTimeIndex.title'),
          value: baja.AbsTime.now(),
          formFactor: 'mini'
        }).then(function (eventsStartingAt) {
          if (eventsStartingAt) {
            var findEventsText = videoDriverLex.getSafe('VideoEventChooser.SeekMore.label'),
              loadingMessage = getLoadingMessage(findEventsText);
            return _this7.$fetchDataIntoTable(eventsStartingAt, EVENTS_PER_PAGE, loadingMessage);
          }
        });
      }

      /**
       * Using the given rows, build a new table model for the data with the
       * rows sorted in descending order.
       * @private
       * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
       * @returns {module:nmodule/webEditors/rc/wb/table/model/TableModel}
       */
    }, {
      key: "$buildTableModel",
      value: function $buildTableModel(rows) {
        var timeIndexColumn = new JsonObjectPropertyColumn('timeIndex', {
            displayName: videoDriverLex.getSafe('EventChooserTable.Header.TimeIndex')
          }),
          descriptionColumn = new JsonObjectPropertyColumn('description', {
            displayName: videoDriverLex.getSafe('EventChooserTable.Header.MsgText')
          }),
          columns = [timeIndexColumn, descriptionColumn];
        timeIndexColumn.buildCell = function (row, dom) {
          var time = this.getValueFor(row);
          return time.toString({
            showSeconds: true,
            showMilliseconds: true
          }).then(function (datetimeString) {
            dom.text(datetimeString);
          });
        };
        timeIndexColumn.setSortable(false);
        descriptionColumn.setSortable(false);
        rows.sort(sortTimeIndexRow);
        rows.reverse();
        return new TableModel({
          rows: rows,
          columns: columns
        });
      }

      /**
       * Replaces the data in the table with the given rows.
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} rows
       * @returns {Promise}
       */
    }, {
      key: "$updateTableRows",
      value: function $updateTableRows(rows) {
        return this.$getEventChooserTable().load(this.$buildTableModel(rows));
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getPageUpCommandButton",
      value: function $getPageUpCommandButton() {
        return Widget["in"](this.jq().find('.pageUpCommand'));
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getPageDownCommandButton",
      value: function $getPageDownCommandButton() {
        return Widget["in"](this.jq().find('.pageDownCommand'));
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getHomePageCommandButton",
      value: function $getHomePageCommandButton() {
        return Widget["in"](this.jq().find('.homePageCommand'));
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getFindEventsCommandButton",
      value: function $getFindEventsCommandButton() {
        return Widget["in"](this.jq().find('.findEventsCommand'));
      }

      /**
       * @returns {module:baja/coll/Table}
       */
    }, {
      key: "$getEventChooserTable",
      value: function $getEventChooserTable() {
        return Widget["in"](this.jq().find('.videoEventChooserTable'));
      }
    }]);
  }(BaseWidget);
  return VideoEventChooser;
});
