function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Bhavani Patnam
 */
/* eslint-env browser */
/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/utils/CameraPresetsWidget
 */

define(['baja!', 'jquery', 'lex!videoDriver', 'bajaux/Widget', 'dialogs', 'Promise', 'bajaux/events', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/DynamicEnumEditor', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/videoDriver/rc/rpc/rpc', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, $, lexs, Widget, dialogs, Promise, events, Command, CommandButton, BaseWidget, fe, OrderedMapEditor, DynamicEnumEditor, htmlUtils, rpc) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    lex = _lexs[0];
  var cameraPresetChooserLabel = lex.getSafe('VideoLiveView.CameraPresets.select.label');
  var tpl = function tpl() {
    return "\n    <span class=\"title\">".concat(cameraPresetChooserLabel, "</span>\n    <span class=\"ux-select dropdown\"></span>\n    <button type=\"button\" class=\"goCommand\"/>\n    <button type=\"button\" class=\"storeCommand\"></button>\n  ");
  };

  /**
   * CameraPresetsWidget view for the video playback feature to view on the UI
   *
   * API Status: **Private**
   * @class
   * @alias module:nmodule/videoDriver/rc/fe/utils/CameraPresetsWidgets
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @param {Object} params
   */
  var CameraPresetsWidget = /*#__PURE__*/function (_BaseWidget) {
    function CameraPresetsWidget() {
      _classCallCheck(this, CameraPresetsWidget);
      return _callSuper(this, CameraPresetsWidget, arguments);
    }
    _inherits(CameraPresetsWidget, _BaseWidget);
    return _createClass(CameraPresetsWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;
        dom.html(tpl()).addClass('CameraPresetsWidget');
        return Promise.all([fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: this.$getGoElement(),
          value: this.$getGoCommand()
        }), fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: this.$getStoreElement(),
          value: this.$getStoreCommand()
        })]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            goCommandButton = _ref2[0],
            storeCommandButton = _ref2[1];
          _this.$goCommandButton = goCommandButton;
          _this.$storeCommandButton = storeCommandButton;
        });
      }

      /**
       * @param {baja.Component} value
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        return this.$initializeView(value);
      }

      /**
       * Called by the Widget.setEnabled.
       * @param enabled
       * @returns {Promise}
       */
    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        if (enabled) {
          this.jq().show();
        } else {
          this.jq().hide();
        }
        return this.getChildWidgets().setAllEnabled(enabled);
      }

      /**
       * @private
       * @param {baja.Component} value
       * @returns {Promise}
       */
    }, {
      key: "$initializeView",
      value: function $initializeView(value) {
        var _this2 = this;
        return rpc.getCameraInfo(value.getNavOrd()).then(function (cameraInfo) {
          return Promise.all([cameraInfo, baja.DynamicEnum.DEFAULT.decodeAsync(cameraInfo.presetEnum || '0')]);
        }).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            cameraInfo = _ref4[0],
            presetTextEnum = _ref4[1];
          var validEnum = !presetTextEnum.equals(baja.DynamicEnum.DEFAULT);
          _this2.jq().toggle((cameraInfo.storePresetEnabled || cameraInfo.moveToPresetEnabled) && validEnum);
          _this2.$goCommandButton.jq().toggle(cameraInfo.moveToPresetEnabled && validEnum);
          _this2.$storeCommandButton.jq().toggle(cameraInfo.storePresetEnabled && validEnum);
          return fe.buildFor({
            dom: _this2.$getDropDown(),
            value: presetTextEnum,
            type: DynamicEnumEditor
          });
        });
      }

      /**
       * Display an error dialog, inserting the error text into the failure message.
       */
    }, {
      key: "$showErrorDialog",
      value: function $showErrorDialog(err) {
        dialogs.showOk({
          title: lex.get('LiveView.invalidPreset.dialog.title'),
          text: lex.get('LiveView.invalidPreset', err)
        });
      }

      /**
       * Destroys the editor and all children of the editor.
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('CameraPresetsWidget');
        return Promise.all([this.getChildWidgets().destroyAll()]);
      }

      /**
       * @param  {String} name The name of the Property that's changed.
       * @param  {*} value The new Property value.
       * @return {Promise}
       */
    }, {
      key: "doChanged",
      value: function doChanged(name, value) {
        return Promise.resolve();
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getDropDown",
      value: function $getDropDown() {
        return this.jq().find('.dropdown');
      }

      /**
       * Returns the presets dropdown
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getDropDownWidget",
      value: function $getDropDownWidget() {
        return Widget["in"](this.$getDropDown());
      }

      /**
       * @private
       * @returns{JQuery}
       */
    }, {
      key: "$getGoElement",
      value: function $getGoElement() {
        return this.jq().find('.goCommand');
      }

      /**
       * @private
       * @returns{module:bajaux/Widget}
       */
    }, {
      key: "$getGoButton",
      value: function $getGoButton() {
        return Widget["in"](this.$getGoElement());
      }

      /**
       * @private
       * @returns{JQuery}
       */
    }, {
      key: "$getStoreElement",
      value: function $getStoreElement() {
        return this.jq().find('.storeCommand');
      }

      /**
       * @private
       * @returns{module:bajaux/Widget}
       */
    }, {
      key: "$getStoreButton",
      value: function $getStoreButton() {
        return Widget["in"](this.$getStoreElement());
      }

      /**
       * Function is used to get the value of Go Command from the CameraPresetsWidget
       *
       * @private
       * @returns{module:bajaux/commands/Command}
       */
    }, {
      key: "$getGoCommand",
      value: function $getGoCommand() {
        var that = this;
        if (!this.$goCommand) {
          this.$goCommand = new Command({
            module: 'videoDriver',
            lex: 'commands.mgr.go',
            func: function func() {
              return Promise.all([that.$getDropDownWidget().read()["catch"](function (err) {
                return that.$showErrorDialog(err);
              }), rpc.getCameraInfo(that.value().getNavOrd())]).then(function (_ref5) {
                var _ref6 = _slicedToArray(_ref5, 2),
                  actionArgument = _ref6[0],
                  cameraInfo = _ref6[1];
                that.value().invoke({
                  slot: cameraInfo.moveToPresetAction,
                  value: actionArgument
                });
              });
            }
          });
        }
        return this.$goCommand;
      }

      /**
       * Function is used to get the value of Store Command from the CameraPresetsWidget
       *
       * @private
       * @returns{module:bajaux/commands/Command}
       */
    }, {
      key: "$getStoreCommand",
      value: function $getStoreCommand() {
        var that = this;
        if (!this.$storeCommand) {
          this.$storeCommand = new Command({
            module: 'videoDriver',
            lex: 'commands.mgr.store',
            func: function func() {
              return Promise.all([that.$getDropDownWidget().read()["catch"](function (err) {
                return that.$showErrorDialog(err);
              }), rpc.getCameraInfo(that.value().getNavOrd())]).then(function (_ref7) {
                var _ref8 = _slicedToArray(_ref7, 2),
                  actionArgument = _ref8[0],
                  cameraInfo = _ref8[1];
                that.value().invoke({
                  slot: cameraInfo.storePresetAction,
                  value: actionArgument
                });
              });
            }
          });
        }
        return this.$storeCommand;
      }
    }]);
  }(BaseWidget);
  return CameraPresetsWidget;
});
