function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser  */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/hls/HLSVideoStream
 */
define(['baja!', 'log!nmodule.videoDriver.rc.hls.HLSVideoStream', 'hls', 'jquery', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/videoDriver/rc/fe/playback/PlaybackMixin', 'nmodule/videoDriver/rc/fe/utils/videoDriverUtils', 'nmodule/videoDriver/rc/live/VideoFeedMixin', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/util/fileUtils', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, log, Hls, $, Promise, _, asyncUtils, PlaybackMixin, videoDriverUtils, VideoFeedMixin, rpc, BaseEditor, fileUtils) {
  "use strict";

  var startHlsStream = rpc.startHlsStream,
    stopHlsStream = rpc.stopHlsStream;
  var getPlaybackSpeedFactor = videoDriverUtils.getPlaybackSpeedFactor;
  var STREAM_DATA_RECEIVED_EVENT = VideoFeedMixin.STREAM_DATA_RECEIVED_EVENT,
    TIMESTAMP_CHANGED_EVENT = VideoFeedMixin.TIMESTAMP_CHANGED_EVENT;
  var logFine = log.fine.bind(log);
  var WIND_INTERVAL = 100;

  //Muted allows Chrome to autoplay and we don't do sound anyway
  //https://stackoverflow.com/questions/50607588/chrome-video-autoplay/51581844
  var tpl = function tpl() {
    return "  \n    <video autoplay muted class='videoInsert'></video>    \n  ";
  };

  /**
   * Baja Widget for LiveVideo via HLS and ffmpeg transcoding.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/videoDriver/rc/hls/HLSVideoStream
   * @implements module:module:nmodule/videoDriver/rc/fe/playback/PlaybackController
   * @mixes module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin
   * @mixes module:nmodule/videoDriver/rc/live/VideoFeedMixin
   */
  return /*#__PURE__*/function (_BaseEditor) {
    function HLSVideoStream(params) {
      var _this;
      _classCallCheck(this, HLSVideoStream);
      _this = _callSuper(this, HLSVideoStream, [_.extend({
        keyName: 'HLSVideoStream',
        moduleName: 'videoDriver'
      }, params)]);
      PlaybackMixin(_this);
      VideoFeedMixin(_this);
      _this.$hls = null;
      return _this;
    }

    /**
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */
    _inherits(HLSVideoStream, _BaseEditor);
    return _createClass(HLSVideoStream, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl()).addClass('HLSVideoStream');
      }

      /**
       * @param {baja.Component} value a `nvideo:VideoCamera` instance
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this2 = this;
        if (value.isMounted()) {
          return this.$startStreaming(value.getNavOrd().toString()).then(function (_ref) {
            var streamUrl = _ref.streamUrl;
            var video = _this2.$getVideo();
            if (video.canPlayType('application/vnd.apple.mpegurl')) {
              video.src = streamUrl;
              video.addEventListener('canplay', function () {
                video.play();
              });
            } else if (Hls.isSupported()) {
              return _this2.waitForFile(streamUrl);
            } else {
              throw new Error("Browser does not support HLS stream:" + window.navigator.userAgent);
            }
          });
        }
      }

      /**
       * Wait for the the streaming file to be ready.
       * @param {String} streamUrl
       * @param {Number} counter
       * @return {Promise}
       */
    }, {
      key: "waitForFile",
      value: function waitForFile(streamUrl, counter) {
        var _this3 = this;
        if (!counter) {
          counter = 0;
        }
        var ord = streamUrl.replace("/file/", "file:^");
        return Promise.resolve(streamUrl.indexOf("/module/") === 0 || fileUtils.exists(ord)).then(function (exists) {
          if (exists) {
            _this3.doStream(streamUrl);
          } else {
            return asyncUtils.waitInterval(200).then(function () {
              counter++;
              return _this3.waitForFile(streamUrl, counter);
            });
          }
        });
      }

      /**
       * Play the stream 500ms afters its ready.
       *
       * @param {String} streamUrl
       */
    }, {
      key: "doStream",
      value: function doStream(streamUrl) {
        var _this4 = this;
        var video = this.$getVideo();
        var hls = this.$hls = new Hls();
        hls.loadSource(streamUrl);
        hls.attachMedia(video);
        hls.on(Hls.Events.MANIFEST_PARSED, function () {
          setTimeout(function () {
            if (!_this4.isDestroyed()) {
              video.play()["catch"](baja.error);
            }
          }, 500);
        });
      }

      /**
       * Notify the Video Camera to start streaming.
       *
       * @private
       * @param {baja.Ord} ord
       * @return {Promise.<{ streamUrl: string }>}
       */
    }, {
      key: "$startStreaming",
      value: function $startStreaming(ord) {
        return startHlsStream(ord);
      }

      /**
       * Stops hls and notifies the Video Camera to stop streaming too.
       *
       * @private
       * @param {baja.Ord} ord
       * @return {Promise|*}
       */
    }, {
      key: "$stopStreaming",
      value: function $stopStreaming(ord) {
        if (this.$hls && this.value()) {
          this.$hls.stopLoad();
          this.$hls = null;
          return stopHlsStream(ord);
        }
      }

      /**
       * @private
       * @returns {HTMLVideoElement}
       */
    }, {
      key: "$getVideo",
      value: function $getVideo() {
        return $('.videoInsert', this.jq())[0];
      }

      /**
       * @return {Promise|*}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var hls = this.$hls;
        if (hls) {
          hls.destroy();
        }
        this.jq().removeClass('HLSVideoStream');
        if (this.value()) {
          return this.$stopStreaming(this.value().getNavOrd());
        }
      }

      /**
       * @returns {number} current timestamp
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */
    }, {
      key: "getVideoTimestamp",
      value: function getVideoTimestamp() {
        //TODO: can HLS video files themselves be timestamped?
        return this.$currentTimestamp;
      }

      /**
       * @returns {boolean}
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */
    }, {
      key: "isVideoStreaming",
      value: function isVideoStreaming() {
        return !!this.$currentTimestamp;
      }

      /**
       * Called by videoDriverUtils. Emits `TIMESTAMP_CHANGED_EVENT` and `STREAM_DATA_RECEIVED_EVENT`.
       */
    }, {
      key: "timeUpdate",
      value: function timeUpdate() {
        this.$currentTimestamp = +new Date();
        this.emit(TIMESTAMP_CHANGED_EVENT);
        this.emit(STREAM_DATA_RECEIVED_EVENT);
      }

      /**
       * @returns {baja.Component} the currently loaded camera
       */
    }, {
      key: "getCamera",
      value: function getCamera() {
        return this.value();
      }

      /**
       * Change the current playback type and speed.
       * @param {object} params
       * @param {string} [params.type] a `BPlaybackTypeEnum` tag
       * @param {number} [params.speed] playback speed, from 1 to 10
       */
    }, {
      key: "doPlayback",
      value: function doPlayback(_ref2) {
        var type = _ref2.type,
          speed = _ref2.speed;
        clearTimeout(this.$ticket);
        logFine("HLSVideoStream#playback - type: ".concat(type, ", speed: ").concat(speed));
        var video = this.$getVideo();
        if (!video) {
          return;
        }
        switch (type) {
          case 'live':
          case 'play':
            return video.play();
          case 'pause':
            return video.pause();
          case 'slowRew':
          case 'fastRew':
          case 'slowFwd':
          case 'fastFwd':
            return this.$wind(getPlaybackSpeedFactor(type, speed || 1));
        }
      }

      /**
       * Start a rewind/fast-forward.
       * @private
       * @param {number} speedFactor
       */
    }, {
      key: "$wind",
      value: function $wind(speedFactor) {
        var _this5 = this;
        var video = this.$getVideo();
        if (!video) {
          return;
        }
        var secondsPerTick = WIND_INTERVAL / 1000 * speedFactor;
        var currentTime = video.currentTime || 0;
        var duration = video.duration || 0;
        video.pause();
        this.$ticket = setTimeout(function () {
          // if currentTime >= duration, video does not show the change
          video.currentTime = clamp(currentTime + secondsPerTick, 0, duration - 0.00001);
          _this5.$wind(speedFactor);
        }, WIND_INTERVAL);
      }
    }]);
  }(BaseEditor);
  function clamp(num, min, max) {
    return Math.min(Math.max(num, min), max);
  }
});
