/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin
 */
define(['Promise', 'nmodule/js/rc/tinyevents/tinyevents', 'nmodule/videoDriver/rc/live/stream/StreamSettings', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function (Promise, tinyevents, StreamSettings, mixinUtils) {
  'use strict';

  var applyMixin = mixinUtils.applyMixin;
  var MIXIN_NAME = 'videoDriver:StreamConfigurationMixin';

  /**
   * Mixin applied to a VideoStream that marks it as supporting the
   * configuration of the stream (e.g. quality settings like resolution and
   * framerate).
   *
   * @mixin
   * @mixes tinyevents
   * @alias module:nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin
   */
  var StreamConfigurationMixin = function StreamConfigurationMixin(videoStream) {
    if (!applyMixin(videoStream, MIXIN_NAME, StreamConfigurationMixin.prototype)) {
      return;
    }
    tinyevents(videoStream);
  };

  /**
   * @param {*} target
   * @returns {boolean}
   */
  StreamConfigurationMixin.isOn = function (target) {
    return mixinUtils.hasMixin(target, MIXIN_NAME);
  };

  /**
   * @returns {module:nmodule/videoDriver/rc/live/stream/StreamSettings|Promise} the
   * default stream settings for this camera, or promise resolving to it.
   */
  StreamConfigurationMixin.prototype.getDefaultStreamSettings = function () {
    return new StreamSettings();
  };

  /**
   * Apply the given stream settings to the video feed.
   *
   * @param {module:nmodule/videoDriver/rc/live/stream/StreamSettings} settings
   * @returns {Promise|*}
   */
  StreamConfigurationMixin.prototype.applyStreamSettings = function (settings) {
    return Promise.resolve();
  };

  /**
   * @type {string}
   */
  StreamConfigurationMixin.BANDWIDTH_DISPLAY_CHANGE_EVENT = 'videoDriver:bandwidthDisplayChange';

  /**
   * @type {string}
   */
  StreamConfigurationMixin.MIXIN_NAME = MIXIN_NAME;
  return StreamConfigurationMixin;
});
