/**
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Chaitra T H
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module/videoDriver/rc/videoDriverAlarmAdditionalCommandDecorator
 */
define(['bajaux/commands/Command', 'baja!', 'Promise', 'dialogs', 'nmodule/videoDriver/rc/fe/playback/WebVideoPlayback', 'nmodule/videoDriver/rc/fe/utils/videoDriverUtils', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn'], function (Command, baja, Promise, dialogs, WebVideoPlayback, videoDriverUtils, BaseWidget, feDialogs, alarmConsoleCommandMixIn) {
  'use strict';

  /**
   * shows the user to see the video footage that might be associated with an alarm
   *
   * See the alarm console mixin for the extra methods one can override for the alarm console.
   *
   * @constructor
   * @param {module:nmodule/alarm/rc/console/AlarmConsole} view The alarm console view.
   * @extends {module:bajaux/commands/Command}
   * @mixes {module:nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn}
   */
  var ShowVideoCommand = function ShowVideoCommand(view) {
    this.$view = view;
    Command.apply(this, [{
      module: 'videoDriver',
      lex: 'commands.showVideo',
      func: function func() {
        var that = this;
        var _that$$view$getSelect = that.$view.getSelectedAlarmRecords()[0].alarmData,
          cameraOrd = _that$$view$getSelect.cameraOrd,
          sourceName = _that$$view$getSelect.sourceName;
        videoDriverUtils.$remoteVideoCameraResolve(cameraOrd, sourceName).then(function (cameraOrd) {
          var resolvedCameraOrd = "/ord/" + cameraOrd;
          return window.hx.popup(resolvedCameraOrd + "|view:videoDriver:WebVideoPlayback?playbackTimestamp=" + that.$view.getSelectedAlarmRecords()[0].timestamp);
        })["catch"](baja.error);
      },
      enabled: false // The command is disabled by default.
    }]);
    alarmConsoleCommandMixIn(this);

    // If more control is needed over when a command is shown in a right click menu
    // or in the command bar then override the 'showInMenu' and 'showInCommandBar' methods
    // as shown in the alarmConsoleCommandMixIn mixin.
    this.$showInMenu = true;
    this.$showInCommandBar = true;
  };
  ShowVideoCommand.prototype = Object.create(Command.prototype);
  ShowVideoCommand.prototype.constructor = ShowVideoCommand;

  /**
   * Invoked when the alarm console selection changes.
   */

  ShowVideoCommand.prototype.selectionChanged = function () {
    // Only enable the command if some rows are selected.
    if (this.$view.isSelectionEmpty()) {
      this.setEnabled(false);
    } else if (this.$view.getSelectedAlarmRecords().length > 1) {
      this.setEnabled(false);
    } else {
      var cameraHandleOrd = this.$view.getSelectedAlarmRecords()[0].alarmData.cameraHandleOrd;
      var cameraOrd = this.$view.getSelectedAlarmRecords()[0].alarmData.cameraOrd;
      if (cameraHandleOrd == null && cameraOrd == null) {
        this.setEnabled(false);
      } else {
        this.setEnabled(true);
      }
    }
  };
  return function decorate(view, params) {
    var group = view.getCommandGroup();
    group.add(new ShowVideoCommand(view));
  };
});
