/**************************************************************************
Copyright 2015 Honeywell International Sàrl
**************************************************************************/

var MJPEG = (function(module) {
  var elem = document.getElementById("changeText");
  var url;
  const reverseDirection = "REVERSE";
  const forwardDirection = "FORWARD";
  const controlMessage = "CONTROL";
  const protocolVersion = "1.0";
    // class Stream { ...
    module.Stream = function(args) {
      var self = this;
      var autoStart = args.autoStart || false;
  
      self.url = args.url; 
      self.refreshRate = args.refreshRate || 1000;
      self.onStart = args.onStart || null;
      self.onFrame = args.onFrame || null;
      self.onStop = args.onStop || null;
      self.callbacks = {};
      self.running = false;
      self.frameTimer = 0;
  
      self.img = new Image();
      if (autoStart) {
        self.img.onload = self.start;
      }
        self.img.src = self.url;
        
      function setRunning(running) {
        self.running = running;
        if (self.running) {
          self.img.src = self.url;
          self.frameTimer = setTimeout(function() {
            if (self.onFrame) {
              self.onFrame(self.img);
            }
          }, self.refreshRate);
          if (self.onStart) {
            self.onStart();
          }
        } else {
          self.img.src = "#";
          clearInterval(self.frameTimer);
          if (self.onStop) {
            self.onStop();
          }
        }
      }
      
      self.start = function() { setRunning(true); }
      self.stop = function() { setRunning(false); }
	  self.dispose = function () {setRunning(false);}
    };
  
    // class Player { ...
    module.Player = function(canvas, url, options) {
      var self = this;
      self.playing_ = false;
	  self.onNotification = null;
	  self.onTimePosition = options.onTimePosition;
	  self.waitSyncTimePosition = false;
	  self.currentTimePosition = new Date().getTime();
	  self.startTimePosition = null;
	  self.web_socket;
	  self.supportedSpeeds = [
        "-16",
        "-8",
        "-4",
        "-2",
        "-1",
        "-1/2",
        "-1/5",
        "-1/10",
        "1/10",
        "1/5",
        "1/2",
        "1",
        "2",
        "4",
        "8",
        "16"
      ];
	  self.speedIndex = options.playbackSpeed;
      if (typeof canvas === "string" || canvas instanceof String) {
        canvas = document.getElementById(canvas);
      }
      var context = canvas.getContext("2d");
      setupWebsocket();

      function updateStream(blobUrl)
      {
        if (! options) {
          options = {};
        }
        options.url = blobUrl;
        options.onFrame = updateFrame;
        //options.onStart = function() { console.log("started"); } //Tridium Customization required v 2.1
        options.onStop = function() { console.log("stopped"); }
    
        self.stream = new module.Stream(options);

        self.start = function() { self.stream.start(); }
        self.stop = function() { self.stream.stop(); }
		self.dispose = function() { dispose(); }

        if (self.stream.running) { 
          self.stop();
          self.playing_ = false;
         }
        else { 
          self.start();
          self.playing_ = true; 
        }
      }

      function setupWebsocket() {
          var sub_protocol = "lws-video";
          self.web_socket = new WebSocket(url, sub_protocol);
          self.web_socket.binaryType = "arraybuffer";
            self.web_socket.onopen = function() {
              console.log("web_socket_.onopen");
			  adjustSpeed(self.speedIndex);
            };
            self.web_socket.onerror = function(err) {
              console.log("web_socket_.onerror");
              if (self.stateCallback !== undefined) {
                self.stateCallback("web_socket_.onerror");
              }
            };
            self.web_socket.onmessage = function (e) {
              //console.log('Server: ' + e.data);
              if (typeof e.data === "string") {
                processStringMessage(e.data);
              } else if (e.data instanceof ArrayBuffer) {
                //Process Image Data
                arrayBufferWithJPEG = e.data;
                arrayBufferedSliced = arrayBufferWithJPEG.slice(20,e.data.byteLength);
                var blob = new Blob([arrayBufferedSliced], {type: "image/jpeg"});
				arrayBufferWithJPEG? delete arrayBufferWithJPEG:null;
				arrayBufferedSliced? delete arrayBufferedSliced:null;
				if (url) {
						window.URL.revokeObjectURL(url);
						}
                 url = window.URL.createObjectURL(blob);
                updateStream(url);
              }
            };

            self.web_socket.onclose = function(evt) {
              console.log("web_socket_.onclose");
              self.startTimePosition = null;
              if (self.playing_) {
                setupWebsocket();
              }
            };	
		}
		
		function adjustSpeed(newSpeedIndex) {
          const speedCommand = getSpeedCommand(
            self.supportedSpeeds[newSpeedIndex]
          );
          self.web_socket.send(speedCommand);
          self.speedIndex = newSpeedIndex;
          //this.clearAllVideoCache();
          /*if (this.onSpeedChange) {
            this.onSpeedChange(this.supportedSpeeds[newSpeedIndex]);
          }*/
        }
		
		function getSpeedCommand(speed) {
			const isReverse = speed.startsWith("-");
			const direction = isReverse ? reverseDirection : forwardDirection;
			const unsignedSpeed = isReverse ? speed.slice(1) : speed;
			const speedCommand = {
				"MessageType": controlMessage,
				"Version": protocolVersion,
				"Sequence": getSequence(),
				"Request": {
					"Paused": false,
					"CameraID": "",
					"OpenStream": false,
					"Direction": direction,
					"Speed": unsignedSpeed
      }
    };
    return JSON.stringify(speedCommand);
  }		  
		  
		function processStringMessage(data) {
          const notifyData = JSON.parse(data);
          if (notifyData.MessageType === "TIMEPOSITION") {
            if (
              self.waitSyncTimePosition !== true ||
              notifyData.Sync === true
            ) {
              self.currentTimePosition = notifyData.Timestamp;
				var dt = new Date(notifyData.Timestamp);
				//GetTimeStamp(callbackForTimeStamp);
              if (self.startTimePosition === null) {
                self.startTimePosition = notifyData.Timestamp;
              }
              if (notifyData.Sync === true) {
                self.waitSyncTimePosition = false;
                setCurrentTime(
                  (notifyData.Timestamp - self.startTimePosition) / 1000
                );
              }
              if (self.onTimePosition) {
				   
                self.onTimePosition(notifyData);
              }
            }
          } else if (self.onNotification) {
				self.onNotification(notifyData);
          }
        }
		
		function pause() {
          if (self.web_socket !== undefined) {
            const pauseCommand = self.protocolHelper.getPauseControlCommand(
              true
            );
            self.web_socket.send(pauseCommand);
            self.playing_ = false;
          }
        }
		
		function dispose() {
          self.playing_ = false;
		  self.startTimePosition = null;
		  self.stream = null;
          if (self.web_socket !== undefined) {self.web_socket.close();}
      if (elem) { elem.innerHTML = " "; } //Tridium Customization required v 2.1
		  canvas.style.display = "none";
		}
		
		function setCurrentTime(time) {
          try {
            this.el_.currentTime = time;
          } catch (e) {
            //console.log(e, "Video is not ready. (Video.js)");
            // this.warning(VideoJS.warnings.videoNotReady);
          }
        }
  
      function scaleRect(srcSize, dstSize) {
        var ratio = Math.min(dstSize.width / srcSize.width,
                             dstSize.height / srcSize.height);
        var newRect = {
          x: 0, y: 0,
          width: srcSize.width * ratio,
          height: srcSize.height * ratio
        };
        newRect.x = (dstSize.width/2) - (newRect.width/2);
        newRect.y = (dstSize.height/2) - (newRect.height/2);
        return newRect;
      }
  
      function updateFrame(img) {
          var srcRect = {
            x: 0, y: 0,
            width: img.naturalWidth,
            height: img.naturalHeight
          };
          var dstRect = scaleRect(srcRect, {
            width: canvas.width,
            height: canvas.height
          });
        try {
			
			context.drawImage(img,
            srcRect.x,
            srcRect.y,
            srcRect.width,
            srcRect.height,
            dstRect.x,
            dstRect.y,
            dstRect.width,
            dstRect.height);			
		  
        } catch (e) {
          // if we can't draw, don't bother updating anymore
          self.stop();
          console.log("!");
          throw e;
        }
      } 
    };
  
    return module;
  
  })(MJPEG || {});
