(function(global, factory) {
  if (typeof exports === "object" && typeof module !== undefined) {
    //check if is CommonJS
    module.exports = factory(
      require("./dependency/video-js.min"),
      require("./dependency/videojsfmp4.min")
    );
  } else if (typeof define === "function" && define.amd) {
    //check if is AMD
    define([
      "./dependency/video-js.min",
      "./dependency/videojsfmp4.min"
    ], factory);
  } else {
    global.StdVideoPlayer = factory(global, factory);
  }
})(this, function(videojsJ) {
  if (typeof define === "function" && define.amd) videojs = videojsJ;

  /*const playerOption = {
    videoElement: "<video></video>",                             [Required]
    streamUrl: "wss://streamingserver",                          [Required]
    cameraId: "101",                                             [Required]
    videoPlayMode:'live'                                         [Required]
    onNotification: (data) => alert("onNotification func"),      [Optional]
    onTimePosition: (data) => alert("onTimePosition func"),      [Optional]
    onSpeedChange: (data) => alert("onSpeedChange func"),        [Optional]
    speedConfig: {                                               [Optional]
      supportedSpeeds: ["-4", "-2", "1", "2", "4"],              [Optional]
      defaultSpeedIndex: 2                                       [Optional]
    },
    playbackSecondsOffset: -30                                   [Optional]
  };*/
  function _play(playerOption) {
    const srcUrl = protocolFormater().getPlaybackUrlParameter(playerOption.streamUrl, playerOption);
    var tagId = playerOption.videoElement;
    var jsVideoPlayer = "";

    if (tagId && srcUrl) {
      console.log("Play");

      const oldPlayer = videojs.getPlayer(tagId);
      if (oldPlayer !== undefined) {
        if (
          oldPlayer.playerOption &&
          oldPlayer.playerOption.videoPlayMode === playerOption.videoPlayMode &&
          oldPlayer.playerOption.cameraId === playerOption.cameraId
        ) {
          return;
        }

        const videoContainer = oldPlayer.el().parentElement;
        if (videoContainer !== null) {
          const newElement =
            '<video muted="" class="video-js vjs-fill" width="100%" height="100%"></video>';
          videoContainer.insertAdjacentHTML("beforeend", newElement);
          tagId = videoContainer.lastElementChild;
        }
        oldPlayer.dispose();
      }

      jsVideoPlayer = videojs(tagId, {
        autoplay: true,
        sources: [
          {
            src: srcUrl,
            type: "video/fmp4"
          }
        ],
        techOrder: ["fmp4"],
        preload: "auto"
      });
    }

    _registerEventHandler(jsVideoPlayer, "ready", function() {
      const fmp4Tech = jsVideoPlayer.tech(null);
      if (fmp4Tech) {
        fmp4Tech.setTechOption(playerOption);
      }
    });
    jsVideoPlayer.playerOption = playerOption;
    return jsVideoPlayer;
  }
  function _enableFullscreen(player) {
    if (player) {
      player.on("auxclick", function() {
        if (player.isFullscreen()) {
          player.exitFullscreen();
        } else {
          player.requestFullscreen();
        }
      });
    }
  }

  function _stop(player) {
    if (player) {
      player.dispose();
    }
  }

  function _registerEventHandler(player, eventName, handler) {
    if (player) {
      player.on(eventName, handler);
    }
  }

  function _pause(player) {
    if (player) {
      player.pause();
    }
  }

  function _seekOffset(player, secondsOffset) {
    if (player) {
      const fmp4Tech = player.tech(null);
      if (fmp4Tech) {
        fmp4Tech.seekTo(secondsOffset);
      }
    }
  }

  function _rewind(player) {
    if (player) {
      const fmp4Tech = player.tech(null);
      if (fmp4Tech) {
        fmp4Tech.rewind();
      }
    }
  }

  function _fasterSpeed(player) {
    if (player) {
      const fmp4Tech = player.tech(null);
      if (fmp4Tech) {
        fmp4Tech.fasterSpeed();
      }
    }
  }

  function _slowerSpeed(player) {
    if (player) {
      const fmp4Tech = player.tech(null);
      if (fmp4Tech) {
        fmp4Tech.slowerSpeed();
      }
    }
  }

  function _resetSpeed(player) {
    if (player) {
      const fmp4Tech = player.tech(null);
      if (fmp4Tech) {
        fmp4Tech.resetSpeed();
      }
    }
  }

  function _resume(player) {
    if (player) {
      const fmp4Tech = player.tech(null);
      if (fmp4Tech) {
        fmp4Tech.resume();
      }
    }
  }

  function _isPlayerExisted(element, playMode) {
    const videoElement =
      $(element).children("video")[0] ||
      $(element)
        .children()
        .children("video")[0];
    if (videoElement === undefined) return false;
    const player = videojs.getPlayer(videoElement);
    if (player === "" || player === undefined) return false;
    if (player.playerOption && player.playerOption.videoPlayMode !== playMode)
      return false;
    return true;
  }
  return {
    Play: _play,
    Stop: _stop,
    EnableFullscreen: _enableFullscreen,
    RegisterEventHandler: _registerEventHandler,
    Pause: _pause,
    SeekOffset: _seekOffset,
    Rewind: _rewind,
    FasterSpeed: _fasterSpeed,
    SlowerSpeed: _slowerSpeed,
    ResetSpeed: _resetSpeed,
    Resume: _resume,
    IsPlayerExisted: _isPlayerExisted
  };
});
